/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.ScopeInterface;
import de.thjom.java.systemd.types.DeviceAllowControl;
import de.thjom.java.systemd.types.IOBandwidth;
import de.thjom.java.systemd.types.IODeviceWeight;
import java.math.BigInteger;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;

public class Scope
extends Unit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Scope";
    public static final String UNIT_SUFFIX = ".scope";

    private Scope(Manager manager, ScopeInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Scope create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        ScopeInterface iface = (ScopeInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, ScopeInterface.class);
        return new Scope(manager, iface, name);
    }

    @Override
    public ScopeInterface getInterface() {
        return (ScopeInterface)super.getInterface();
    }

    public boolean isBlockIOAccounting() {
        return this.properties.getBoolean("BlockIOAccounting");
    }

    public List<IODeviceWeight> getBlockIODeviceWeight() {
        return IODeviceWeight.list(this.properties.getVector("BlockIODeviceWeight"));
    }

    public List<IOBandwidth> getBlockIOReadBandwidth() {
        return IOBandwidth.list(this.properties.getVector("BlockIOReadBandwidth"));
    }

    public BigInteger getBlockIOWeight() {
        return this.properties.getBigInteger("BlockIOWeight");
    }

    public List<IOBandwidth> getBlockIOWriteBandwidth() {
        return IOBandwidth.list(this.properties.getVector("BlockIOWriteBandwidth"));
    }

    public boolean isCPUAccounting() {
        return this.properties.getBoolean("CPUAccounting");
    }

    public BigInteger getCPUShares() {
        return this.properties.getBigInteger("CPUShares");
    }

    public String getControlGroup() {
        return this.properties.getString("ControlGroup");
    }

    public String getController() {
        return this.properties.getString("Controller");
    }

    public List<DeviceAllowControl> getDeviceAllow() {
        return DeviceAllowControl.list(this.properties.getVector("DeviceAllow"));
    }

    public String getDevicePolicy() {
        return this.properties.getString("DevicePolicy");
    }

    public String getKillMode() {
        return this.properties.getString("KillMode");
    }

    public int getKillSignal() {
        return this.properties.getInteger("KillSignal");
    }

    public boolean isMemoryAccounting() {
        return this.properties.getBoolean("MemoryAccounting");
    }

    public BigInteger getMemoryLimit() {
        return this.properties.getBigInteger("MemoryLimit");
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public boolean isSendSIGHUP() {
        return this.properties.getBoolean("SendSIGHUP");
    }

    public boolean isSendSIGKILL() {
        return this.properties.getBoolean("SendSIGKILL");
    }

    public String getSlice() {
        return this.properties.getString("Slice");
    }

    public BigInteger getTimeoutStopUSec() {
        return this.properties.getBigInteger("TimeoutStopUSec");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String BLOCK_IO_ACCOUNTING = "BlockIOAccounting";
        public static final String BLOCK_IO_DEVICE_WEIGHT = "BlockIODeviceWeight";
        public static final String BLOCK_IO_READ_BANDWIDTH = "BlockIOReadBandwidth";
        public static final String BLOCK_IO_WEIGHT = "BlockIOWeight";
        public static final String BLOCK_IO_WRITE_BANDWIDTH = "BlockIOWriteBandwidth";
        public static final String CPU_ACCOUNTING = "CPUAccounting";
        public static final String CPU_SHARES = "CPUShares";
        public static final String CONTROL_GROUP = "ControlGroup";
        public static final String CONTROLLER = "Controller";
        public static final String DEVICE_ALLOW = "DeviceAllow";
        public static final String DEVICE_POLICY = "DevicePolicy";
        public static final String KILL_MODE = "KillMode";
        public static final String KILL_SIGNAL = "KillSignal";
        public static final String MEMORY_ACCOUNTING = "MemoryAccounting";
        public static final String MEMORY_LIMIT = "MemoryLimit";
        public static final String RESULT = "Result";
        public static final String SEND_SIGHUP = "SendSIGHUP";
        public static final String SEND_SIGKILL = "SendSIGKILL";
        public static final String SLICE = "Slice";
        public static final String TIMEOUT_STOP_USEC = "TimeoutStopUSec";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

