/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.ServiceInterface;
import de.thjom.java.systemd.types.AddressFamilyRestriction;
import de.thjom.java.systemd.types.AppArmorProfile;
import de.thjom.java.systemd.types.DeviceAllowControl;
import de.thjom.java.systemd.types.EnvironmentFile;
import de.thjom.java.systemd.types.ExecutionInfo;
import de.thjom.java.systemd.types.IOBandwidth;
import de.thjom.java.systemd.types.IODeviceWeight;
import de.thjom.java.systemd.types.SELinuxContext;
import de.thjom.java.systemd.types.SmackProcessLabel;
import de.thjom.java.systemd.types.SystemCallFilter;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import org.freedesktop.dbus.exceptions.DBusException;

public class Service
extends Unit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Service";
    public static final String UNIT_SUFFIX = ".service";

    private Service(Manager manager, ServiceInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Service create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        ServiceInterface iface = (ServiceInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, ServiceInterface.class);
        return new Service(manager, iface, name);
    }

    @Override
    public ServiceInterface getInterface() {
        return (ServiceInterface)super.getInterface();
    }

    public AppArmorProfile getAppArmorProfile() {
        Object[] array = (Object[])this.properties.getVariant("AppArmorProfile").getValue();
        return new AppArmorProfile(array);
    }

    public boolean isBlockIOAccounting() {
        return this.properties.getBoolean("BlockIOAccounting");
    }

    public List<IODeviceWeight> getBlockIODeviceWeight() {
        return IODeviceWeight.list(this.properties.getVector("BlockIODeviceWeight"));
    }

    public List<IOBandwidth> getBlockIOReadBandwidth() {
        return IOBandwidth.list(this.properties.getVector("BlockIOReadBandwidth"));
    }

    public BigInteger getBlockIOWeight() {
        return this.properties.getBigInteger("BlockIOWeight");
    }

    public List<IOBandwidth> getBlockIOWriteBandwidth() {
        return IOBandwidth.list(this.properties.getVector("BlockIOWriteBandwidth"));
    }

    public String getBusName() {
        return this.properties.getString("BusName");
    }

    public boolean isCPUAccounting() {
        return this.properties.getBoolean("CPUAccounting");
    }

    public byte[] getCPUAffinity() {
        return (byte[])this.properties.getVariant("CPUAffinity").getValue();
    }

    public BigInteger getCPUQuotaPerSecUSec() {
        return this.properties.getBigInteger("CPUQuotaPerSecUSec");
    }

    public int getCPUSchedulingPolicy() {
        return this.properties.getInteger("CPUSchedulingPolicy");
    }

    public int getCPUSchedulingPriority() {
        return this.properties.getInteger("CPUSchedulingPriority");
    }

    public boolean isCPUSchedulingResetOnFork() {
        return this.properties.getBoolean("CPUSchedulingResetOnFork");
    }

    public BigInteger getCPUShares() {
        return this.properties.getBigInteger("CPUShares");
    }

    public BigInteger getCPUUsageNSec() {
        return this.properties.getBigInteger("CPUUsageNSec");
    }

    public String getCapabilities() {
        return this.properties.getString("Capabilities");
    }

    public BigInteger getCapabilityBoundingSet() {
        return this.properties.getBigInteger("CapabilityBoundingSet");
    }

    public String getControlGroup() {
        return this.properties.getString("ControlGroup");
    }

    public long getControlPID() {
        return this.properties.getLong("ControlPID");
    }

    public boolean isDelegate() {
        return this.properties.getBoolean("Delegate");
    }

    public List<DeviceAllowControl> getDeviceAllow() {
        return DeviceAllowControl.list(this.properties.getVector("DeviceAllow"));
    }

    public String getDevicePolicy() {
        return this.properties.getString("DevicePolicy");
    }

    public Vector<String> getEnvironment() {
        return this.properties.getVector("Environment");
    }

    public List<EnvironmentFile> getEnvironmentFiles() {
        return EnvironmentFile.list(this.properties.getVector("EnvironmentFiles"));
    }

    public int getExecMainCode() {
        return this.properties.getInteger("ExecMainCode");
    }

    public long getExecMainExitTimestamp() {
        return this.properties.getLong("ExecMainExitTimestamp");
    }

    public long getExecMainExitTimestampMonotonic() {
        return this.properties.getLong("ExecMainExitTimestampMonotonic");
    }

    public long getExecMainPID() {
        return this.properties.getLong("ExecMainPID");
    }

    public long getExecMainStartTimestamp() {
        return this.properties.getLong("ExecMainStartTimestamp");
    }

    public long getExecMainStartTimestampMonotonic() {
        return this.properties.getLong("ExecMainStartTimestampMonotonic");
    }

    public int getExecMainStatus() {
        return this.properties.getInteger("ExecMainStatus");
    }

    public List<ExecutionInfo> getExecReload() {
        return ExecutionInfo.list(this.properties.getVector("ExecReload"));
    }

    public List<ExecutionInfo> getExecStart() {
        return ExecutionInfo.list(this.properties.getVector("ExecStart"));
    }

    public List<ExecutionInfo> getExecStartPost() {
        return ExecutionInfo.list(this.properties.getVector("ExecStartPost"));
    }

    public List<ExecutionInfo> getExecStartPre() {
        return ExecutionInfo.list(this.properties.getVector("ExecStartPre"));
    }

    public List<ExecutionInfo> getExecStop() {
        return ExecutionInfo.list(this.properties.getVector("ExecStop"));
    }

    public List<ExecutionInfo> getExecStopPost() {
        return ExecutionInfo.list(this.properties.getVector("ExecStopPost"));
    }

    public String getFailureAction() {
        return this.properties.getString("FailureAction");
    }

    public long getFileDescriptorStoreMax() {
        return this.properties.getLong("FileDescriptorStoreMax");
    }

    public String getGroup() {
        return this.properties.getString("Group");
    }

    public boolean isGuessMainPID() {
        return this.properties.getBoolean("GuessMainPID");
    }

    public int getIOScheduling() {
        return this.properties.getInteger("IOScheduling");
    }

    public boolean isIgnoreSIGPIPE() {
        return this.properties.getBoolean("IgnoreSIGPIPE");
    }

    public Vector<String> getInaccessibleDirectories() {
        return this.properties.getVector("InaccessibleDirectories");
    }

    public String getKillMode() {
        return this.properties.getString("KillMode");
    }

    public int getKillSignal() {
        return this.properties.getInteger("KillSignal");
    }

    public BigInteger getLimitAS() {
        return this.properties.getBigInteger("LimitAS");
    }

    public BigInteger getLimitCORE() {
        return this.properties.getBigInteger("LimitCORE");
    }

    public BigInteger getLimitCPU() {
        return this.properties.getBigInteger("LimitCPU");
    }

    public BigInteger getLimitDATA() {
        return this.properties.getBigInteger("LimitDATA");
    }

    public BigInteger getLimitFSIZE() {
        return this.properties.getBigInteger("LimitFSIZE");
    }

    public BigInteger getLimitLOCKS() {
        return this.properties.getBigInteger("LimitLOCKS");
    }

    public BigInteger getLimitMEMLOCK() {
        return this.properties.getBigInteger("LimitMEMLOCK");
    }

    public BigInteger getLimitMSGQUEUE() {
        return this.properties.getBigInteger("LimitMSGQUEUE");
    }

    public BigInteger getLimitNICE() {
        return this.properties.getBigInteger("LimitNICE");
    }

    public BigInteger getLimitNOFILE() {
        return this.properties.getBigInteger("LimitNOFILE");
    }

    public BigInteger getLimitNPROC() {
        return this.properties.getBigInteger("LimitNPROC");
    }

    public BigInteger getLimitRSS() {
        return this.properties.getBigInteger("LimitRSS");
    }

    public BigInteger getLimitRTPRIO() {
        return this.properties.getBigInteger("LimitRTPRIO");
    }

    public BigInteger getLimitRTTIME() {
        return this.properties.getBigInteger("LimitRTTIME");
    }

    public BigInteger getLimitSIGPENDING() {
        return this.properties.getBigInteger("LimitSIGPENDING");
    }

    public BigInteger getLimitSTACK() {
        return this.properties.getBigInteger("LimitSTACK");
    }

    public int getMainPID() {
        return this.properties.getInteger("MainPID");
    }

    public boolean isMemoryAccounting() {
        return this.properties.getBoolean("MemoryAccounting");
    }

    public BigInteger getMemoryCurrent() {
        return this.properties.getBigInteger("MemoryCurrent");
    }

    public BigInteger getMemoryLimit() {
        return this.properties.getBigInteger("MemoryLimit");
    }

    public BigInteger getMountFlags() {
        return this.properties.getBigInteger("MountFlags");
    }

    public long getNFileDescriptorStore() {
        return this.properties.getLong("NFileDescriptorStore");
    }

    public int getNice() {
        return this.properties.getInteger("Nice");
    }

    public boolean isNoNewPrivileges() {
        return this.properties.getBoolean("NoNewPrivileges");
    }

    public boolean isNonBlocking() {
        return this.properties.getBoolean("NonBlocking");
    }

    public String getNotifyAccess() {
        return this.properties.getString("NotifyAccess");
    }

    public int getOOMScoreAdjust() {
        return this.properties.getInteger("OOMScoreAdjust");
    }

    public String getPAMName() {
        return this.properties.getString("PAMName");
    }

    public String getPIDFile() {
        return this.properties.getString("PIDFile");
    }

    public Vector<String> getPassEnvironment() {
        return this.properties.getVector("PassEnvironment");
    }

    public boolean isPermissionsStartOnly() {
        return this.properties.getBoolean("PermissionsStartOnly");
    }

    public String getPersonality() {
        return this.properties.getString("Personality");
    }

    public boolean isPrivateDevices() {
        return this.properties.getBoolean("PrivateDevices");
    }

    public boolean isPrivateNetwork() {
        return this.properties.getBoolean("PrivateNetwork");
    }

    public boolean isPrivateTmp() {
        return this.properties.getBoolean("PrivateTmp");
    }

    public String getProtectHome() {
        return this.properties.getString("ProtectHome");
    }

    public String getProtectSystem() {
        return this.properties.getString("ProtectSystem");
    }

    public Vector<String> getReadOnlyDirectories() {
        return this.properties.getVector("ReadOnlyDirectories");
    }

    public Vector<String> getReadWriteDirectories() {
        return this.properties.getVector("ReadWriteDirectories");
    }

    public String getRebootArgument() {
        return this.properties.getString("RebootArgument");
    }

    public boolean isRemainAfterExit() {
        return this.properties.getBoolean("RemainAfterExit");
    }

    public String getRestart() {
        return this.properties.getString("Restart");
    }

    public BigInteger getRestartUSec() {
        return this.properties.getBigInteger("RestartUSec");
    }

    public AddressFamilyRestriction getRestrictAddressFamilies() {
        Object[] array = (Object[])this.properties.getVariant("RestrictAddressFamilies").getValue();
        return new AddressFamilyRestriction(array);
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public String getRootDirectory() {
        return this.properties.getString("RootDirectory");
    }

    public boolean isRootDirectoryStartOnly() {
        return this.properties.getBoolean("RootDirectoryStartOnly");
    }

    public Vector<String> getRuntimeDirectory() {
        return this.properties.getVector("RuntimeDirectory");
    }

    public long getRuntimeDirectoryMode() {
        return this.properties.getLong("RuntimeDirectoryMode");
    }

    public BigInteger getRuntimeMaxUSec() {
        return this.properties.getBigInteger("RuntimeMaxUSec");
    }

    public SELinuxContext getSELinuxContext() {
        Object[] array = (Object[])this.properties.getVariant("SELinuxContext").getValue();
        return new SELinuxContext(array);
    }

    public boolean isSameProcessGroup() {
        return this.properties.getBoolean("SameProcessGroup");
    }

    public int getSecureBits() {
        return this.properties.getInteger("SecureBits");
    }

    public boolean isSendSIGHUP() {
        return this.properties.getBoolean("SendSIGHUP");
    }

    public boolean isSendSIGKILL() {
        return this.properties.getBoolean("SendSIGKILL");
    }

    public String getSlice() {
        return this.properties.getString("Slice");
    }

    public SmackProcessLabel getSmackProcessLabel() {
        Object[] array = (Object[])this.properties.getVariant("SmackProcessLabel").getValue();
        return new SmackProcessLabel(array);
    }

    public String getStandardError() {
        return this.properties.getString("StandardError");
    }

    public String getStandardInput() {
        return this.properties.getString("StandardInput");
    }

    public String getStandardOutput() {
        return this.properties.getString("StandardOutput");
    }

    public String getStartLimitAction() {
        return this.properties.getString("StartLimitAction");
    }

    public long getStartLimitBurst() {
        return this.properties.getLong("StartLimitBurst");
    }

    public BigInteger getStartLimitInterval() {
        return this.properties.getBigInteger("StartLimitInterval");
    }

    public BigInteger getStartupBlockIOWeight() {
        return this.properties.getBigInteger("StartupBlockIOWeight");
    }

    public BigInteger getStartupCPUShares() {
        return this.properties.getBigInteger("StartupCPUShares");
    }

    public int getStatusErrno() {
        return this.properties.getInteger("StatusErrno");
    }

    public String getStatusText() {
        return this.properties.getString("StatusText");
    }

    public Vector<String> getSupplementaryGroups() {
        return this.properties.getVector("SupplementaryGroups");
    }

    public int getSyslogFacility() {
        return this.properties.getInteger("SyslogFacility");
    }

    public String getSyslogIdentifier() {
        return this.properties.getString("SyslogIdentifier");
    }

    public int getSyslogLevel() {
        return this.properties.getInteger("SyslogLevel");
    }

    public boolean isSyslogLevelPrefix() {
        return this.properties.getBoolean("SyslogLevelPrefix");
    }

    public int getSyslogPriority() {
        return this.properties.getInteger("SyslogPriority");
    }

    public Vector<String> getSystemCallArchitectures() {
        return this.properties.getVector("SystemCallArchitectures");
    }

    public int getSystemCallErrorNumber() {
        return this.properties.getInteger("SystemCallErrorNumber");
    }

    public SystemCallFilter getSystemCallFilter() {
        Object[] array = (Object[])this.properties.getVariant("SystemCallFilter").getValue();
        return new SystemCallFilter(array);
    }

    public String getTTYPath() {
        return this.properties.getString("TTYPath");
    }

    public boolean isTTYReset() {
        return this.properties.getBoolean("TTYReset");
    }

    public boolean isTTYVHangup() {
        return this.properties.getBoolean("TTYVHangup");
    }

    public boolean isTTYVTDisallocate() {
        return this.properties.getBoolean("TTYVTDisallocate");
    }

    public boolean isTasksAccounting() {
        return this.properties.getBoolean("TasksAccounting");
    }

    public BigInteger getTasksCurrent() {
        return this.properties.getBigInteger("TasksCurrent");
    }

    public BigInteger getTasksMax() {
        return this.properties.getBigInteger("TasksMax");
    }

    public BigInteger getTimeoutStartUSec() {
        return this.properties.getBigInteger("TimeoutStartUSec");
    }

    public BigInteger getTimeoutStopUSec() {
        return this.properties.getBigInteger("TimeoutStopUSec");
    }

    public BigInteger getTimerSlackNSec() {
        return this.properties.getBigInteger("TimerSlackNSec");
    }

    public String getType() {
        return this.properties.getString("Type");
    }

    public long getUMask() {
        return this.properties.getLong("UMask");
    }

    public String getUSBFunctionDescriptors() {
        return this.properties.getString("USBFunctionDescriptors");
    }

    public String getUSBFunctionStrings() {
        return this.properties.getString("USBFunctionStrings");
    }

    public String getUser() {
        return this.properties.getString("User");
    }

    public String getUtmpIdentifier() {
        return this.properties.getString("UtmpIdentifier");
    }

    public String getUtmpMode() {
        return this.properties.getString("UtmpMode");
    }

    public long getWatchdogTimestamp() {
        return this.properties.getLong("WatchdogTimestamp");
    }

    public long getWatchdogTimestampMonotonic() {
        return this.properties.getLong("WatchdogTimestampMonotonic");
    }

    public BigInteger getWatchdogUSec() {
        return this.properties.getBigInteger("WatchdogUSec");
    }

    public String getWorkingDirectory() {
        return this.properties.getString("WorkingDirectory");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String APP_ARMOR_PROFILE = "AppArmorProfile";
        public static final String BLOCK_IO_ACCOUNTING = "BlockIOAccounting";
        public static final String BLOCK_IO_DEVICE_WEIGHT = "BlockIODeviceWeight";
        public static final String BLOCK_IO_READ_BANDWIDTH = "BlockIOReadBandwidth";
        public static final String BLOCK_IO_WEIGHT = "BlockIOWeight";
        public static final String BLOCK_IO_WRITE_BANDWIDTH = "BlockIOWriteBandwidth";
        public static final String BUS_NAME = "BusName";
        public static final String CPU_ACCOUNTING = "CPUAccounting";
        public static final String CPU_AFFINITY = "CPUAffinity";
        public static final String CPU_QUOTA_PER_SEC_USEC = "CPUQuotaPerSecUSec";
        public static final String CPU_SCHEDULING_POLICY = "CPUSchedulingPolicy";
        public static final String CPU_SCHEDULING_PRIORITY = "CPUSchedulingPriority";
        public static final String CPU_SCHEDULING_RESET_ON_FORK = "CPUSchedulingResetOnFork";
        public static final String CPU_SHARES = "CPUShares";
        public static final String CPU_USAGE_NSEC = "CPUUsageNSec";
        public static final String CAPABILITIES = "Capabilities";
        public static final String CAPABILITY_BOUNDING_SET = "CapabilityBoundingSet";
        public static final String CONTROL_GROUP = "ControlGroup";
        public static final String CONTROL_PID = "ControlPID";
        public static final String DELEGATE = "Delegate";
        public static final String DEVICE_ALLOW = "DeviceAllow";
        public static final String DEVICE_POLICY = "DevicePolicy";
        public static final String ENVIRONMENT = "Environment";
        public static final String ENVIRONMENT_FILES = "EnvironmentFiles";
        public static final String EXEC_MAIN_CODE = "ExecMainCode";
        public static final String EXEC_MAIN_EXIT_TIMESTAMP = "ExecMainExitTimestamp";
        public static final String EXEC_MAIN_EXIT_TIMESTAMP_MONOTONIC = "ExecMainExitTimestampMonotonic";
        public static final String EXEC_MAIN_PID = "ExecMainPID";
        public static final String EXEC_MAIN_START_TIMESTAMP = "ExecMainStartTimestamp";
        public static final String EXEC_MAIN_START_TIMESTAMP_MONOTONIC = "ExecMainStartTimestampMonotonic";
        public static final String EXEC_MAIN_STATUS = "ExecMainStatus";
        public static final String EXEC_RELOAD = "ExecReload";
        public static final String EXEC_START = "ExecStart";
        public static final String EXEC_START_POST = "ExecStartPost";
        public static final String EXEC_START_PRE = "ExecStartPre";
        public static final String EXEC_STOP = "ExecStop";
        public static final String EXEC_STOP_POST = "ExecStopPost";
        public static final String FAILURE_ACTION = "FailureAction";
        public static final String FILE_DESCRIPTOR_STORE_MAX = "FileDescriptorStoreMax";
        public static final String GROUP = "Group";
        public static final String GUESS_MAIN_PID = "GuessMainPID";
        public static final String IO_SCHEDULING = "IOScheduling";
        public static final String IGNORE_SIGPIPE = "IgnoreSIGPIPE";
        public static final String INACCESSIBLE_DIRECTORIES = "InaccessibleDirectories";
        public static final String KILL_MODE = "KillMode";
        public static final String KILL_SIGNAL = "KillSignal";
        public static final String LIMIT_AS = "LimitAS";
        public static final String LIMIT_CORE = "LimitCORE";
        public static final String LIMIT_CPU = "LimitCPU";
        public static final String LIMIT_DATA = "LimitDATA";
        public static final String LIMIT_FSIZE = "LimitFSIZE";
        public static final String LIMIT_LOCKS = "LimitLOCKS";
        public static final String LIMIT_MEMLOCK = "LimitMEMLOCK";
        public static final String LIMIT_MSGQUEUE = "LimitMSGQUEUE";
        public static final String LIMIT_NICE = "LimitNICE";
        public static final String LIMIT_NOFILE = "LimitNOFILE";
        public static final String LIMIT_NPROC = "LimitNPROC";
        public static final String LIMIT_RSS = "LimitRSS";
        public static final String LIMIT_RTPRIO = "LimitRTPRIO";
        public static final String LIMIT_RTTIME = "LimitRTTIME";
        public static final String LIMIT_SIGPENDING = "LimitSIGPENDING";
        public static final String LIMIT_STACK = "LimitSTACK";
        public static final String MAIN_PID = "MainPID";
        public static final String MEMORY_ACCOUNTING = "MemoryAccounting";
        public static final String MEMORY_CURRENT = "MemoryCurrent";
        public static final String MEMORY_LIMIT = "MemoryLimit";
        public static final String MOUNT_FLAGS = "MountFlags";
        public static final String NFILE_DESCRIPTOR_STORE = "NFileDescriptorStore";
        public static final String NICE = "Nice";
        public static final String NO_NEW_PRIVILEGES = "NoNewPrivileges";
        public static final String NON_BLOCKING = "NonBlocking";
        public static final String NOTIFY_ACCESS = "NotifyAccess";
        public static final String OOM_SCORE_ADJUST = "OOMScoreAdjust";
        public static final String PAM_NAME = "PAMName";
        public static final String PID_FILE = "PIDFile";
        public static final String PASS_ENVIRONMENT = "PassEnvironment";
        public static final String PERMISSIONS_START_ONLY = "PermissionsStartOnly";
        public static final String PERSONALITY = "Personality";
        public static final String PRIVATE_DEVICES = "PrivateDevices";
        public static final String PRIVATE_NETWORK = "PrivateNetwork";
        public static final String PRIVATE_TMP = "PrivateTmp";
        public static final String PROTECT_HOME = "ProtectHome";
        public static final String PROTECT_SYSTEM = "ProtectSystem";
        public static final String READ_ONLY_DIRECTORIES = "ReadOnlyDirectories";
        public static final String READ_WRITE_DIRECTORIES = "ReadWriteDirectories";
        public static final String REBOOT_ARGUMENT = "RebootArgument";
        public static final String REMAIN_AFTER_EXIT = "RemainAfterExit";
        public static final String RESTART = "Restart";
        public static final String RESTART_USEC = "RestartUSec";
        public static final String RESTRICT_ADDRESS_FAMILIES = "RestrictAddressFamilies";
        public static final String RESULT = "Result";
        public static final String ROOT_DIRECTORY = "RootDirectory";
        public static final String ROOT_DIRECTORY_START_ONLY = "RootDirectoryStartOnly";
        public static final String RUNTIME_DIRECTORY = "RuntimeDirectory";
        public static final String RUNTIME_DIRECTORY_MODE = "RuntimeDirectoryMode";
        public static final String RUNTIME_MAX_USEC = "RuntimeMaxUSec";
        public static final String SELINUX_CONTEXT = "SELinuxContext";
        public static final String SAME_PROCESS_GROUP = "SameProcessGroup";
        public static final String SECURE_BITS = "SecureBits";
        public static final String SEND_SIGHUP = "SendSIGHUP";
        public static final String SEND_SIGKILL = "SendSIGKILL";
        public static final String SLICE = "Slice";
        public static final String SMACK_PROCESS_LABEL = "SmackProcessLabel";
        public static final String STANDARD_ERROR = "StandardError";
        public static final String STANDARD_INPUT = "StandardInput";
        public static final String STANDARD_OUTPUT = "StandardOutput";
        public static final String START_LIMIT_ACTION = "StartLimitAction";
        public static final String START_LIMIT_BURST = "StartLimitBurst";
        public static final String START_LIMIT_INTERVAL = "StartLimitInterval";
        public static final String STARTUP_BLOCK_IO_WEIGHT = "StartupBlockIOWeight";
        public static final String STARTUP_CPU_SHARES = "StartupCPUShares";
        public static final String STATUS_ERRNO = "StatusErrno";
        public static final String STATUS_TEXT = "StatusText";
        public static final String SUPPLEMENTARY_GROUPS = "SupplementaryGroups";
        public static final String SYSLOG_FACILITY = "SyslogFacility";
        public static final String SYSLOG_IDENTIFIER = "SyslogIdentifier";
        public static final String SYSLOG_LEVEL = "SyslogLevel";
        public static final String SYSLOG_LEVEL_PREFIX = "SyslogLevelPrefix";
        public static final String SYSLOG_PRIORITY = "SyslogPriority";
        public static final String SYSTEM_CALL_ARCHITECTURES = "SystemCallArchitectures";
        public static final String SYSTEM_CALL_ERROR_NUMBER = "SystemCallErrorNumber";
        public static final String SYSTEM_CALL_FILTER = "SystemCallFilter";
        public static final String TTY_PATH = "TTYPath";
        public static final String TTY_RESET = "TTYReset";
        public static final String TTY_V_HANGUP = "TTYVHangup";
        public static final String TTY_VT_DISALLOCATE = "TTYVTDisallocate";
        public static final String TASKS_ACCOUNTING = "TasksAccounting";
        public static final String TASKS_CURRENT = "TasksCurrent";
        public static final String TASKS_MAX = "TasksMax";
        public static final String TIMEOUT_START_USEC = "TimeoutStartUSec";
        public static final String TIMEOUT_STOP_USEC = "TimeoutStopUSec";
        public static final String TIMER_SLACK_NSEC = "TimerSlackNSec";
        public static final String TYPE = "Type";
        public static final String UMASK = "UMask";
        public static final String USB_FUNCTION_DESCRIPTORS = "USBFunctionDescriptors";
        public static final String USB_FUNCTION_STRINGS = "USBFunctionStrings";
        public static final String USER = "User";
        public static final String UTMP_IDENTIFIER = "UtmpIdentifier";
        public static final String UTMP_MODE = "UtmpMode";
        public static final String WATCHDOG_TIMESTAMP = "WatchdogTimestamp";
        public static final String WATCHDOG_TIMESTAMP_MONOTONIC = "WatchdogTimestampMonotonic";
        public static final String WATCHDOG_USEC = "WatchdogUSec";
        public static final String WORKING_DIRECTORY = "WorkingDirectory";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

