/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.SignalConsumer;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.UnitStateNotifier;
import de.thjom.java.systemd.interfaces.UnitInterface;
import de.thjom.java.systemd.types.Condition;
import de.thjom.java.systemd.types.Job;
import de.thjom.java.systemd.types.LoadError;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;

public abstract class Unit
extends InterfaceAdapter
implements UnitStateNotifier {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Unit";
    public static final String OBJECT_PATH = "/org/freedesktop/systemd1/unit/";
    protected final String name;
    protected final Manager manager;
    private final Properties unitProperties;

    protected Unit(Manager manager, UnitInterface iface, String name) throws DBusException {
        super(manager.dbus, iface);
        this.name = name;
        this.manager = manager;
        this.unitProperties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    public static String normalizeName(String name, String suffix) {
        String normalized = name != null ? (suffix != null ? (name.endsWith(suffix) ? name : name + suffix) : name) : "";
        return normalized;
    }

    public static String extractName(String objectPath) {
        String name = objectPath != null && objectPath.startsWith(OBJECT_PATH) ? objectPath.substring(OBJECT_PATH.length()) : "";
        return name;
    }

    @Override
    public UnitInterface getInterface() {
        return (UnitInterface)super.getInterface();
    }

    public final Properties getUnitProperties() {
        return this.unitProperties;
    }

    public boolean isAssignableFrom(String objectPath) {
        return Unit.extractName(objectPath).equals(Systemd.escapePath(this.name));
    }

    @Override
    public <T extends DBusSignal> void addHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        this.manager.subscribe();
        this.dbus.addSigHandler(type, (DBusInterface)this.getInterface(), handler);
    }

    @Override
    public <T extends DBusSignal> void removeHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (handler != null) {
            this.dbus.removeSigHandler(type, (DBusInterface)this.getInterface(), handler);
        }
    }

    @Override
    protected SignalConsumer<DBus.Properties.PropertiesChanged> createStateConsumer() {
        return new SignalConsumer<DBus.Properties.PropertiesChanged>(s -> {
            Map properties = s.changedProperties;
            if (properties.containsKey("ActiveState") || properties.containsKey("LoadState") || properties.containsKey("SubState")) {
                List list = this.unitStateListeners;
                synchronized (list) {
                    this.unitStateListeners.forEach(l -> l.stateChanged(this, properties));
                }
            }
        });
    }

    public String introspect() throws DBusException {
        DBus.Introspectable intro = (DBus.Introspectable)this.dbus.getRemoteObject("org.freedesktop.systemd1", this.getInterface().getObjectPath(), DBus.Introspectable.class);
        return intro.Introspect();
    }

    public Path start(Mode mode) {
        return this.start(mode.getValue());
    }

    public Path start(String mode) {
        return this.manager.startUnit(this.name, mode);
    }

    public Path stop(Mode mode) {
        return this.stop(mode.getValue());
    }

    public Path stop(String mode) {
        return this.manager.stopUnit(this.name, mode);
    }

    public Path reload(Mode mode) {
        return this.reload(mode.getValue());
    }

    public Path reload(String mode) {
        return this.manager.reloadUnit(this.name, mode);
    }

    public Path restart(Mode mode) {
        return this.restart(mode.getValue());
    }

    public Path restart(String mode) {
        return this.manager.restartUnit(this.name, mode);
    }

    public Path tryRestart(Mode mode) {
        return this.tryRestart(mode.getValue());
    }

    public Path tryRestart(String mode) {
        return this.manager.tryRestartUnit(this.name, mode);
    }

    public Path reloadOrRestart(Mode mode) {
        return this.reloadOrRestart(mode.getValue());
    }

    public Path reloadOrRestart(String mode) {
        return this.manager.reloadOrRestartUnit(this.name, mode);
    }

    public Path reloadOrTryRestart(Mode mode) {
        return this.reloadOrTryRestart(mode.getValue());
    }

    public Path reloadOrTryRestart(String mode) {
        return this.manager.reloadOrTryRestartUnit(this.name, mode);
    }

    public void kill(Who who, int signal) {
        this.kill(who.getValue(), signal);
    }

    public void kill(String who, int signal) {
        this.manager.killUnit(this.name, who, signal);
    }

    public void resetFailed() {
        this.manager.resetFailedUnit(this.name);
    }

    public void unref() {
        this.manager.unrefUnit(this.name);
    }

    public void setProperties(boolean runtime, Map<String, Object> properties) {
        throw new UnsupportedOperationException();
    }

    public long getActiveEnterTimestamp() {
        return this.unitProperties.getLong("ActiveEnterTimestamp");
    }

    public long getActiveEnterTimestampMonotonic() {
        return this.unitProperties.getLong("ActiveEnterTimestampMonotonic");
    }

    public long getActiveExitTimestamp() {
        return this.unitProperties.getLong("ActiveExitTimestamp");
    }

    public long getActiveExitTimestampMonotonic() {
        return this.unitProperties.getLong("ActiveExitTimestampMonotonic");
    }

    public String getActiveState() {
        return this.unitProperties.getString("ActiveState");
    }

    public Vector<String> getAfter() {
        return this.unitProperties.getVector("After");
    }

    public boolean isAllowIsolate() {
        return this.unitProperties.getBoolean("AllowIsolate");
    }

    public boolean isAssertResult() {
        return this.unitProperties.getBoolean("AssertResult");
    }

    public long getAssertTimestamp() {
        return this.unitProperties.getLong("AssertTimestamp");
    }

    public long getAssertTimestampMonotonic() {
        return this.unitProperties.getLong("AssertTimestampMonotonic");
    }

    public List<Condition> getAsserts() {
        return Condition.list(this.unitProperties.getVector("Asserts"));
    }

    public Vector<String> getBefore() {
        return this.unitProperties.getVector("Before");
    }

    public Vector<String> getBindsTo() {
        return this.unitProperties.getVector("BindsTo");
    }

    public Vector<String> getBoundBy() {
        return this.unitProperties.getVector("BoundBy");
    }

    public boolean isCanIsolate() {
        return this.unitProperties.getBoolean("CanIsolate");
    }

    public boolean isCanReload() {
        return this.unitProperties.getBoolean("CanReload");
    }

    public boolean isCanStart() {
        return this.unitProperties.getBoolean("CanStart");
    }

    public boolean isCanStop() {
        return this.unitProperties.getBoolean("CanStop");
    }

    public boolean getConditionResult() {
        return this.unitProperties.getBoolean("ConditionResult");
    }

    public long getConditionTimestamp() {
        return this.unitProperties.getLong("ConditionTimestamp");
    }

    public long getConditionTimestampMonotonic() {
        return this.unitProperties.getLong("ConditionTimestampMonotonic");
    }

    public List<Condition> getConditions() {
        return Condition.list(this.unitProperties.getVector("Conditions"));
    }

    public Vector<String> getConflictedBy() {
        return this.unitProperties.getVector("ConflictedBy");
    }

    public Vector<String> getConflicts() {
        return this.unitProperties.getVector("Conflicts");
    }

    public Vector<String> getConsistsOf() {
        return this.unitProperties.getVector("ConsistsOf");
    }

    public boolean isDefaultDependencies() {
        return this.unitProperties.getBoolean("DefaultDependencies");
    }

    public String getDescription() {
        return this.unitProperties.getString("Description");
    }

    public Vector<String> getDocumentation() {
        return this.unitProperties.getVector("Documentation");
    }

    public Vector<String> getDropInPaths() {
        return this.unitProperties.getVector("DropInPaths");
    }

    public String getFollowing() {
        return this.unitProperties.getString("Following");
    }

    public String getFragmentPath() {
        return this.unitProperties.getString("FragmentPath");
    }

    public String getId() {
        return this.unitProperties.getString("Id");
    }

    public boolean isIgnoreOnIsolate() {
        return this.unitProperties.getBoolean("IgnoreOnIsolate");
    }

    public long getInactiveEnterTimestamp() {
        return this.unitProperties.getLong("InactiveEnterTimestamp");
    }

    public long getInactiveEnterTimestampMonotonic() {
        return this.unitProperties.getLong("InactiveEnterTimestampMonotonic");
    }

    public long getInactiveExitTimestamp() {
        return this.unitProperties.getLong("InactiveExitTimestamp");
    }

    public long getInactiveExitTimestampMonotonic() {
        return this.unitProperties.getLong("InactiveExitTimestampMonotonic");
    }

    public byte[] getInvocationID() {
        return (byte[])this.unitProperties.getVariant("InvocationID").getValue();
    }

    public Job getJob() {
        Object[] array = (Object[])this.unitProperties.getVariant("Job").getValue();
        return new Job(array);
    }

    public String getJobTimeoutAction() {
        return this.unitProperties.getString("JobTimeoutAction");
    }

    public String getJobTimeoutRebootArgument() {
        return this.unitProperties.getString("JobTimeoutRebootArgument");
    }

    public BigInteger getJobTimeoutUSec() {
        return this.unitProperties.getBigInteger("JobTimeoutUSec");
    }

    public Vector<String> getJoinsNamespaceOf() {
        return this.unitProperties.getVector("JoinsNamespaceOf");
    }

    public LoadError getLoadError() {
        Object[] array = (Object[])this.unitProperties.getVariant("LoadError").getValue();
        return new LoadError(array);
    }

    public String getLoadState() {
        return this.unitProperties.getString("LoadState");
    }

    public Vector<String> getNames() {
        return this.unitProperties.getVector("Names");
    }

    public boolean isNeedDaemonReload() {
        return this.unitProperties.getBoolean("NeedDaemonReload");
    }

    public Vector<String> getOnFailure() {
        return this.unitProperties.getVector("OnFailure");
    }

    public String getOnFailureJobMode() {
        return this.unitProperties.getString("OnFailureJobMode");
    }

    public Vector<String> getPartOf() {
        return this.unitProperties.getVector("PartOf");
    }

    public boolean isPerpetual() {
        return this.unitProperties.getBoolean("Perpetual");
    }

    public Vector<String> getPropagatesReloadTo() {
        return this.unitProperties.getVector("PropagatesReloadTo");
    }

    public boolean isRefuseManualStart() {
        return this.unitProperties.getBoolean("RefuseManualStart");
    }

    public boolean isRefuseManualStop() {
        return this.unitProperties.getBoolean("RefuseManualStop");
    }

    public Vector<String> getReloadPropagatedFrom() {
        return this.unitProperties.getVector("ReloadPropagatedFrom");
    }

    public Vector<String> getRequiredBy() {
        return this.unitProperties.getVector("RequiredBy");
    }

    public Vector<String> getRequires() {
        return this.unitProperties.getVector("Requires");
    }

    public Vector<String> getRequiresMountsFor() {
        return this.unitProperties.getVector("RequiresMountsFor");
    }

    public Vector<String> getRequisite() {
        return this.unitProperties.getVector("Requisite");
    }

    public Vector<String> getRequisiteOf() {
        return this.unitProperties.getVector("RequisiteOf");
    }

    public String getSourcePath() {
        return this.unitProperties.getString("SourcePath");
    }

    public long getStartLimitIntervalSec() {
        return this.unitProperties.getLong("StartLimitIntervalSec");
    }

    public long getStateChangeTimestamp() {
        return this.unitProperties.getLong("StateChangeTimestamp");
    }

    public long getStateChangeTimestampMonotonic() {
        return this.unitProperties.getLong("StateChangeTimestampMonotonic");
    }

    public boolean isStopWhenUnneeded() {
        return this.unitProperties.getBoolean("StopWhenUnneeded");
    }

    public String getSubState() {
        return this.unitProperties.getString("SubState");
    }

    public boolean isTransient() {
        return this.unitProperties.getBoolean("Transient");
    }

    public Vector<String> getTriggeredBy() {
        return this.unitProperties.getVector("TriggeredBy");
    }

    public Vector<String> getTriggers() {
        return this.unitProperties.getVector("Triggers");
    }

    public String getUnitFilePreset() {
        return this.unitProperties.getString("UnitFilePreset");
    }

    public String getUnitFileState() {
        return this.unitProperties.getString("UnitFileState");
    }

    public Vector<String> getWantedBy() {
        return this.unitProperties.getVector("WantedBy");
    }

    public Vector<String> getWants() {
        return this.unitProperties.getVector("Wants");
    }

    public String toString() {
        return this.name;
    }

    public static final class StateTuple {
        private final String loadState;
        private final String activeState;
        private final String subState;

        public StateTuple(String loadState, String activeState, String subState) {
            this.loadState = loadState;
            this.activeState = activeState;
            this.subState = subState;
        }

        public static StateTuple of(Unit unit) {
            return new StateTuple(unit.getLoadState(), unit.getActiveState(), unit.getSubState());
        }

        public static StateTuple of(Map<String, Variant<?>> properties) {
            String loadState = String.valueOf(properties.getOrDefault("LoadState", new Variant((Object)"-")).getValue());
            String activeState = String.valueOf(properties.getOrDefault("ActiveState", new Variant((Object)"-")).getValue());
            String subState = String.valueOf(properties.getOrDefault("SubState", new Variant((Object)"-")).getValue());
            return new StateTuple(loadState, activeState, subState);
        }

        public static StateTuple of(Unit unit, Map<String, Variant<?>> properties) {
            String loadState = String.valueOf(properties.getOrDefault("LoadState", new Variant((Object)unit.getLoadState())).getValue());
            String activeState = String.valueOf(properties.getOrDefault("ActiveState", new Variant((Object)unit.getActiveState())).getValue());
            String subState = String.valueOf(properties.getOrDefault("SubState", new Variant((Object)unit.getSubState())).getValue());
            return new StateTuple(loadState, activeState, subState);
        }

        public String getLoadState() {
            return this.loadState;
        }

        public String getActiveState() {
            return this.activeState;
        }

        public String getSubState() {
            return this.subState;
        }

        public String toString() {
            return String.format("%s - %s (%s)", this.loadState, this.activeState, this.subState);
        }
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String ACTIVE_ENTER_TIMESTAMP = "ActiveEnterTimestamp";
        public static final String ACTIVE_ENTER_TIMESTAMP_MONOTONIC = "ActiveEnterTimestampMonotonic";
        public static final String ACTIVE_EXIT_TIMESTAMP = "ActiveExitTimestamp";
        public static final String ACTIVE_EXIT_TIMESTAMP_MONOTONIC = "ActiveExitTimestampMonotonic";
        public static final String ACTIVE_STATE = "ActiveState";
        public static final String AFTER = "After";
        public static final String ALLOW_ISOLATE = "AllowIsolate";
        public static final String ASSERT_RESULT = "AssertResult";
        public static final String ASSERT_TIMESTAMP = "AssertTimestamp";
        public static final String ASSERT_TIMESTAMP_MONOTONIC = "AssertTimestampMonotonic";
        public static final String ASSERTS = "Asserts";
        public static final String BEFORE = "Before";
        public static final String BINDS_TO = "BindsTo";
        public static final String BOUND_BY = "BoundBy";
        public static final String CAN_ISOLATE = "CanIsolate";
        public static final String CAN_RELOAD = "CanReload";
        public static final String CAN_START = "CanStart";
        public static final String CAN_STOP = "CanStop";
        public static final String CONDITION_RESULT = "ConditionResult";
        public static final String CONDITION_TIMESTAMP = "ConditionTimestamp";
        public static final String CONDITION_TIMESTAMP_MONOTONIC = "ConditionTimestampMonotonic";
        public static final String CONDITIONS = "Conditions";
        public static final String CONFLICTED_BY = "ConflictedBy";
        public static final String CONFLICTS = "Conflicts";
        public static final String CONSISTS_OF = "ConsistsOf";
        public static final String DEFAULT_DEPENDENCIES = "DefaultDependencies";
        public static final String DESCRIPTION = "Description";
        public static final String DOCUMENTATION = "Documentation";
        public static final String DROP_IN_PATHS = "DropInPaths";
        public static final String FOLLOWING = "Following";
        public static final String FRAGMENT_PATH = "FragmentPath";
        public static final String ID = "Id";
        public static final String IGNORE_ON_ISOLATE = "IgnoreOnIsolate";
        public static final String INACTIVE_ENTER_TIMESTAMP = "InactiveEnterTimestamp";
        public static final String INACTIVE_ENTER_TIMESTAMP_MONOTONIC = "InactiveEnterTimestampMonotonic";
        public static final String INACTIVE_EXIT_TIMESTAMP = "InactiveExitTimestamp";
        public static final String INACTIVE_EXIT_TIMESTAMP_MONOTONIC = "InactiveExitTimestampMonotonic";
        public static final String INVOCATION_ID = "InvocationID";
        public static final String JOB = "Job";
        public static final String JOB_TIMEOUT_ACTION = "JobTimeoutAction";
        public static final String JOB_TIMEOUT_REBOOT_ARGUMENT = "JobTimeoutRebootArgument";
        public static final String JOB_TIMEOUT_USEC = "JobTimeoutUSec";
        public static final String JOINS_NAMESPACE_OF = "JoinsNamespaceOf";
        public static final String LOAD_ERROR = "LoadError";
        public static final String LOAD_STATE = "LoadState";
        public static final String NAMES = "Names";
        public static final String NEED_DAEMON_RELOAD = "NeedDaemonReload";
        public static final String ON_FAILURE = "OnFailure";
        public static final String ON_FAILURE_JOB_MODE = "OnFailureJobMode";
        public static final String PART_OF = "PartOf";
        public static final String PERPETUAL = "Perpetual";
        public static final String PROPAGATES_RELOAD_TO = "PropagatesReloadTo";
        public static final String REFUSE_MANUAL_START = "RefuseManualStart";
        public static final String REFUSE_MANUAL_STOP = "RefuseManualStop";
        public static final String RELOAD_PROPAGATED_FROM = "ReloadPropagatedFrom";
        public static final String REQUIRED_BY = "RequiredBy";
        public static final String REQUIRES = "Requires";
        public static final String REQUIRES_MOUNTS_FOR = "RequiresMountsFor";
        public static final String REQUISITE = "Requisite";
        public static final String REQUISITE_OF = "RequisiteOf";
        public static final String SOURCE_PATH = "SourcePath";
        public static final String START_LIMIT_INTERVAL_SEC = "StartLimitIntervalSec";
        public static final String STATE_CHANGE_TIMESTAMP = "StateChangeTimestamp";
        public static final String STATE_CHANGE_TIMESTAMP_MONOTONIC = "StateChangeTimestampMonotonic";
        public static final String STOP_WHEN_UNNEEDED = "StopWhenUnneeded";
        public static final String SUB_STATE = "SubState";
        public static final String TRANSIENT = "Transient";
        public static final String TRIGGERED_BY = "TriggeredBy";
        public static final String TRIGGERS = "Triggers";
        public static final String UNIT_FILE_PRESET = "UnitFilePreset";
        public static final String UNIT_FILE_STATE = "UnitFileState";
        public static final String WANTED_BY = "WantedBy";
        public static final String WANTS = "Wants";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }

    public static enum Mode {
        REPLACE("replace"),
        FAIL("fail"),
        ISOLATE("isolate"),
        IGNORE_DEPENDENCIES("ignore-dependencies"),
        IGNORE_REQUIREMENTS("ignore-requirements");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public final String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Who {
        MAIN("main"),
        CONTROL("control"),
        ALL("all");

        private final String value;

        private Who(String value) {
            this.value = value;
        }

        public final String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

