/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.UnitMonitor;
import java.util.HashSet;
import java.util.Set;
import org.freedesktop.dbus.exceptions.DBusException;

public class UnitNameMonitor
extends UnitMonitor {
    protected final Set<String> monitoredNames = new HashSet<String>();

    public UnitNameMonitor(Manager manager) {
        super(manager);
    }

    @Override
    public synchronized void reset() {
        this.monitoredNames.clear();
        this.monitoredUnits.clear();
    }

    @Override
    public synchronized void refresh() throws DBusException {
        try {
            this.monitoredUnits.clear();
            for (String unitName : this.monitoredNames) {
                this.monitoredUnits.put(Systemd.escapePath(unitName), this.manager.getUnit(unitName));
            }
        }
        finally {
            this.unitMonitorListeners.forEach(l -> l.monitorRefreshed(this.monitoredUnits.values()));
        }
    }

    public synchronized void addUnits(String ... fullUnitNames) throws DBusException {
        for (String unitName : fullUnitNames) {
            this.monitoredNames.add(unitName);
            this.monitoredUnits.put(Systemd.escapePath(unitName), this.manager.getUnit(unitName));
        }
    }

    public synchronized void addUnits(Unit ... units) {
        for (Unit unit : units) {
            this.monitoredNames.add(unit.getId());
            this.monitoredUnits.put(Systemd.escapePath(unit.getId()), unit);
        }
    }

    public synchronized void removeUnits(String ... fullUnitNames) {
        for (String unitName : fullUnitNames) {
            this.monitoredNames.remove(unitName);
            this.monitoredUnits.remove(Systemd.escapePath(unitName));
        }
    }

    public synchronized void removeUnits(Unit ... units) {
        for (Unit unit : units) {
            this.monitoredNames.remove(unit.getId());
            this.monitoredUnits.remove(Systemd.escapePath(unit.getId()));
        }
    }

    @Override
    public boolean monitorsUnit(String unitName) {
        boolean monitored = super.monitorsUnit(unitName);
        if (!monitored) {
            for (String monitoredName : this.monitoredNames) {
                if (!Systemd.escapePath(monitoredName).equals(unitName)) continue;
                monitored = true;
                break;
            }
        }
        return monitored;
    }
}

