/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd.interfaces;

import de.thjom.java.systemd.Signal;
import de.thjom.java.systemd.types.UnitFileType;
import de.thjom.java.systemd.types.UnitType;
import java.util.List;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.exceptions.DBusException;

@DBusInterfaceName(value="org.freedesktop.systemd1.Manager")
public interface ManagerInterface
extends DBusInterface {
    @DBusMemberName(value="CancelJob")
    public void cancelJob(long var1);

    @DBusMemberName(value="ClearJobs")
    public void clearJobs();

    @DBusMemberName(value="Dump")
    public String dump();

    @DBusMemberName(value="GetDefaultTarget")
    public String getDefaultTarget();

    @DBusMemberName(value="Halt")
    public void halt();

    @DBusMemberName(value="KExec")
    public void kExec();

    @DBusMemberName(value="KillUnit")
    public void killUnit(String var1, String var2, int var3);

    @DBusMemberName(value="ListUnitFiles")
    public List<UnitFileType> listUnitFiles();

    @DBusMemberName(value="ListUnits")
    public List<UnitType> listUnits();

    @DBusMemberName(value="PowerOff")
    public void powerOff();

    @DBusMemberName(value="Reboot")
    public void reboot();

    @DBusMemberName(value="Reexecute")
    public void reexecute();

    @DBusMemberName(value="RefUnit")
    public void refUnit(String var1);

    @DBusMemberName(value="Reload")
    public void reload();

    @DBusMemberName(value="ReloadOrRestartUnit")
    public Path reloadOrRestartUnit(String var1, String var2);

    @DBusMemberName(value="ReloadOrTryRestartUnit")
    public Path reloadOrTryRestartUnit(String var1, String var2);

    @DBusMemberName(value="ReloadUnit")
    public Path reloadUnit(String var1, String var2);

    @DBusMemberName(value="ResetFailedUnit")
    public void resetFailedUnit(String var1);

    @DBusMemberName(value="RestartUnit")
    public Path restartUnit(String var1, String var2);

    @DBusMemberName(value="StartUnit")
    public Path startUnit(String var1, String var2);

    @DBusMemberName(value="StopUnit")
    public Path stopUnit(String var1, String var2);

    @DBusMemberName(value="TryRestartUnit")
    public Path tryRestartUnit(String var1, String var2);

    @DBusMemberName(value="UnrefUnit")
    public void unrefUnit(String var1);

    @DBusMemberName(value="Subscribe")
    public void subscribe();

    @DBusMemberName(value="Unsubscribe")
    public void unsubscribe();

    public static final class UnitRemoved
    extends Signal {
        public UnitRemoved(String objectPath, String id, Path unit) throws DBusException {
            super(objectPath, id, unit);
        }

        public String getId() {
            return (String)this.getParameter(0, "");
        }

        public Path getUnit() {
            return (Path)this.getParameter(1, null);
        }
    }

    public static final class UnitNew
    extends Signal {
        public UnitNew(String objectPath, String id, Path unit) throws DBusException {
            super(objectPath, id, unit);
        }

        public String getId() {
            return (String)this.getParameter(0, "");
        }

        public Path getUnit() {
            return (Path)this.getParameter(1, null);
        }
    }

    public static final class UnitFilesChanged
    extends Signal {
        public UnitFilesChanged(String objectPath) throws DBusException {
            super(objectPath, new Object[0]);
        }
    }

    public static final class StartupFinished
    extends Signal {
        public StartupFinished(String objectPath, long firmware, long loader, long kernel, long initrd, long userspace, long total) throws DBusException {
            super(objectPath, firmware, loader, kernel, initrd, userspace, total);
        }

        public long getFirmware() {
            return (Long)this.getParameter(0, -1L);
        }

        public long getLoader() {
            return (Long)this.getParameter(1, -1L);
        }

        public long getKernel() {
            return (Long)this.getParameter(2, -1L);
        }

        public long getInitRD() {
            return (Long)this.getParameter(3, -1L);
        }

        public long getUserspace() {
            return (Long)this.getParameter(4, -1L);
        }

        public long getTotal() {
            return (Long)this.getParameter(5, -1L);
        }
    }

    public static final class Reloading
    extends Signal {
        public Reloading(String objectPath, boolean active) throws DBusException {
            super(objectPath, active);
        }

        public boolean isActive() {
            return (Boolean)this.getParameter(0, false);
        }
    }

    public static final class JobRemoved
    extends Signal {
        public JobRemoved(String objectPath, long id, Path job, String unit, String result) throws DBusException {
            super(objectPath, id, job, unit, result);
        }

        public long getId() {
            return (Long)this.getParameter(0, 0L);
        }

        public Path getJob() {
            return (Path)this.getParameter(1, null);
        }

        public String getUnit() {
            return (String)this.getParameter(2, "");
        }

        public String getResult() {
            return (String)this.getParameter(3, "");
        }
    }

    public static final class JobNew
    extends Signal {
        public JobNew(String objectPath, long id, Path job, String unit) throws DBusException {
            super(objectPath, id, job, unit);
        }

        public long getId() {
            return (Long)this.getParameter(0, 0L);
        }

        public Path getJob() {
            return (Path)this.getParameter(1, null);
        }

        public String getUnit() {
            return (String)this.getParameter(2, "");
        }
    }
}

