/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;

public class ExecutionInfo {
    private final String binaryPath;
    private final Vector<String> arguments;
    private final boolean failOnUncleanExit;
    private final long lastStartTimestamp;
    private final long lastStartTimestampMonotonic;
    private final long lastFinishTimestamp;
    private final long lastFinishTimestampMonotonic;
    private final int processId;
    private final int lastExitCode;
    private final int lastExitStatus;

    public ExecutionInfo(Object[] array) {
        this.binaryPath = String.valueOf(array[0]);
        this.arguments = (Vector)array[1];
        this.failOnUncleanExit = (Boolean)array[2];
        this.lastStartTimestamp = ((UInt64)array[3]).longValue();
        this.lastStartTimestampMonotonic = ((UInt64)array[4]).longValue();
        this.lastFinishTimestamp = ((UInt64)array[5]).longValue();
        this.lastFinishTimestampMonotonic = ((UInt64)array[6]).longValue();
        this.processId = ((UInt32)array[7]).intValue();
        this.lastExitCode = (Integer)array[8];
        this.lastExitStatus = (Integer)array[9];
    }

    public static List<ExecutionInfo> list(Vector<Object[]> vector) {
        ArrayList<ExecutionInfo> execs = new ArrayList<ExecutionInfo>(vector.size());
        for (Object[] array : vector) {
            ExecutionInfo exec = new ExecutionInfo(array);
            execs.add(exec);
        }
        return execs;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public Vector<String> getArguments() {
        return this.arguments;
    }

    public boolean isFailOnUncleanExit() {
        return this.failOnUncleanExit;
    }

    public long getLastStartTimestamp() {
        return this.lastStartTimestamp;
    }

    public long getLastStartTimestampMonotonic() {
        return this.lastStartTimestampMonotonic;
    }

    public long getLastFinishTimestamp() {
        return this.lastFinishTimestamp;
    }

    public long getLastFinishTimestampMonotonic() {
        return this.lastFinishTimestampMonotonic;
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getLastExitCode() {
        return this.lastExitCode;
    }

    public int getLastExitStatus() {
        return this.lastExitStatus;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExecutionInfo [binaryPath=");
        builder.append(this.binaryPath);
        builder.append(", arguments=");
        builder.append(this.arguments);
        builder.append(", failOnUncleanExit=");
        builder.append(this.failOnUncleanExit);
        builder.append(", lastStartTimestamp=");
        builder.append(this.lastStartTimestamp);
        builder.append(", lastStartTimestampMonotonic=");
        builder.append(this.lastStartTimestampMonotonic);
        builder.append(", lastFinishTimestamp=");
        builder.append(this.lastFinishTimestamp);
        builder.append(", lastFinishTimestampMonotonic=");
        builder.append(this.lastFinishTimestampMonotonic);
        builder.append(", processId=");
        builder.append(this.processId);
        builder.append(", lastExitCode=");
        builder.append(this.lastExitCode);
        builder.append(", lastExitStatus=");
        builder.append(this.lastExitStatus);
        builder.append("]");
        return builder.toString();
    }
}

