/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.AutomountInterface;
import java.math.BigInteger;
import org.freedesktop.dbus.exceptions.DBusException;

public class Automount
extends Unit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Automount";
    public static final String UNIT_SUFFIX = ".automount";

    private Automount(Manager manager, AutomountInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Automount create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        AutomountInterface iface = (AutomountInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, AutomountInterface.class);
        return new Automount(manager, iface, name);
    }

    @Override
    public AutomountInterface getInterface() {
        return (AutomountInterface)super.getInterface();
    }

    public long getDirectoryMode() {
        return this.properties.getLong("DirectoryMode");
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public BigInteger getTimeoutIdleUSec() {
        return this.properties.getBigInteger("TimeoutIdleUSec");
    }

    public String getWhere() {
        return this.properties.getString("Where");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String DIRECTORY_MODE = "DirectoryMode";
        public static final String RESULT = "Result";
        public static final String TIMEOUT_IDLE_USEC = "TimeoutIdleUSec";
        public static final String WHERE = "Where";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

