/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.SignalConsumer;
import de.thjom.java.systemd.SignalSequencer;
import java.util.Objects;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ForwardingHandler<T extends DBusSignal>
implements DBusSigHandler<T> {
    private final Logger log = LoggerFactory.getLogger(ForwardingHandler.class);
    private SignalConsumer<T> consumer;
    private Thread consumerThread;

    ForwardingHandler(SignalConsumer<T> consumer) {
        this.consumer = Objects.requireNonNull(consumer);
    }

    public void startConsumer() {
        if (this.consumer != null) {
            this.log.info("Starting signal consumer thread");
            this.consumerThread = new Thread(this.consumer);
            this.consumerThread.setName(SignalConsumer.class.getSimpleName());
            this.consumerThread.setDaemon(true);
            this.consumerThread.start();
        }
    }

    public void stopConsumer() {
        if (this.consumer != null && this.consumerThread != null) {
            this.log.info("Stopping signal consumer thread");
            this.consumer.setRunning(false);
            try {
                this.consumerThread.interrupt();
                this.consumerThread.join();
            }
            catch (InterruptedException | SecurityException e) {
                this.log.warn(e.getMessage());
            }
        }
    }

    public synchronized void handle(T signal) {
        SignalSequencer<T> sequencer;
        if (this.consumer != null && (sequencer = this.consumer.getSequencer()) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding signal to sequencer queue: " + signal);
            }
            try {
                sequencer.put(signal);
            }
            catch (InterruptedException e) {
                this.log.debug(e.getMessage());
            }
        }
    }

    public final SignalConsumer<T> getConsumer() {
        return this.consumer;
    }
}

