/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.AbstractAdapter;
import de.thjom.java.systemd.Properties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.exceptions.DBusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InterfaceAdapter
extends AbstractAdapter
implements DBusInterface {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final DBusConnection dbus;
    protected Properties properties;
    private final DBusInterface iface;

    protected InterfaceAdapter(DBusConnection dbus, DBusInterface iface) {
        this.dbus = Objects.requireNonNull(dbus);
        this.iface = Objects.requireNonNull(iface);
    }

    public String getObjectPath() {
        return this.getInterface().getObjectPath();
    }

    public boolean isRemote() {
        return this.getInterface().isRemote();
    }

    public DBusInterface getInterface() {
        return this.iface;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public <T extends DBusSignal> void addHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        this.dbus.addSigHandler(type, handler);
    }

    @Override
    public <T extends DBusSignal> void removeHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (handler != null) {
            this.dbus.removeSigHandler(type, handler);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null) {
            return obj.hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dbus.getUniqueName(), this.getObjectPath());
    }

    public static class AdapterProperty {
        protected static final String ERROR_PROPERTY_MISSING = "Unable to retrieve property (not implemented)";
        private static final Logger LOG = LoggerFactory.getLogger(AdapterProperty.class);

        protected AdapterProperty() {
        }

        protected static final String[] getAllNames(Class<?> ... types) {
            ArrayList<String> names = new ArrayList<String>();
            for (Class<?> type : types) {
                Field[] fields = type.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (field.isSynthetic()) continue;
                    Object obj = "";
                    try {
                        obj = field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        LOG.error("Unable to enumerate field names", (Throwable)e);
                    }
                    names.add(obj.toString());
                }
            }
            return names.toArray(new String[names.size()]);
        }
    }
}

