/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.PathInterface;
import de.thjom.java.systemd.types.PathInfo;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;

public class Path
extends Unit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Path";
    public static final String UNIT_SUFFIX = ".path";

    private Path(Manager manager, PathInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Path create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        PathInterface iface = (PathInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, PathInterface.class);
        return new Path(manager, iface, name);
    }

    @Override
    public PathInterface getInterface() {
        return (PathInterface)super.getInterface();
    }

    public long getDirectoryMode() {
        return this.properties.getLong("DirectoryMode");
    }

    public boolean isMakeDirectory() {
        return this.properties.getBoolean("MakeDirectory");
    }

    public List<PathInfo> getPaths() {
        return PathInfo.list(this.properties.getVector("Paths"));
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public String getUnit() {
        return this.properties.getString("Unit");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String DIRECTORY_MODE = "DirectoryMode";
        public static final String MAKE_DIRECTORY = "MakeDirectory";
        public static final String PATHS = "Paths";
        public static final String RESULT = "Result";
        public static final String UNIT = "Unit";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

