/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.features.CpuAccounting;
import de.thjom.java.systemd.features.IoAccounting;
import de.thjom.java.systemd.features.IpAccounting;
import de.thjom.java.systemd.features.MemoryAccounting;
import de.thjom.java.systemd.features.TasksAccounting;
import de.thjom.java.systemd.interfaces.ScopeInterface;
import de.thjom.java.systemd.types.DeviceAllowControl;
import de.thjom.java.systemd.types.UnitProcessType;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import org.freedesktop.dbus.exceptions.DBusException;

public class Scope
extends Unit
implements CpuAccounting,
IoAccounting,
IpAccounting,
MemoryAccounting,
TasksAccounting {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Scope";
    public static final String UNIT_SUFFIX = ".scope";

    private Scope(Manager manager, ScopeInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Scope create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        ScopeInterface iface = (ScopeInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, ScopeInterface.class);
        return new Scope(manager, iface, name);
    }

    @Override
    public ScopeInterface getInterface() {
        return (ScopeInterface)super.getInterface();
    }

    public void abandon() {
        this.getInterface().abandon();
    }

    public void attachProcesses(String cgroupPath, long[] pids) {
        this.getInterface().attachProcesses(cgroupPath, pids);
    }

    public List<UnitProcessType> getProcesses() {
        return this.getInterface().getProcesses();
    }

    public String getControlGroup() {
        return this.properties.getString("ControlGroup");
    }

    public String getController() {
        return this.properties.getString("Controller");
    }

    public boolean isDelegate() {
        return this.properties.getBoolean("Delegate");
    }

    public Vector<String> getDelegateControllers() {
        return this.properties.getVector("DelegateControllers");
    }

    public List<DeviceAllowControl> getDeviceAllow() {
        return DeviceAllowControl.list(this.properties.getVector("DeviceAllow"));
    }

    public String getDevicePolicy() {
        return this.properties.getString("DevicePolicy");
    }

    public String getKillMode() {
        return this.properties.getString("KillMode");
    }

    public int getKillSignal() {
        return this.properties.getInteger("KillSignal");
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public boolean isSendSIGHUP() {
        return this.properties.getBoolean("SendSIGHUP");
    }

    public boolean isSendSIGKILL() {
        return this.properties.getBoolean("SendSIGKILL");
    }

    public String getSlice() {
        return this.properties.getString("Slice");
    }

    public BigInteger getTimeoutStopUSec() {
        return this.properties.getBigInteger("TimeoutStopUSec");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String CONTROL_GROUP = "ControlGroup";
        public static final String CONTROLLER = "Controller";
        public static final String DELEGATE = "Delegate";
        public static final String DELEGATE_CONTROLLERS = "DelegateControllers";
        public static final String DEVICE_ALLOW = "DeviceAllow";
        public static final String DEVICE_POLICY = "DevicePolicy";
        public static final String KILL_MODE = "KillMode";
        public static final String KILL_SIGNAL = "KillSignal";
        public static final String RESULT = "Result";
        public static final String SEND_SIGHUP = "SendSIGHUP";
        public static final String SEND_SIGKILL = "SendSIGKILL";
        public static final String SLICE = "Slice";
        public static final String TIMEOUT_STOP_USEC = "TimeoutStopUSec";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class, CpuAccounting.Property.class, IoAccounting.Property.class, IpAccounting.Property.class, MemoryAccounting.Property.class, TasksAccounting.Property.class);
        }
    }
}

