/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.features.DynamicUserAccounting;
import de.thjom.java.systemd.features.ExtendedCpuAccounting;
import de.thjom.java.systemd.features.ExtendedMemoryAccounting;
import de.thjom.java.systemd.features.IoAccounting;
import de.thjom.java.systemd.features.IpAccounting;
import de.thjom.java.systemd.features.TasksAccounting;
import de.thjom.java.systemd.features.Ulimit;
import de.thjom.java.systemd.interfaces.SocketInterface;
import de.thjom.java.systemd.types.DeviceAllowControl;
import de.thjom.java.systemd.types.EnvironmentFile;
import de.thjom.java.systemd.types.ExecutionInfo;
import de.thjom.java.systemd.types.ListenInfo;
import de.thjom.java.systemd.types.SystemCallFilter;
import de.thjom.java.systemd.types.UnitProcessType;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import org.freedesktop.dbus.exceptions.DBusException;

public class Socket
extends Unit
implements ExtendedCpuAccounting,
DynamicUserAccounting,
IoAccounting,
IpAccounting,
ExtendedMemoryAccounting,
TasksAccounting,
Ulimit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Socket";
    public static final String UNIT_SUFFIX = ".socket";

    private Socket(Manager manager, SocketInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Socket create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        SocketInterface iface = (SocketInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, SocketInterface.class);
        return new Socket(manager, iface, name);
    }

    @Override
    public SocketInterface getInterface() {
        return (SocketInterface)super.getInterface();
    }

    public void attachProcesses(String cgroupPath, long[] pids) {
        this.getInterface().attachProcesses(cgroupPath, pids);
    }

    public List<UnitProcessType> getProcesses() {
        return this.getInterface().getProcesses();
    }

    public boolean isAccept() {
        return this.properties.getBoolean("Accept");
    }

    public long getBacklog() {
        return this.properties.getLong("Backlog");
    }

    public String getBindIPv6Only() {
        return this.properties.getString("BindIPv6Only");
    }

    public String getBindToDevice() {
        return this.properties.getString("BindToDevice");
    }

    public boolean isBroadcast() {
        return this.properties.getBoolean("Broadcast");
    }

    public BigInteger getCapabilityBoundingSet() {
        return this.properties.getBigInteger("CapabilityBoundingSet");
    }

    public long getControlPID() {
        return this.properties.getLong("ControlPID");
    }

    public BigInteger getDeferAcceptUSec() {
        return this.properties.getBigInteger("DeferAcceptUSec");
    }

    public boolean isDelegate() {
        return this.properties.getBoolean("Delegate");
    }

    public Vector<String> getDelegateControllers() {
        return this.properties.getVector("DelegateControllers");
    }

    public List<DeviceAllowControl> getDeviceAllow() {
        return DeviceAllowControl.list(this.properties.getVector("DeviceAllow"));
    }

    public String getDevicePolicy() {
        return this.properties.getString("DevicePolicy");
    }

    public long getDirectoryMode() {
        return this.properties.getLong("DirectoryMode");
    }

    public Vector<String> getEnvironment() {
        return this.properties.getVector("Environment");
    }

    public List<EnvironmentFile> getEnvironmentFiles() {
        return EnvironmentFile.list(this.properties.getVector("EnvironmentFiles"));
    }

    public List<ExecutionInfo> getExecStartPost() {
        return ExecutionInfo.list(this.properties.getVector("ExecStartPost"));
    }

    public List<ExecutionInfo> getExecStartPre() {
        return ExecutionInfo.list(this.properties.getVector("ExecStartPre"));
    }

    public List<ExecutionInfo> getExecStopPost() {
        return ExecutionInfo.list(this.properties.getVector("ExecStopPost"));
    }

    public List<ExecutionInfo> getExecStopPre() {
        return ExecutionInfo.list(this.properties.getVector("ExecStopPre"));
    }

    public String getFileDescriptorName() {
        return this.properties.getString("FileDescriptorName");
    }

    public boolean isFreeBind() {
        return this.properties.getBoolean("FreeBind");
    }

    public int getIOSchedulingClass() {
        return this.properties.getInteger("IOSchedulingClass");
    }

    public int getIOSchedulingPriority() {
        return this.properties.getInteger("IOSchedulingPriority");
    }

    public int getIPTOS() {
        return this.properties.getInteger("IPTOS");
    }

    public int getIPTTL() {
        return this.properties.getInteger("IPTTL");
    }

    public boolean isIgnoreSIGPIPE() {
        return this.properties.getBoolean("IgnoreSIGPIPE");
    }

    public Vector<String> getInaccessiblePaths() {
        return this.properties.getVector("InaccessiblePaths");
    }

    public boolean isKeepAlive() {
        return this.properties.getBoolean("KeepAlive");
    }

    public BigInteger getKeepAliveIntervalUSec() {
        return this.properties.getBigInteger("KeepAliveIntervalUSec");
    }

    public long getKeepAliveProbes() {
        return this.properties.getLong("KeepAliveProbes");
    }

    public BigInteger getKeepAliveTimeUSec() {
        return this.properties.getBigInteger("KeepAliveTimeUSec");
    }

    public String getKillMode() {
        return this.properties.getString("KillMode");
    }

    public int getKillSignal() {
        return this.properties.getInteger("KillSignal");
    }

    public List<ListenInfo> getListen() {
        return ListenInfo.list(this.properties.getVector("Listen"));
    }

    public int getMark() {
        return this.properties.getInteger("Mark");
    }

    public long getMaxConnections() {
        return this.properties.getLong("MaxConnections");
    }

    public long getMaxConnectionsPerSource() {
        return this.properties.getLong("MaxConnectionsPerSource");
    }

    public long getMessageQueueMaxMessages() {
        return this.properties.getLong("MessageQueueMaxMessages");
    }

    public long getMessageQueueMessageSize() {
        return this.properties.getLong("MessageQueueMessageSize");
    }

    public BigInteger getMountFlags() {
        return this.properties.getBigInteger("MountFlags");
    }

    public long getNAccepted() {
        return this.properties.getLong("NAccepted");
    }

    public long getNConnections() {
        return this.properties.getLong("NConnections");
    }

    public int getNice() {
        return this.properties.getInteger("Nice");
    }

    public boolean isNoDelay() {
        return this.properties.getBoolean("NoDelay");
    }

    public boolean isNoNewPrivileges() {
        return this.properties.getBoolean("NoNewPrivileges");
    }

    public boolean isNonBlocking() {
        return this.properties.getBoolean("NonBlocking");
    }

    public int getOOMScoreAdjust() {
        return this.properties.getInteger("OOMScoreAdjust");
    }

    public String getPAMName() {
        return this.properties.getString("PAMName");
    }

    public boolean isPassCredentials() {
        return this.properties.getBoolean("PassCredentials");
    }

    public boolean isPassSecurity() {
        return this.properties.getBoolean("PassSecurity");
    }

    public BigInteger getPipeSize() {
        return this.properties.getBigInteger("PipeSize");
    }

    public int getPriority() {
        return this.properties.getInteger("Priority");
    }

    public Vector<String> getReadOnlyPaths() {
        return this.properties.getVector("ReadOnlyPaths");
    }

    public Vector<String> getReadWritePaths() {
        return this.properties.getVector("ReadWritePaths");
    }

    public BigInteger getReceiveBuffer() {
        return this.properties.getBigInteger("ReceiveBuffer");
    }

    public boolean isRemoveOnStop() {
        return this.properties.getBoolean("RemoveOnStop");
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public boolean getReusePort() {
        return this.properties.getBoolean("ReusePort");
    }

    public String getRootDirectory() {
        return this.properties.getString("RootDirectory");
    }

    public boolean isSameProcessGroup() {
        return this.properties.getBoolean("SameProcessGroup");
    }

    public int getSecureBits() {
        return this.properties.getInteger("SecureBits");
    }

    public BigInteger getSendBuffer() {
        return this.properties.getBigInteger("SendBuffer");
    }

    public boolean isSendSIGHUP() {
        return this.properties.getBoolean("SendSIGHUP");
    }

    public boolean isSendSIGKILL() {
        return this.properties.getBoolean("SendSIGKILL");
    }

    public String getSlice() {
        return this.properties.getString("Slice");
    }

    public String getSmackLabel() {
        return this.properties.getString("SmackLabel");
    }

    public String getSmackLabelIPIn() {
        return this.properties.getString("SmackLabelIPIn");
    }

    public String getSmackLabelIPOut() {
        return this.properties.getString("SmackLabelIPOut");
    }

    public String getSocketGroup() {
        return this.properties.getString("SocketGroup");
    }

    public long getSocketMode() {
        return this.properties.getLong("SocketMode");
    }

    public int getSocketProtocol() {
        return this.properties.getInteger("SocketProtocol");
    }

    public String getSocketUser() {
        return this.properties.getString("SocketUser");
    }

    public Vector<String> getSupplementaryGroups() {
        return this.properties.getVector("SupplementaryGroups");
    }

    public Vector<String> getSymlinks() {
        return this.properties.getVector("Symlinks");
    }

    public String getSyslogIdentifier() {
        return this.properties.getString("SyslogIdentifier");
    }

    public boolean isSyslogLevelPrefix() {
        return this.properties.getBoolean("SyslogLevelPrefix");
    }

    public int getSyslogPriority() {
        return this.properties.getInteger("SyslogPriority");
    }

    public SystemCallFilter getSystemCallFilter() {
        Object[] array = (Object[])this.properties.getVariant("SystemCallFilter").getValue();
        return new SystemCallFilter(array);
    }

    public String getTCPCongestion() {
        return this.properties.getString("TCPCongestion");
    }

    public long getTriggerLimitBurst() {
        return this.properties.getLong("TriggerLimitBurst");
    }

    public BigInteger getTriggerLimitIntervalUSec() {
        return this.properties.getBigInteger("TriggerLimitIntervalUSec");
    }

    public String getTTYPath() {
        return this.properties.getString("TTYPath");
    }

    public boolean isTTYReset() {
        return this.properties.getBoolean("TTYReset");
    }

    public boolean isTTYVHangup() {
        return this.properties.getBoolean("TTYVHangup");
    }

    public boolean isTTYVTDisallocate() {
        return this.properties.getBoolean("TTYVTDisallocate");
    }

    public BigInteger getTimeoutUSec() {
        return this.properties.getBigInteger("TimeoutUSec");
    }

    public BigInteger getTimerSlackNSec() {
        return this.properties.getBigInteger("TimerSlackNSec");
    }

    public boolean isTransparent() {
        return this.properties.getBoolean("Transparent");
    }

    public long getUMask() {
        return this.properties.getLong("UMask");
    }

    public String getWorkingDirectory() {
        return this.properties.getString("WorkingDirectory");
    }

    public boolean isWritable() {
        return this.properties.getBoolean("Writable");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String ACCEPT = "Accept";
        public static final String BACKLOG = "Backlog";
        public static final String BIND_IPV6_ONLY = "BindIPv6Only";
        public static final String BIND_TO_DEVICE = "BindToDevice";
        public static final String BROADCAST = "Broadcast";
        public static final String CAPABILITY_BOUNDING_SET = "CapabilityBoundingSet";
        public static final String CONTROL_PID = "ControlPID";
        public static final String DEFER_ACCEPT_USEC = "DeferAcceptUSec";
        public static final String DELEGATE = "Delegate";
        public static final String DELEGATE_CONTROLLERS = "DelegateControllers";
        public static final String DEVICE_ALLOW = "DeviceAllow";
        public static final String DEVICE_POLICY = "DevicePolicy";
        public static final String DIRECTORY_MODE = "DirectoryMode";
        public static final String ENVIRONMENT = "Environment";
        public static final String ENVIRONMENT_FILES = "EnvironmentFiles";
        public static final String EXEC_START_POST = "ExecStartPost";
        public static final String EXEC_START_PRE = "ExecStartPre";
        public static final String EXEC_STOP_POST = "ExecStopPost";
        public static final String EXEC_STOP_PRE = "ExecStopPre";
        public static final String FILE_DESCRIPTOR_NAME = "FileDescriptorName";
        public static final String FREE_BIND = "FreeBind";
        public static final String GROUP = "Group";
        public static final String IO_SCHEDULING_CLASS = "IOSchedulingClass";
        public static final String IO_SCHEDULING_PRIORITY = "IOSchedulingPriority";
        public static final String IP_TOS = "IPTOS";
        public static final String IP_TTL = "IPTTL";
        public static final String IGNORE_SIGPIPE = "IgnoreSIGPIPE";
        public static final String INACCESSIBLE_PATHS = "InaccessiblePaths";
        public static final String KEEP_ALIVE = "KeepAlive";
        public static final String KEEP_ALIVE_INTERVAL_USEC = "KeepAliveIntervalUSec";
        public static final String KEEP_ALIVE_PROBES = "KeepAliveProbes";
        public static final String KEEP_ALIVE_TIME_USEC = "KeepAliveTimeUSec";
        public static final String KILL_MODE = "KillMode";
        public static final String KILL_SIGNAL = "KillSignal";
        public static final String LISTEN = "Listen";
        public static final String MARK = "Mark";
        public static final String MAX_CONNECTIONS = "MaxConnections";
        public static final String MAX_CONNECTIONS_PER_SOURCE = "MaxConnectionsPerSource";
        public static final String MESSAGE_QUEUE_MAX_MESSAGES = "MessageQueueMaxMessages";
        public static final String MESSAGE_QUEUE_MESSAGE_SIZE = "MessageQueueMessageSize";
        public static final String MOUNT_FLAGS = "MountFlags";
        public static final String NACCEPTED = "NAccepted";
        public static final String NCONNECTIONS = "NConnections";
        public static final String NICE = "Nice";
        public static final String NO_DELAY = "NoDelay";
        public static final String NO_NEW_PRIVILEGES = "NoNewPrivileges";
        public static final String NON_BLOCKING = "NonBlocking";
        public static final String OOM_SCORE_ADJUST = "OOMScoreAdjust";
        public static final String PAM_NAME = "PAMName";
        public static final String PASS_CREDENTIALS = "PassCredentials";
        public static final String PASS_SECURITY = "PassSecurity";
        public static final String PIPE_SIZE = "PipeSize";
        public static final String PRIORITY = "Priority";
        public static final String READ_ONLY_PATHS = "ReadOnlyPaths";
        public static final String READ_WRITE_PATHS = "ReadWritePaths";
        public static final String RECEIVE_BUFFER = "ReceiveBuffer";
        public static final String REMOVE_ON_STOP = "RemoveOnStop";
        public static final String RESULT = "Result";
        public static final String REUSE_PORT = "ReusePort";
        public static final String ROOT_DIRECTORY = "RootDirectory";
        public static final String SAME_PROCESS_GROUP = "SameProcessGroup";
        public static final String SECURE_BITS = "SecureBits";
        public static final String SEND_BUFFER = "SendBuffer";
        public static final String SEND_SIGHUP = "SendSIGHUP";
        public static final String SEND_SIGKILL = "SendSIGKILL";
        public static final String SLICE = "Slice";
        public static final String SMACK_LABEL = "SmackLabel";
        public static final String SMACK_LABEL_IPIN = "SmackLabelIPIn";
        public static final String SMACK_LABEL_IPOUT = "SmackLabelIPOut";
        public static final String SOCKET_GROUP = "SocketGroup";
        public static final String SOCKET_MODE = "SocketMode";
        public static final String SOCKET_PROTOCOL = "SocketProtocol";
        public static final String SOCKET_USER = "SocketUser";
        public static final String SUPPLEMENTARY_GROUPS = "SupplementaryGroups";
        public static final String SYMLINKS = "Symlinks";
        public static final String SYSLOG_IDENTIFIER = "SyslogIdentifier";
        public static final String SYSLOG_LEVEL_PREFIX = "SyslogLevelPrefix";
        public static final String SYSLOG_PRIORITY = "SyslogPriority";
        public static final String SYSTEM_CALL_FILTER = "SystemCallFilter";
        public static final String TCP_CONGESTION = "TCPCongestion";
        public static final String TRIGGER_LIMIT_BURST = "TriggerLimitBurst";
        public static final String TRIGGER_LIMIT_INTERVAL_USEC = "TriggerLimitIntervalUSec";
        public static final String TTY_PATH = "TTYPath";
        public static final String TTY_RESET = "TTYReset";
        public static final String TTY_V_HANGUP = "TTYVHangup";
        public static final String TTY_VT_DISALLOCATE = "TTYVTDisallocate";
        public static final String TASKS_ACCOUNTING = "TasksAccounting";
        public static final String TASKS_CURRENT = "TasksCurrent";
        public static final String TASKS_MAX = "TasksMax";
        public static final String TIMEOUT_USEC = "TimeoutUSec";
        public static final String TIMER_SLACK_NSEC = "TimerSlackNSec";
        public static final String TRANSPARENT = "Transparent";
        public static final String UMASK = "UMask";
        public static final String WORKING_DIRECTORY = "WorkingDirectory";
        public static final String WRITABLE = "Writable";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class, ExtendedCpuAccounting.Property.class, DynamicUserAccounting.Property.class, IoAccounting.Property.class, IpAccounting.Property.class, ExtendedMemoryAccounting.Property.class, TasksAccounting.Property.class, Ulimit.Property.class);
        }
    }
}

