/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.Manager;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Systemd {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1";
    public static final String OBJECT_PATH = "/org/freedesktop/systemd1";
    public static final Pattern PATH_ESCAPE_PATTERN = Pattern.compile("(\\W)");
    public static final long DEFAULT_RETARDATION = 50L;
    private static final Logger log = LoggerFactory.getLogger(Systemd.class);
    private static final Systemd[] instances = new Systemd[InstanceType.values().length];
    private final InstanceType instanceType;
    private DBusConnection dbus;
    private Manager manager;

    private Systemd() {
        this(InstanceType.SYSTEM);
    }

    private Systemd(InstanceType instanceType) {
        this.instanceType = instanceType;
    }

    public static final String escapePath(CharSequence path) {
        if (path != null) {
            StringBuffer escaped = new StringBuffer(path.length());
            Matcher matcher = PATH_ESCAPE_PATTERN.matcher(path);
            while (matcher.find()) {
                String replacement = '_' + Integer.toHexString(matcher.group().charAt(0));
                matcher.appendReplacement(escaped, replacement);
            }
            matcher.appendTail(escaped);
            return escaped.toString();
        }
        return "";
    }

    public static final Date timestampToDate(long timestamp) {
        return new Date(timestamp / 1000L);
    }

    public static final String id128ToString(byte[] id128) {
        return DatatypeConverter.printHexBinary((byte[])id128).toLowerCase();
    }

    public static Systemd get() throws DBusException {
        return Systemd.get(InstanceType.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Systemd get(InstanceType instanceType) throws DBusException {
        int index = instanceType.getIndex();
        Systemd[] systemdArray = instances;
        synchronized (instances) {
            Systemd instance;
            if (instances[index] == null) {
                instance = new Systemd(instanceType);
                instance.open();
                Systemd.instances[index] = instance;
            } else {
                instance = instances[index];
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return instance;
        }
    }

    public static void disconnect() {
        Systemd.disconnect(InstanceType.SYSTEM);
    }

    public static void disconnect(InstanceType instanceType) {
        Systemd.disconnect(instanceType, 50L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnect(InstanceType instanceType, long retardationTime) {
        int index = instanceType.getIndex();
        Systemd[] systemdArray = instances;
        synchronized (instances) {
            Systemd instance = instances[index];
            if (instance != null) {
                try {
                    instance.close(retardationTime);
                }
                catch (InterruptedException e) {
                    log.error("Disconnection interrupted while retarding", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            Systemd.instances[index] = null;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    public static void disconnectAll() {
        Systemd.disconnectAll(50L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnectAll(long retardationTime) {
        Systemd[] systemdArray = instances;
        synchronized (instances) {
            for (Systemd instance : instances) {
                if (instance == null) continue;
                try {
                    instance.close(retardationTime);
                }
                catch (InterruptedException e) {
                    log.error("Disconnection interrupted while retarding", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            Arrays.fill(instances, null);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    private void open() throws DBusException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Connecting to %s bus", new Object[]{this.instanceType}));
        }
        try {
            this.dbus = DBusConnection.getConnection((int)this.instanceType.getIndex());
        }
        catch (DBusException e) {
            log.error(String.format("Unable to connect to %s bus", new Object[]{this.instanceType}), (Throwable)e);
            throw e;
        }
    }

    private void close(long retardationTime) throws InterruptedException {
        if (this.isConnected()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Disconnecting from %s bus", new Object[]{this.instanceType}));
            }
            this.dbus.disconnect();
            Thread.sleep(retardationTime);
        }
        this.dbus = null;
        this.manager = null;
    }

    public boolean isConnected() {
        return this.dbus != null && !(this.dbus.getError() instanceof NotConnected);
    }

    Optional<DBusConnection> getConnection() {
        return Optional.ofNullable(this.dbus);
    }

    public Manager getManager() throws DBusException {
        if (this.manager == null) {
            if (!this.isConnected()) {
                throw new DBusException("Unable to create manager without bus (please connect first)");
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Creating new manager instance on %s bus", new Object[]{this.instanceType}));
            }
            this.manager = Manager.create(this.dbus);
        }
        return this.manager;
    }

    public static enum InstanceType {
        SYSTEM(0),
        USER(1);

        private final int index;

        private InstanceType(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

