/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd.features;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.features.Feature;
import de.thjom.java.systemd.types.IOBandwidth;
import de.thjom.java.systemd.types.IODeviceWeight;
import de.thjom.java.systemd.types.IOIops;
import java.math.BigInteger;
import java.util.List;

public interface IoAccounting
extends Feature {
    default public boolean isBlockIOAccounting() {
        return this.getProperties().getBoolean("BlockIOAccounting");
    }

    default public List<IODeviceWeight> getBlockIODeviceWeight() {
        return IODeviceWeight.list(this.getProperties().getVector("BlockIODeviceWeight"));
    }

    default public List<IOBandwidth> getBlockIOReadBandwidth() {
        return IOBandwidth.list(this.getProperties().getVector("BlockIOReadBandwidth"));
    }

    default public BigInteger getBlockIOWeight() {
        return this.getProperties().getBigInteger("BlockIOWeight");
    }

    default public List<IOBandwidth> getBlockIOWriteBandwidth() {
        return IOBandwidth.list(this.getProperties().getVector("BlockIOWriteBandwidth"));
    }

    default public boolean isIOAccounting() {
        return this.getProperties().getBoolean("IOAccounting");
    }

    default public List<IODeviceWeight> getIODeviceWeight() {
        return IODeviceWeight.list(this.getProperties().getVector("IODeviceWeight"));
    }

    default public List<IOBandwidth> getIOReadBandwidthMax() {
        return IOBandwidth.list(this.getProperties().getVector("IOReadBandwidthMax"));
    }

    default public List<IOIops> getIOReadIOPSMax() {
        return IOIops.list(this.getProperties().getVector("IOReadIOPSMax"));
    }

    default public BigInteger getIOWeight() {
        return this.getProperties().getBigInteger("IOWeight");
    }

    default public List<IOBandwidth> getIOWriteBandwidthMax() {
        return IOBandwidth.list(this.getProperties().getVector("IOWriteBandwidthMax"));
    }

    default public List<IOIops> getIOWriteIOPSMax() {
        return IOIops.list(this.getProperties().getVector("IOWriteIOPSMax"));
    }

    default public BigInteger getStartupBlockIOWeight() {
        return this.getProperties().getBigInteger("StartupBlockIOWeight");
    }

    default public BigInteger getStartupIOWeight() {
        return this.getProperties().getBigInteger("StartupIOWeight");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String BLOCK_IO_ACCOUNTING = "BlockIOAccounting";
        public static final String BLOCK_IO_DEVICE_WEIGHT = "BlockIODeviceWeight";
        public static final String BLOCK_IO_READ_BANDWIDTH = "BlockIOReadBandwidth";
        public static final String BLOCK_IO_WEIGHT = "BlockIOWeight";
        public static final String BLOCK_IO_WRITE_BANDWIDTH = "BlockIOWriteBandwidth";
        public static final String IO_ACCOUNTING = "IOAccounting";
        public static final String IO_DEVICE_WEIGHT = "IODeviceWeight";
        public static final String IO_READ_BANDWIDTH_MAX = "IOReadBandwidthMax";
        public static final String IO_READ_IOPS_MAX = "IOReadIOPSMax";
        public static final String IO_WEIGHT = "IOWeight";
        public static final String IO_WRITE_BANDWIDTH_MAX = "IOWriteBandwidthMax";
        public static final String IO_WRITE_IOPS_MAX = "IOWriteIOPSMax";
        public static final String STARTUP_BLOCK_IO_WEIGHT = "StartupBlockIOWeight";
        public static final String STARTUP_IO_WEIGHT = "StartupIOWeight";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

