/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd.types;

import de.thjom.java.systemd.types.UnitBase;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.Position;
import org.freedesktop.dbus.UInt32;

public class UnitType
extends UnitBase
implements Comparable<UnitType> {
    @Position(value=0)
    private final String unitName;
    @Position(value=1)
    private final String unitDescription;
    @Position(value=2)
    private final String loadState;
    @Position(value=3)
    private final String activeState;
    @Position(value=4)
    private final String subState;
    @Position(value=5)
    private final String followingUnit;
    @Position(value=6)
    private final Path unitObjectPath;
    @Position(value=7)
    private final int jobId;
    @Position(value=8)
    private final String jobType;
    @Position(value=9)
    private final Path jobObjectPath;

    public UnitType(String unitName, String unitDescription, String loadState, String activeState, String subState, String followingUnit, Path unitObjectPath, UInt32 jobId, String jobType, Path jobObjectPath) {
        super(unitName);
        this.unitName = unitName;
        this.unitDescription = unitDescription;
        this.loadState = loadState;
        this.activeState = activeState;
        this.subState = subState;
        this.followingUnit = followingUnit;
        this.unitObjectPath = unitObjectPath;
        this.jobId = jobId.intValue();
        this.jobType = jobType;
        this.jobObjectPath = jobObjectPath;
    }

    public String getSummary() {
        StringBuilder summary = new StringBuilder(500);
        summary.append(this.unitName).append(System.lineSeparator());
        summary.append(String.format(" Description: %s", this.unitDescription)).append(System.lineSeparator());
        summary.append(String.format(" LoadState: %s", this.loadState)).append(System.lineSeparator());
        summary.append(String.format(" ActiveState: %s", this.activeState)).append(System.lineSeparator());
        summary.append(String.format(" SubState: %s", this.subState)).append(System.lineSeparator());
        summary.append(String.format(" FollowingUnit: %s", this.followingUnit)).append(System.lineSeparator());
        summary.append(String.format(" ObjectPath: %s", this.unitObjectPath)).append(System.lineSeparator());
        summary.append(String.format(" JobID: %d", this.jobId)).append(System.lineSeparator());
        summary.append(String.format(" JobType: %s", this.jobType)).append(System.lineSeparator());
        summary.append(String.format(" JobObjectPath: %s", this.jobObjectPath));
        summary.trimToSize();
        return summary.toString();
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getUnitDescription() {
        return this.unitDescription;
    }

    public String getLoadState() {
        return this.loadState;
    }

    public String getActiveState() {
        return this.activeState;
    }

    public String getSubState() {
        return this.subState;
    }

    public String getFollowingUnit() {
        return this.followingUnit;
    }

    public Path getUnitObjectPath() {
        return this.unitObjectPath;
    }

    public int getJobId() {
        return this.jobId;
    }

    public String getJobType() {
        return this.jobType;
    }

    public Path getJobObjectPath() {
        return this.jobObjectPath;
    }

    @Override
    public int compareTo(UnitType other) {
        if (other == null) {
            return Integer.MAX_VALUE;
        }
        return this.unitName.compareTo(other.unitName);
    }
}

