/*
 * Java-systemd implementation
 * Copyright (c) 2016 Markus Enax
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of either the GNU Lesser General Public License Version 2 or the
 * Academic Free Licence Version 3.0.
 *
 * Full licence texts are included in the COPYING file with this program.
 */

/**
 * This package provides classes and interfaces which can be used to interact
 * with "systemd" via D-Bus. The classes provide connectivity to the system
 * and session (user) bus along access to the particular managers and all
 * known units and unit types. Some additional types present pre-built tools
 * which provide basic monitoring features and listener/notifier patterns.
 *
 * @see <a href="https://github.com/thjomnx/java-systemd">GitHub project</a>
 * @see <a href="https://www.freedesktop.org/wiki/Software/systemd">systemd</a>
 * @see <a href="https://www.freedesktop.org/wiki/Software/dbus">D-Bus</a>
 */

package de.thjom.java.systemd;
