/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.UnitStateListener;
import java.util.ArrayList;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.DBusSignal;

abstract class AbstractAdapter {
    protected final List<UnitStateListener> unitStateListeners = new ArrayList<UnitStateListener>();
    private DBusSigHandler<Properties.PropertiesChanged> defaultHandler;

    protected AbstractAdapter() {
    }

    public abstract <T extends DBusSignal> void addHandler(Class<T> var1, DBusSigHandler<T> var2) throws DBusException;

    public abstract <T extends DBusSignal> void removeHandler(Class<T> var1, DBusSigHandler<T> var2) throws DBusException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UnitStateListener listener) throws DBusException {
        List<UnitStateListener> list = this.unitStateListeners;
        synchronized (list) {
            if (this.defaultHandler == null) {
                this.defaultHandler = this.createStateHandler();
                this.addHandler(Properties.PropertiesChanged.class, this.defaultHandler);
            }
            this.unitStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(UnitStateListener listener) throws DBusException {
        List<UnitStateListener> list = this.unitStateListeners;
        synchronized (list) {
            this.unitStateListeners.remove(listener);
            if (this.unitStateListeners.isEmpty() && this.defaultHandler != null) {
                this.removeHandler(Properties.PropertiesChanged.class, this.defaultHandler);
                this.defaultHandler = null;
            }
        }
    }

    protected DBusSigHandler<Properties.PropertiesChanged> createStateHandler() {
        return signal -> {};
    }
}

