/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.AbstractAdapter;
import de.thjom.java.systemd.Properties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InterfaceAdapter
extends AbstractAdapter
implements DBusInterface {
    protected final DBusConnection dbus;
    protected Properties properties;
    private final DBusInterface iface;

    protected InterfaceAdapter(DBusConnection dbus, DBusInterface iface) {
        this.dbus = Objects.requireNonNull(dbus);
        this.iface = Objects.requireNonNull(iface);
    }

    public String getObjectPath() {
        return this.getInterface().getObjectPath();
    }

    public boolean isRemote() {
        return this.getInterface().isRemote();
    }

    public DBusInterface getInterface() {
        return this.iface;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public <T extends DBusSignal> void addHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        this.dbus.addSigHandler(type, handler);
    }

    @Override
    public <T extends DBusSignal> void removeHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (handler != null) {
            this.dbus.removeSigHandler(type, handler);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            InterfaceAdapter other = (InterfaceAdapter)obj;
            return this.dbus.getUniqueName().equals(other.dbus.getUniqueName()) && this.getObjectPath().equals(other.getObjectPath());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dbus.getUniqueName(), this.getObjectPath());
    }

    public static class AdapterProperty {
        private static final Logger LOG = LoggerFactory.getLogger(AdapterProperty.class);

        protected AdapterProperty() {
        }

        protected static List<String> getAllNames(Class<?> ... types) {
            ArrayList<String> names = new ArrayList<String>();
            for (Class<?> type : types) {
                Field[] fields;
                for (Field field : fields = type.getDeclaredFields()) {
                    if (field.isSynthetic()) continue;
                    Object obj = "";
                    try {
                        obj = field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        LOG.error("Unable to enumerate field names", (Throwable)e);
                    }
                    names.add(obj.toString());
                }
            }
            return names;
        }
    }
}

