/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.interfaces.PropertyInterface;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;

public class Properties
extends InterfaceAdapter {
    public static final String SERVICE_NAME = "org.freedesktop.DBus.Properties";
    private final String serviceName;

    private Properties(DBusConnection dbus, PropertyInterface iface, String serviceName) {
        super(dbus, iface);
        this.serviceName = Objects.requireNonNull(serviceName);
    }

    static Properties create(DBusConnection dbus, String objectPath, String serviceName) throws DBusException {
        PropertyInterface iface = (PropertyInterface)dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, PropertyInterface.class);
        return new Properties(dbus, iface, serviceName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Properties other = (Properties)obj;
            return super.equals(obj) && this.serviceName.equals(other.serviceName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.serviceName);
    }

    @Override
    public PropertyInterface getInterface() {
        return (PropertyInterface)super.getInterface();
    }

    @Override
    public Properties getProperties() {
        return this;
    }

    public Variant<?> getVariant(String propertyName) {
        return this.getInterface().getProperty(this.serviceName, propertyName);
    }

    public boolean getBoolean(String propertyName) {
        return (Boolean)this.getVariant(propertyName).getValue();
    }

    public byte getByte(String propertyName) {
        return (Byte)this.getVariant(propertyName).getValue();
    }

    public short getShort(String propertyName) {
        Number value = (Number)this.getVariant(propertyName).getValue();
        return value.shortValue();
    }

    public int getInteger(String propertyName) {
        Number value = (Number)this.getVariant(propertyName).getValue();
        return value.intValue();
    }

    public long getLong(String propertyName) {
        Number value = (Number)this.getVariant(propertyName).getValue();
        return value.longValue();
    }

    public BigInteger getBigInteger(String propertyName) {
        UInt64 value = (UInt64)this.getVariant(propertyName).getValue();
        return value.value();
    }

    public double getDouble(String propertyName) {
        Number value = (Number)this.getVariant(propertyName).getValue();
        return value.doubleValue();
    }

    public String getString(String propertyName) {
        return String.valueOf(this.getVariant(propertyName).getValue());
    }

    public <T> List<T> getList(String propertyName) {
        return (List)this.getVariant(propertyName).getValue();
    }
}

