/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.features.CpuAccounting;
import de.thjom.java.systemd.features.IoAccounting;
import de.thjom.java.systemd.features.IpAccounting;
import de.thjom.java.systemd.features.MemoryAccounting;
import de.thjom.java.systemd.features.ResourceControl;
import de.thjom.java.systemd.features.TasksAccounting;
import de.thjom.java.systemd.interfaces.SliceInterface;
import de.thjom.java.systemd.types.DeviceAllowControl;
import de.thjom.java.systemd.types.UnitProcessType;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;

public class Slice
extends Unit
implements CpuAccounting,
IoAccounting,
IpAccounting,
MemoryAccounting,
ResourceControl,
TasksAccounting {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Slice";
    public static final String UNIT_SUFFIX = ".slice";

    private Slice(Manager manager, SliceInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Slice create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        SliceInterface iface = (SliceInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, SliceInterface.class);
        return new Slice(manager, iface, name);
    }

    @Override
    public SliceInterface getInterface() {
        return (SliceInterface)super.getInterface();
    }

    public void attachProcesses(String cgroupPath, long[] pids) {
        this.getInterface().attachProcesses(cgroupPath, pids);
    }

    public List<UnitProcessType> getProcesses() {
        return this.getInterface().getProcesses();
    }

    public String getControlGroup() {
        return this.properties.getString("ControlGroup");
    }

    public List<DeviceAllowControl> getDeviceAllow() {
        return DeviceAllowControl.list(this.properties.getList("DeviceAllow"));
    }

    public String getDevicePolicy() {
        return this.properties.getString("DevicePolicy");
    }

    public String getSlice() {
        return this.properties.getString("Slice");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String CONTROL_GROUP = "ControlGroup";
        public static final String DEVICE_ALLOW = "DeviceAllow";
        public static final String DEVICE_POLICY = "DevicePolicy";
        public static final String SLICE = "Slice";

        private Property() {
        }

        public static List<String> getAllNames() {
            return Property.getAllNames(Property.class, CpuAccounting.Property.class, IoAccounting.Property.class, IpAccounting.Property.class, MemoryAccounting.Property.class, ResourceControl.Property.class, TasksAccounting.Property.class);
        }
    }
}

