/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.features.DynamicUserAccounting;
import de.thjom.java.systemd.features.ExtendedCpuAccounting;
import de.thjom.java.systemd.features.ExtendedMemoryAccounting;
import de.thjom.java.systemd.features.IoAccounting;
import de.thjom.java.systemd.features.IpAccounting;
import de.thjom.java.systemd.features.ResourceControl;
import de.thjom.java.systemd.features.TasksAccounting;
import de.thjom.java.systemd.features.Ulimit;
import de.thjom.java.systemd.interfaces.SwapInterface;
import de.thjom.java.systemd.types.DeviceAllowControl;
import de.thjom.java.systemd.types.EnvironmentFile;
import de.thjom.java.systemd.types.ExecutionInfo;
import de.thjom.java.systemd.types.SystemCallFilter;
import de.thjom.java.systemd.types.UnitProcessType;
import java.math.BigInteger;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;

public class Swap
extends Unit
implements ExtendedCpuAccounting,
DynamicUserAccounting,
IoAccounting,
IpAccounting,
ExtendedMemoryAccounting,
ResourceControl,
TasksAccounting,
Ulimit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Swap";
    public static final String UNIT_SUFFIX = ".swap";

    private Swap(Manager manager, SwapInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Swap create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        SwapInterface iface = (SwapInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, SwapInterface.class);
        return new Swap(manager, iface, name);
    }

    @Override
    public SwapInterface getInterface() {
        return (SwapInterface)super.getInterface();
    }

    public void attachProcesses(String cgroupPath, long[] pids) {
        this.getInterface().attachProcesses(cgroupPath, pids);
    }

    public List<UnitProcessType> getProcesses() {
        return this.getInterface().getProcesses();
    }

    public BigInteger getCapabilityBoundingSet() {
        return this.properties.getBigInteger("CapabilityBoundingSet");
    }

    public long getControlPID() {
        return this.properties.getLong("ControlPID");
    }

    public List<DeviceAllowControl> getDeviceAllow() {
        return DeviceAllowControl.list(this.properties.getList("DeviceAllow"));
    }

    public String getDevicePolicy() {
        return this.properties.getString("DevicePolicy");
    }

    public List<String> getEnvironment() {
        return this.properties.getList("Environment");
    }

    public List<EnvironmentFile> getEnvironmentFiles() {
        return EnvironmentFile.list(this.properties.getList("EnvironmentFiles"));
    }

    public List<ExecutionInfo> getExecActivate() {
        return ExecutionInfo.list(this.properties.getList("ExecActivate"));
    }

    public List<ExecutionInfo> getExecDeactivate() {
        return ExecutionInfo.list(this.properties.getList("ExecDeactivate"));
    }

    public int getFinalKillSignal() {
        return this.properties.getInteger("FinalKillSignal");
    }

    public boolean isIgnoreSIGPIPE() {
        return this.properties.getBoolean("IgnoreSIGPIPE");
    }

    public List<String> getInaccessiblePaths() {
        return this.properties.getList("InaccessiblePaths");
    }

    public int getIOSchedulingClass() {
        return this.properties.getInteger("IOSchedulingClass");
    }

    public int getIOSchedulingPriority() {
        return this.properties.getInteger("IOSchedulingPriority");
    }

    public String getKillMode() {
        return this.properties.getString("KillMode");
    }

    public int getKillSignal() {
        return this.properties.getInteger("KillSignal");
    }

    public BigInteger getMountFlags() {
        return this.properties.getBigInteger("MountFlags");
    }

    public int getNice() {
        return this.properties.getInteger("Nice");
    }

    public boolean isNoNewPrivileges() {
        return this.properties.getBoolean("NoNewPrivileges");
    }

    public boolean isNonBlocking() {
        return this.properties.getBoolean("NonBlocking");
    }

    public int getOOMScoreAdjust() {
        return this.properties.getInteger("OOMScoreAdjust");
    }

    public String getOptions() {
        return this.properties.getString("Options");
    }

    public String getPAMName() {
        return this.properties.getString("PAMName");
    }

    public int getPriority() {
        return this.properties.getInteger("Priority");
    }

    public List<String> getReadOnlyPaths() {
        return this.properties.getList("ReadOnlyPaths");
    }

    public List<String> getReadWritePaths() {
        return this.properties.getList("ReadWritePaths");
    }

    public int getRestartKillSignal() {
        return this.properties.getInteger("RestartKillSignal");
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public String getRootDirectory() {
        return this.properties.getString("RootDirectory");
    }

    public boolean isSameProcessGroup() {
        return this.properties.getBoolean("SameProcessGroup");
    }

    public int getSecureBits() {
        return this.properties.getInteger("SecureBits");
    }

    public boolean isSendSIGHUP() {
        return this.properties.getBoolean("SendSIGHUP");
    }

    public boolean isSendSIGKILL() {
        return this.properties.getBoolean("SendSIGKILL");
    }

    public String getSlice() {
        return this.properties.getString("Slice");
    }

    public List<String> getSupplementaryGroups() {
        return this.properties.getList("SupplementaryGroups");
    }

    public String getSyslogIdentifier() {
        return this.properties.getString("SyslogIdentifier");
    }

    public boolean isSyslogLevelPrefix() {
        return this.properties.getBoolean("SyslogLevelPrefix");
    }

    public int getSyslogPriority() {
        return this.properties.getInteger("SyslogPriority");
    }

    public SystemCallFilter getSystemCallFilter() {
        Object[] array = (Object[])this.properties.getVariant("SystemCallFilter").getValue();
        return new SystemCallFilter(array);
    }

    public String getTTYPath() {
        return this.properties.getString("TTYPath");
    }

    public boolean isTTYReset() {
        return this.properties.getBoolean("TTYReset");
    }

    public boolean isTTYVHangup() {
        return this.properties.getBoolean("TTYVHangup");
    }

    public boolean isTTYVTDisallocate() {
        return this.properties.getBoolean("TTYVTDisallocate");
    }

    public BigInteger getTimeoutUSec() {
        return this.properties.getBigInteger("TimeoutUSec");
    }

    public long getTimerSlackNSec() {
        return this.properties.getLong("TimerSlackNSec");
    }

    public long getUMask() {
        return this.properties.getLong("UMask");
    }

    public int getWatchdogSignal() {
        return this.properties.getInteger("WatchdogSignal");
    }

    public String getWhat() {
        return this.properties.getString("What");
    }

    public String getWorkingDirectory() {
        return this.properties.getString("WorkingDirectory");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String CAPABILITY_BOUNDING_SET = "CapabilityBoundingSet";
        public static final String CONTROL_PID = "ControlPID";
        public static final String DEVICE_ALLOW = "DeviceAllow";
        public static final String DEVICE_POLICY = "DevicePolicy";
        public static final String DYNAMIC_USER = "DynamicUser";
        public static final String ENVIRONMENT = "Environment";
        public static final String ENVIRONMENT_FILES = "EnvironmentFiles";
        public static final String EXEC_ACTIVATE = "ExecActivate";
        public static final String EXEC_DEACTIVATE = "ExecDeactivate";
        public static final String FINAL_KILL_SIGNAL = "FinalKillSignal";
        public static final String IGNORE_SIGPIPE = "IgnoreSIGPIPE";
        public static final String INACCESSIBLE_PATHS = "InaccessiblePaths";
        public static final String IO_SCHEDULING_CLASS = "IOSchedulingClass";
        public static final String IO_SCHEDULING_PRIORITY = "IOSchedulingPriority";
        public static final String KILL_MODE = "KillMode";
        public static final String KILL_SIGNAL = "KillSignal";
        public static final String MOUNT_FLAGS = "MountFlags";
        public static final String NICE = "Nice";
        public static final String NON_BLOCKING = "NonBlocking";
        public static final String NO_NEW_PRIVILEGES = "NoNewPrivileges";
        public static final String OOM_SCORE_ADJUST = "OOMScoreAdjust";
        public static final String OPTIONS = "Options";
        public static final String PAM_NAME = "PAMName";
        public static final String PRIORITY = "Priority";
        public static final String READ_ONLY_PATHS = "ReadOnlyPaths";
        public static final String READ_WRITE_PATHS = "ReadWritePaths";
        public static final String RESTART_KILL_SIGNAL = "RestartKillSignal";
        public static final String RESULT = "Result";
        public static final String ROOT_DIRECTORY = "RootDirectory";
        public static final String SAME_PROCESS_GROUP = "SameProcessGroup";
        public static final String SECURE_BITS = "SecureBits";
        public static final String SEND_SIGHUP = "SendSIGHUP";
        public static final String SEND_SIGKILL = "SendSIGKILL";
        public static final String SLICE = "Slice";
        public static final String SUPPLEMENTARY_GROUPS = "SupplementaryGroups";
        public static final String SYSLOG_IDENTIFIER = "SyslogIdentifier";
        public static final String SYSLOG_LEVEL_PREFIX = "SyslogLevelPrefix";
        public static final String SYSLOG_PRIORITY = "SyslogPriority";
        public static final String SYSTEM_CALL_FILTER = "SystemCallFilter";
        public static final String TIMEOUT_USEC = "TimeoutUSec";
        public static final String TIMER_SLACK_NSEC = "TimerSlackNSec";
        public static final String TTY_PATH = "TTYPath";
        public static final String TTY_RESET = "TTYReset";
        public static final String TTY_V_HANGUP = "TTYVHangup";
        public static final String TTY_VT_DISALLOCATE = "TTYVTDisallocate";
        public static final String UMASK = "UMask";
        public static final String WATCHDOG_SIGNAL = "WatchdogSignal";
        public static final String WHAT = "What";
        public static final String WORKING_DIRECTORY = "WorkingDirectory";

        private Property() {
        }

        public static List<String> getAllNames() {
            return Property.getAllNames(Property.class, ExtendedCpuAccounting.Property.class, DynamicUserAccounting.Property.class, IoAccounting.Property.class, IpAccounting.Property.class, ExtendedMemoryAccounting.Property.class, ResourceControl.Property.class, TasksAccounting.Property.class, Ulimit.Property.class);
        }
    }
}

