/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.Manager;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Systemd {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1";
    public static final String OBJECT_PATH = "/org/freedesktop/systemd1";
    public static final Pattern PATH_ESCAPE_PATTERN = Pattern.compile("([\\W_])");
    public static final byte DEFAULT_THREAD_POOL_SIZE = 1;
    private static final Logger LOG = LoggerFactory.getLogger(Systemd.class);
    private static final Systemd[] INSTANCES = new Systemd[InstanceType.values().length];
    private final InstanceType instanceType;
    private DBusConnection dbus;
    private Manager manager;

    private Systemd(InstanceType instanceType) {
        this.instanceType = instanceType;
    }

    public static String escapePath(CharSequence path) {
        if (path != null) {
            StringBuilder escaped = new StringBuilder(path.length());
            Matcher matcher = PATH_ESCAPE_PATTERN.matcher(path);
            while (matcher.find()) {
                String replacement = "_" + Integer.toHexString(matcher.group().charAt(0));
                matcher.appendReplacement(escaped, replacement);
            }
            matcher.appendTail(escaped);
            return escaped.toString();
        }
        return "";
    }

    public static Instant timestampToInstant(long timestamp) {
        return Instant.EPOCH.plus(timestamp, ChronoUnit.MICROS);
    }

    public static Duration usecsToDuration(long usecs) {
        return Duration.of(usecs, ChronoUnit.MICROS);
    }

    public static String id128ToString(byte[] id128) {
        return DatatypeConverter.printHexBinary((byte[])id128).toLowerCase();
    }

    public static Systemd get() throws DBusException {
        return Systemd.get(InstanceType.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Systemd get(InstanceType instanceType) throws DBusException {
        DBusConnection.DBusBusType index = instanceType.getIndex();
        Systemd[] systemdArray = INSTANCES;
        synchronized (INSTANCES) {
            Systemd instance;
            if (INSTANCES[index.ordinal()] == null) {
                instance = new Systemd(instanceType);
                instance.open();
                Systemd.INSTANCES[index.ordinal()] = instance;
            } else {
                instance = INSTANCES[index.ordinal()];
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return instance;
        }
    }

    public static void disconnect() {
        Systemd.disconnect(InstanceType.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnect(InstanceType instanceType) {
        DBusConnection.DBusBusType index = instanceType.getIndex();
        Systemd[] systemdArray = INSTANCES;
        synchronized (INSTANCES) {
            Systemd instance = INSTANCES[index.ordinal()];
            if (instance != null) {
                instance.close();
            }
            Systemd.INSTANCES[index.ordinal()] = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnectAll() {
        Systemd[] systemdArray = INSTANCES;
        synchronized (INSTANCES) {
            for (Systemd instance : INSTANCES) {
                if (instance == null) continue;
                instance.close();
            }
            Arrays.fill(INSTANCES, null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void open() throws DBusException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Connecting to %s bus", new Object[]{this.instanceType}));
        }
        try {
            this.dbus = DBusConnection.getConnection((DBusConnection.DBusBusType)this.instanceType.getIndex());
            this.dbus.changeThreadCount((byte)1);
        }
        catch (DBusException e) {
            LOG.error(String.format("Unable to connect to %s bus", new Object[]{this.instanceType}), (Throwable)e);
            throw e;
        }
    }

    private void close() {
        if (this.isConnected()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Disconnecting from %s bus", new Object[]{this.instanceType}));
            }
            this.dbus.disconnect();
        }
        this.dbus = null;
        this.manager = null;
    }

    public boolean isConnected() {
        return this.dbus != null && !(this.dbus.getError() instanceof NotConnected);
    }

    Optional<DBusConnection> getConnection() {
        return Optional.ofNullable(this.dbus);
    }

    public Manager getManager() throws DBusException {
        if (this.manager == null) {
            if (!this.isConnected()) {
                throw new DBusException("Unable to create manager without bus (please connect first)");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Creating new manager instance on %s bus", new Object[]{this.instanceType}));
            }
            this.manager = Manager.create(this.dbus);
        }
        return this.manager;
    }

    public static enum InstanceType {
        SYSTEM(DBusConnection.DBusBusType.SYSTEM),
        USER(DBusConnection.DBusBusType.SESSION);

        private final DBusConnection.DBusBusType index;

        private InstanceType(DBusConnection.DBusBusType index) {
            this.index = index;
        }

        public final DBusConnection.DBusBusType getIndex() {
            return this.index;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

