/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.TargetInterface;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;

public class Target
extends Unit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Target";
    public static final String UNIT_SUFFIX = ".target";

    private Target(Manager manager, TargetInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Target create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        TargetInterface iface = (TargetInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, TargetInterface.class);
        return new Target(manager, iface, name);
    }

    @Override
    public TargetInterface getInterface() {
        return (TargetInterface)super.getInterface();
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        private Property() {
        }

        public static List<String> getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

