/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.UnitStateNotifier;
import de.thjom.java.systemd.interfaces.UnitInterface;
import de.thjom.java.systemd.types.Condition;
import de.thjom.java.systemd.types.Job;
import de.thjom.java.systemd.types.LoadError;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.Variant;

public abstract class Unit
extends InterfaceAdapter
implements UnitStateNotifier {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Unit";
    public static final String OBJECT_PATH = "/org/freedesktop/systemd1/unit/";
    protected final String name;
    protected final Manager manager;
    private final Properties unitProperties;

    protected Unit(Manager manager, UnitInterface iface, String name) throws DBusException {
        super(manager.dbus, iface);
        this.name = Objects.requireNonNull(name);
        this.manager = Objects.requireNonNull(manager);
        this.unitProperties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    public static String normalizeName(String name, String suffix) {
        Object normalized = name != null ? (suffix != null ? (name.endsWith(suffix) ? name : name + suffix) : name) : "";
        return normalized;
    }

    public static String extractName(String objectPath) {
        String name = objectPath != null && objectPath.startsWith(OBJECT_PATH) ? objectPath.substring(OBJECT_PATH.length()) : "";
        return name;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Unit other = (Unit)obj;
            return super.equals(obj) && this.name.equals(other.name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    @Override
    public UnitInterface getInterface() {
        return (UnitInterface)super.getInterface();
    }

    public final Properties getUnitProperties() {
        return this.unitProperties;
    }

    public boolean isAssignableFrom(String objectPath) {
        return Unit.extractName(objectPath).equals(Systemd.escapePath(this.name));
    }

    @Override
    public <T extends DBusSignal> void addHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        this.manager.subscribe();
        this.dbus.addSigHandler(type, (DBusInterface)this.getInterface(), handler);
    }

    @Override
    public <T extends DBusSignal> void removeHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (handler != null) {
            this.dbus.removeSigHandler(type, (DBusInterface)this.getInterface(), handler);
        }
    }

    @Override
    protected DBusSigHandler<Properties.PropertiesChanged> createStateHandler() {
        return signal -> {
            Map properties = signal.getPropertiesChanged();
            if (properties.containsKey("ActiveState") || properties.containsKey("LoadState") || properties.containsKey("SubState")) {
                List list = this.unitStateListeners;
                synchronized (list) {
                    this.unitStateListeners.forEach(l -> l.stateChanged(this, properties));
                }
            }
        };
    }

    public String introspect() throws DBusException {
        Introspectable intro = (Introspectable)this.dbus.getRemoteObject("org.freedesktop.systemd1", this.getInterface().getObjectPath(), Introspectable.class);
        return intro.Introspect();
    }

    public void clean(List<String> mask) {
        this.manager.cleanUnit(this.name, mask);
    }

    public void freeze() {
        this.manager.freezeUnit(this.name);
    }

    public void kill(Who who, int signal) {
        this.kill(who.getValue(), signal);
    }

    public void kill(String who, int signal) {
        this.manager.killUnit(this.name, who, signal);
    }

    public void ref() {
        this.manager.refUnit(this.name);
    }

    public DBusPath reload(Mode mode) {
        return this.reload(mode.getValue());
    }

    public DBusPath reload(String mode) {
        return this.manager.reloadUnit(this.name, mode);
    }

    public DBusPath reloadOrRestart(Mode mode) {
        return this.reloadOrRestart(mode.getValue());
    }

    public DBusPath reloadOrRestart(String mode) {
        return this.manager.reloadOrRestartUnit(this.name, mode);
    }

    public DBusPath reloadOrTryRestart(Mode mode) {
        return this.reloadOrTryRestart(mode.getValue());
    }

    public DBusPath reloadOrTryRestart(String mode) {
        return this.manager.reloadOrTryRestartUnit(this.name, mode);
    }

    public void resetFailed() {
        this.manager.resetFailedUnit(this.name);
    }

    public DBusPath restart(Mode mode) {
        return this.restart(mode.getValue());
    }

    public DBusPath restart(String mode) {
        return this.manager.restartUnit(this.name, mode);
    }

    public DBusPath start(Mode mode) {
        return this.start(mode.getValue());
    }

    public DBusPath start(String mode) {
        return this.manager.startUnit(this.name, mode);
    }

    public DBusPath stop(Mode mode) {
        return this.stop(mode.getValue());
    }

    public DBusPath stop(String mode) {
        return this.manager.stopUnit(this.name, mode);
    }

    public void thaw() {
        this.manager.thawUnit(this.name);
    }

    public DBusPath tryRestart(Mode mode) {
        return this.tryRestart(mode.getValue());
    }

    public DBusPath tryRestart(String mode) {
        return this.manager.tryRestartUnit(this.name, mode);
    }

    public void unref() {
        this.manager.unrefUnit(this.name);
    }

    public void setProperties(boolean runtime, Map<String, Object> properties) {
        throw new UnsupportedOperationException();
    }

    public long getActiveEnterTimestamp() {
        return this.unitProperties.getLong("ActiveEnterTimestamp");
    }

    public long getActiveEnterTimestampMonotonic() {
        return this.unitProperties.getLong("ActiveEnterTimestampMonotonic");
    }

    public long getActiveExitTimestamp() {
        return this.unitProperties.getLong("ActiveExitTimestamp");
    }

    public long getActiveExitTimestampMonotonic() {
        return this.unitProperties.getLong("ActiveExitTimestampMonotonic");
    }

    public String getActiveState() {
        return this.unitProperties.getString("ActiveState");
    }

    public List<String> getAfter() {
        return this.unitProperties.getList("After");
    }

    public boolean isAllowIsolate() {
        return this.unitProperties.getBoolean("AllowIsolate");
    }

    public boolean isAssertResult() {
        return this.unitProperties.getBoolean("AssertResult");
    }

    public long getAssertTimestamp() {
        return this.unitProperties.getLong("AssertTimestamp");
    }

    public long getAssertTimestampMonotonic() {
        return this.unitProperties.getLong("AssertTimestampMonotonic");
    }

    public List<Condition> getAsserts() {
        return Condition.list(this.unitProperties.getList("Asserts"));
    }

    public List<String> getBefore() {
        return this.unitProperties.getList("Before");
    }

    public List<String> getBindsTo() {
        return this.unitProperties.getList("BindsTo");
    }

    public List<String> getBoundBy() {
        return this.unitProperties.getList("BoundBy");
    }

    public List<String> isCanClean() {
        return this.unitProperties.getList("CanClean");
    }

    public boolean isCanFreeze() {
        return this.unitProperties.getBoolean("CanFreeze");
    }

    public boolean isCanIsolate() {
        return this.unitProperties.getBoolean("CanIsolate");
    }

    public boolean isCanReload() {
        return this.unitProperties.getBoolean("CanReload");
    }

    public boolean isCanStart() {
        return this.unitProperties.getBoolean("CanStart");
    }

    public boolean isCanStop() {
        return this.unitProperties.getBoolean("CanStop");
    }

    public String getCollectMode() {
        return this.unitProperties.getString("CollectMode");
    }

    public boolean getConditionResult() {
        return this.unitProperties.getBoolean("ConditionResult");
    }

    public long getConditionTimestamp() {
        return this.unitProperties.getLong("ConditionTimestamp");
    }

    public long getConditionTimestampMonotonic() {
        return this.unitProperties.getLong("ConditionTimestampMonotonic");
    }

    public List<Condition> getConditions() {
        return Condition.list(this.unitProperties.getList("Conditions"));
    }

    public List<String> getConflictedBy() {
        return this.unitProperties.getList("ConflictedBy");
    }

    public List<String> getConflicts() {
        return this.unitProperties.getList("Conflicts");
    }

    public List<String> getConsistsOf() {
        return this.unitProperties.getList("ConsistsOf");
    }

    public boolean isDefaultDependencies() {
        return this.unitProperties.getBoolean("DefaultDependencies");
    }

    public String getDescription() {
        return this.unitProperties.getString("Description");
    }

    public List<String> getDocumentation() {
        return this.unitProperties.getList("Documentation");
    }

    public List<String> getDropInPaths() {
        return this.unitProperties.getList("DropInPaths");
    }

    public String getFailureAction() {
        return this.unitProperties.getString("FailureAction");
    }

    public int getFailureActionExitStatus() {
        return this.unitProperties.getInteger("FailureActionExitStatus");
    }

    public String getFollowing() {
        return this.unitProperties.getString("Following");
    }

    public String getFragmentPath() {
        return this.unitProperties.getString("FragmentPath");
    }

    public String getFreezerState() {
        return this.unitProperties.getString("FreezerState");
    }

    public String getId() {
        return this.unitProperties.getString("Id");
    }

    public boolean isIgnoreOnIsolate() {
        return this.unitProperties.getBoolean("IgnoreOnIsolate");
    }

    public long getInactiveEnterTimestamp() {
        return this.unitProperties.getLong("InactiveEnterTimestamp");
    }

    public long getInactiveEnterTimestampMonotonic() {
        return this.unitProperties.getLong("InactiveEnterTimestampMonotonic");
    }

    public long getInactiveExitTimestamp() {
        return this.unitProperties.getLong("InactiveExitTimestamp");
    }

    public long getInactiveExitTimestampMonotonic() {
        return this.unitProperties.getLong("InactiveExitTimestampMonotonic");
    }

    public byte[] getInvocationID() {
        return (byte[])this.unitProperties.getVariant("InvocationID").getValue();
    }

    public Job getJob() {
        Object[] array = (Object[])this.unitProperties.getVariant("Job").getValue();
        return new Job(array);
    }

    public BigInteger getJobRunningTimeoutUSec() {
        return this.unitProperties.getBigInteger("JobRunningTimeoutUSec");
    }

    public String getJobTimeoutAction() {
        return this.unitProperties.getString("JobTimeoutAction");
    }

    public String getJobTimeoutRebootArgument() {
        return this.unitProperties.getString("JobTimeoutRebootArgument");
    }

    public BigInteger getJobTimeoutUSec() {
        return this.unitProperties.getBigInteger("JobTimeoutUSec");
    }

    public List<String> getJoinsNamespaceOf() {
        return this.unitProperties.getList("JoinsNamespaceOf");
    }

    public LoadError getLoadError() {
        Object[] array = (Object[])this.unitProperties.getVariant("LoadError").getValue();
        return new LoadError(array);
    }

    public String getLoadState() {
        return this.unitProperties.getString("LoadState");
    }

    public List<String> getNames() {
        return this.unitProperties.getList("Names");
    }

    public boolean isNeedDaemonReload() {
        return this.unitProperties.getBoolean("NeedDaemonReload");
    }

    public List<String> getOnFailure() {
        return this.unitProperties.getList("OnFailure");
    }

    public String getOnFailureJobMode() {
        return this.unitProperties.getString("OnFailureJobMode");
    }

    public List<String> getPartOf() {
        return this.unitProperties.getList("PartOf");
    }

    public boolean isPerpetual() {
        return this.unitProperties.getBoolean("Perpetual");
    }

    public List<String> getPropagatesReloadTo() {
        return this.unitProperties.getList("PropagatesReloadTo");
    }

    public String getRebootArgument() {
        return this.unitProperties.getString("RebootArgument");
    }

    public List<String> getRefs() {
        return this.unitProperties.getList("Refs");
    }

    public boolean isRefuseManualStart() {
        return this.unitProperties.getBoolean("RefuseManualStart");
    }

    public boolean isRefuseManualStop() {
        return this.unitProperties.getBoolean("RefuseManualStop");
    }

    public List<String> getReloadPropagatedFrom() {
        return this.unitProperties.getList("ReloadPropagatedFrom");
    }

    public List<String> getRequiredBy() {
        return this.unitProperties.getList("RequiredBy");
    }

    public List<String> getRequires() {
        return this.unitProperties.getList("Requires");
    }

    public List<String> getRequiresMountsFor() {
        return this.unitProperties.getList("RequiresMountsFor");
    }

    public List<String> getRequisite() {
        return this.unitProperties.getList("Requisite");
    }

    public List<String> getRequisiteOf() {
        return this.unitProperties.getList("RequisiteOf");
    }

    public String getSourcePath() {
        return this.unitProperties.getString("SourcePath");
    }

    public String getStartLimitAction() {
        return this.unitProperties.getString("StartLimitAction");
    }

    public long getStartLimitBurst() {
        return this.unitProperties.getLong("StartLimitBurst");
    }

    public long getStartLimitIntervalUSec() {
        return this.unitProperties.getLong("StartLimitIntervalUSec");
    }

    public long getStateChangeTimestamp() {
        return this.unitProperties.getLong("StateChangeTimestamp");
    }

    public long getStateChangeTimestampMonotonic() {
        return this.unitProperties.getLong("StateChangeTimestampMonotonic");
    }

    public boolean isStopWhenUnneeded() {
        return this.unitProperties.getBoolean("StopWhenUnneeded");
    }

    public String getSubState() {
        return this.unitProperties.getString("SubState");
    }

    public String getSuccessAction() {
        return this.unitProperties.getString("SuccessAction");
    }

    public int getSuccessActionExitStatus() {
        return this.unitProperties.getInteger("SuccessActionExitStatus");
    }

    public boolean isTransient() {
        return this.unitProperties.getBoolean("Transient");
    }

    public List<String> getTriggeredBy() {
        return this.unitProperties.getList("TriggeredBy");
    }

    public List<String> getTriggers() {
        return this.unitProperties.getList("Triggers");
    }

    public String getUnitFilePreset() {
        return this.unitProperties.getString("UnitFilePreset");
    }

    public String getUnitFileState() {
        return this.unitProperties.getString("UnitFileState");
    }

    public List<String> getWantedBy() {
        return this.unitProperties.getList("WantedBy");
    }

    public List<String> getWants() {
        return this.unitProperties.getList("Wants");
    }

    public String toString() {
        return this.name;
    }

    public static final class StateTuple {
        private final String loadState;
        private final String activeState;
        private final String subState;

        public StateTuple(String loadState, String activeState, String subState) {
            this.loadState = loadState;
            this.activeState = activeState;
            this.subState = subState;
        }

        public static StateTuple of(Unit unit) {
            return new StateTuple(unit.getLoadState(), unit.getActiveState(), unit.getSubState());
        }

        public static StateTuple of(Map<String, Variant<?>> properties) {
            String loadState = String.valueOf(properties.getOrDefault("LoadState", new Variant((Object)"-")).getValue());
            String activeState = String.valueOf(properties.getOrDefault("ActiveState", new Variant((Object)"-")).getValue());
            String subState = String.valueOf(properties.getOrDefault("SubState", new Variant((Object)"-")).getValue());
            return new StateTuple(loadState, activeState, subState);
        }

        public static StateTuple of(Unit unit, Map<String, Variant<?>> properties) {
            String loadState = String.valueOf(properties.getOrDefault("LoadState", new Variant((Object)unit.getLoadState())).getValue());
            String activeState = String.valueOf(properties.getOrDefault("ActiveState", new Variant((Object)unit.getActiveState())).getValue());
            String subState = String.valueOf(properties.getOrDefault("SubState", new Variant((Object)unit.getSubState())).getValue());
            return new StateTuple(loadState, activeState, subState);
        }

        public String getLoadState() {
            return this.loadState;
        }

        public String getActiveState() {
            return this.activeState;
        }

        public String getSubState() {
            return this.subState;
        }

        public String toString() {
            return String.format("%s - %s (%s)", this.loadState, this.activeState, this.subState);
        }
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String ACTIVE_ENTER_TIMESTAMP = "ActiveEnterTimestamp";
        public static final String ACTIVE_ENTER_TIMESTAMP_MONOTONIC = "ActiveEnterTimestampMonotonic";
        public static final String ACTIVE_EXIT_TIMESTAMP = "ActiveExitTimestamp";
        public static final String ACTIVE_EXIT_TIMESTAMP_MONOTONIC = "ActiveExitTimestampMonotonic";
        public static final String ACTIVE_STATE = "ActiveState";
        public static final String AFTER = "After";
        public static final String ALLOW_ISOLATE = "AllowIsolate";
        public static final String ASSERT_RESULT = "AssertResult";
        public static final String ASSERT_TIMESTAMP = "AssertTimestamp";
        public static final String ASSERT_TIMESTAMP_MONOTONIC = "AssertTimestampMonotonic";
        public static final String ASSERTS = "Asserts";
        public static final String BEFORE = "Before";
        public static final String BINDS_TO = "BindsTo";
        public static final String BOUND_BY = "BoundBy";
        public static final String CAN_CLEAN = "CanClean";
        public static final String CAN_FREEZE = "CanFreeze";
        public static final String CAN_ISOLATE = "CanIsolate";
        public static final String CAN_RELOAD = "CanReload";
        public static final String CAN_START = "CanStart";
        public static final String CAN_STOP = "CanStop";
        public static final String COLLECT_MODE = "CollectMode";
        public static final String CONDITION_RESULT = "ConditionResult";
        public static final String CONDITION_TIMESTAMP = "ConditionTimestamp";
        public static final String CONDITION_TIMESTAMP_MONOTONIC = "ConditionTimestampMonotonic";
        public static final String CONDITIONS = "Conditions";
        public static final String CONFLICTED_BY = "ConflictedBy";
        public static final String CONFLICTS = "Conflicts";
        public static final String CONSISTS_OF = "ConsistsOf";
        public static final String DEFAULT_DEPENDENCIES = "DefaultDependencies";
        public static final String DESCRIPTION = "Description";
        public static final String DOCUMENTATION = "Documentation";
        public static final String DROP_IN_PATHS = "DropInPaths";
        public static final String FAILURE_ACTION = "FailureAction";
        public static final String FAILURE_ACTION_EXIT_STATUS = "FailureActionExitStatus";
        public static final String FOLLOWING = "Following";
        public static final String FRAGMENT_PATH = "FragmentPath";
        public static final String FREEZER_STATE = "FreezerState";
        public static final String ID = "Id";
        public static final String IGNORE_ON_ISOLATE = "IgnoreOnIsolate";
        public static final String INACTIVE_ENTER_TIMESTAMP = "InactiveEnterTimestamp";
        public static final String INACTIVE_ENTER_TIMESTAMP_MONOTONIC = "InactiveEnterTimestampMonotonic";
        public static final String INACTIVE_EXIT_TIMESTAMP = "InactiveExitTimestamp";
        public static final String INACTIVE_EXIT_TIMESTAMP_MONOTONIC = "InactiveExitTimestampMonotonic";
        public static final String INVOCATION_ID = "InvocationID";
        public static final String JOB = "Job";
        public static final String JOB_RUNNING_TIMEOUT_USEC = "JobRunningTimeoutUSec";
        public static final String JOB_TIMEOUT_ACTION = "JobTimeoutAction";
        public static final String JOB_TIMEOUT_REBOOT_ARGUMENT = "JobTimeoutRebootArgument";
        public static final String JOB_TIMEOUT_USEC = "JobTimeoutUSec";
        public static final String JOINS_NAMESPACE_OF = "JoinsNamespaceOf";
        public static final String LOAD_ERROR = "LoadError";
        public static final String LOAD_STATE = "LoadState";
        public static final String NAMES = "Names";
        public static final String NEED_DAEMON_RELOAD = "NeedDaemonReload";
        public static final String ON_FAILURE = "OnFailure";
        public static final String ON_FAILURE_JOB_MODE = "OnFailureJobMode";
        public static final String PART_OF = "PartOf";
        public static final String PERPETUAL = "Perpetual";
        public static final String PROPAGATES_RELOAD_TO = "PropagatesReloadTo";
        public static final String REBOOT_ARGUMENT = "RebootArgument";
        public static final String REFS = "Refs";
        public static final String REFUSE_MANUAL_START = "RefuseManualStart";
        public static final String REFUSE_MANUAL_STOP = "RefuseManualStop";
        public static final String RELOAD_PROPAGATED_FROM = "ReloadPropagatedFrom";
        public static final String REQUIRED_BY = "RequiredBy";
        public static final String REQUIRES = "Requires";
        public static final String REQUIRES_MOUNTS_FOR = "RequiresMountsFor";
        public static final String REQUISITE = "Requisite";
        public static final String REQUISITE_OF = "RequisiteOf";
        public static final String SOURCE_PATH = "SourcePath";
        public static final String START_LIMIT_ACTION = "StartLimitAction";
        public static final String START_LIMIT_BURST = "StartLimitBurst";
        public static final String START_LIMIT_INTERVAL_USEC = "StartLimitIntervalUSec";
        public static final String STATE_CHANGE_TIMESTAMP = "StateChangeTimestamp";
        public static final String STATE_CHANGE_TIMESTAMP_MONOTONIC = "StateChangeTimestampMonotonic";
        public static final String STOP_WHEN_UNNEEDED = "StopWhenUnneeded";
        public static final String SUB_STATE = "SubState";
        public static final String SUCCESS_ACTION = "SuccessAction";
        public static final String SUCCESS_ACTION_EXIT_STATUS = "SuccessActionExitStatus";
        public static final String TRANSIENT = "Transient";
        public static final String TRIGGERED_BY = "TriggeredBy";
        public static final String TRIGGERS = "Triggers";
        public static final String UNIT_FILE_PRESET = "UnitFilePreset";
        public static final String UNIT_FILE_STATE = "UnitFileState";
        public static final String WANTED_BY = "WantedBy";
        public static final String WANTS = "Wants";

        private Property() {
        }

        public static List<String> getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }

    public static enum Mode {
        REPLACE("replace"),
        FAIL("fail"),
        ISOLATE("isolate"),
        IGNORE_DEPENDENCIES("ignore-dependencies"),
        IGNORE_REQUIREMENTS("ignore-requirements");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public final String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Who {
        MAIN("main"),
        CONTROL("control"),
        ALL("all");

        private final String value;

        private Who(String value) {
            this.value = value;
        }

        public final String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

