/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.AbstractAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.UnitMonitorListener;
import de.thjom.java.systemd.UnitStateNotifier;
import de.thjom.java.systemd.interfaces.ManagerInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.DBusSignal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class UnitMonitor
extends AbstractAdapter
implements UnitStateNotifier {
    protected static final String ERROR_MSG_MONITOR_REFRESH = "Error while refreshing internal monitor state";
    private static final String ACTIVE_STATE = "ActiveState";
    private static final String LOAD_STATE = "LoadState";
    private static final String SUB_STATE = "SubState";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Manager manager;
    protected final ConcurrentMap<String, Unit> monitoredUnits = new ConcurrentHashMap<String, Unit>();
    protected final List<UnitMonitorListener> unitMonitorListeners = new ArrayList<UnitMonitorListener>();
    protected ReloadingHandler reloadingHandler;
    protected UnitFilesChangedHandler unitFilesChangedHandler;
    private Timer pollingTimer;

    protected UnitMonitor(Manager manager) {
        this.manager = Objects.requireNonNull(manager);
    }

    @Override
    public <T extends DBusSignal> void addHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        this.manager.subscribe();
        this.manager.addHandler(type, handler);
    }

    @Override
    public <T extends DBusSignal> void removeHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        this.manager.removeHandler(type, handler);
    }

    public void addDefaultHandlers() throws DBusException {
        this.manager.subscribe();
        this.reloadingHandler = new ReloadingHandler();
        this.manager.addHandler(ManagerInterface.Reloading.class, this.reloadingHandler);
        this.unitFilesChangedHandler = new UnitFilesChangedHandler();
        this.manager.addHandler(ManagerInterface.UnitFilesChanged.class, this.unitFilesChangedHandler);
    }

    public void removeDefaultHandlers() throws DBusException {
        this.manager.removeHandler(ManagerInterface.Reloading.class, this.reloadingHandler);
        this.manager.removeHandler(ManagerInterface.UnitFilesChanged.class, this.unitFilesChangedHandler);
    }

    @Override
    protected DBusSigHandler<Properties.PropertiesChanged> createStateHandler() {
        return signal -> {
            Map properties;
            Optional<Unit> unit = this.findMonitoredUnit(Unit.extractName(signal.getPath()));
            if (unit.isPresent() && ((properties = signal.getPropertiesChanged()).containsKey(ACTIVE_STATE) || properties.containsKey(LOAD_STATE) || properties.containsKey(SUB_STATE))) {
                List list = this.unitStateListeners;
                synchronized (list) {
                    this.unitStateListeners.forEach(l -> l.stateChanged((Unit)unit.get(), properties));
                }
            }
        };
    }

    public synchronized void addListener(UnitMonitorListener listener) {
        this.unitMonitorListeners.add(listener);
    }

    public synchronized void removeListener(UnitMonitorListener listener) {
        this.unitMonitorListeners.remove(listener);
    }

    public abstract void reset();

    public abstract void refresh() throws DBusException;

    public synchronized void startPolling(long delay, long period) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    UnitMonitor.this.refresh();
                }
                catch (DBusException e) {
                    UnitMonitor.this.log.error(UnitMonitor.ERROR_MSG_MONITOR_REFRESH, (Throwable)e);
                }
            }
        };
        if (this.pollingTimer != null) {
            this.pollingTimer.cancel();
        }
        this.pollingTimer = this.createTimer();
        this.pollingTimer.schedule(task, delay, period);
    }

    public synchronized void stopPolling() {
        if (this.pollingTimer != null) {
            this.pollingTimer.cancel();
        }
    }

    protected Timer createTimer() {
        return new Timer(this.getClass().getSimpleName() + "-pollingTimer", true);
    }

    public boolean monitorsUnit(String unitName) {
        return this.monitoredUnits.containsKey(Systemd.escapePath(unitName));
    }

    public Optional<Unit> getMonitoredUnit(String unitName) {
        return this.findMonitoredUnit(Systemd.escapePath(unitName));
    }

    protected Optional<Unit> findMonitoredUnit(String escapedUnitName) {
        return Optional.ofNullable((Unit)this.monitoredUnits.get(escapedUnitName));
    }

    public Collection<Unit> getMonitoredUnits() {
        return this.monitoredUnits.values();
    }

    public class UnitFilesChangedHandler
    implements DBusSigHandler<ManagerInterface.UnitFilesChanged> {
        public void handle(ManagerInterface.UnitFilesChanged signal) {
            if (UnitMonitor.this.log.isDebugEnabled()) {
                UnitMonitor.this.log.debug(String.format("Signal received (unit files changed: %s)", new Object[]{signal}));
            }
            try {
                UnitMonitor.this.refresh();
            }
            catch (DBusException e) {
                UnitMonitor.this.log.error(UnitMonitor.ERROR_MSG_MONITOR_REFRESH, (Throwable)e);
            }
        }
    }

    public class ReloadingHandler
    implements DBusSigHandler<ManagerInterface.Reloading> {
        public void handle(ManagerInterface.Reloading signal) {
            if (signal.isActive()) {
                if (UnitMonitor.this.log.isDebugEnabled()) {
                    UnitMonitor.this.log.debug(String.format("Signal received ('daemon-reload' started: %s)", new Object[]{signal}));
                }
            } else {
                if (UnitMonitor.this.log.isDebugEnabled()) {
                    UnitMonitor.this.log.debug(String.format("Signal received ('daemon-reload' finished: %s)", new Object[]{signal}));
                }
                try {
                    UnitMonitor.this.refresh();
                }
                catch (DBusException e) {
                    UnitMonitor.this.log.error(UnitMonitor.ERROR_MSG_MONITOR_REFRESH, (Throwable)e);
                }
            }
        }
    }
}

