/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd.types;

import de.thjom.java.systemd.types.IOPath;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.freedesktop.dbus.types.UInt64;

public class IODeviceLatency
extends IOPath {
    private final BigInteger targetUsec;

    public IODeviceLatency(Object[] array) {
        super(array[0]);
        this.targetUsec = ((UInt64)array[1]).value();
    }

    public static List<IODeviceLatency> list(Collection<Object[]> arrays) {
        ArrayList<IODeviceLatency> targetUsecs = new ArrayList<IODeviceLatency>(arrays.size());
        for (Object[] array : arrays) {
            IODeviceLatency targetUsec = new IODeviceLatency(array);
            targetUsecs.add(targetUsec);
        }
        return targetUsecs;
    }

    public BigInteger getTargetUsec() {
        return this.targetUsec;
    }

    public String toString() {
        return String.format("IODeviceLatency [filePath=%s, targetUsec=%s]", this.filePath, this.targetUsec);
    }
}

