/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd.types;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.freedesktop.dbus.types.UInt32;

public class IpAddressPolicy {
    private final int family;
    private final byte[] address;
    private final long prefix;

    public IpAddressPolicy(Object[] array) {
        this.family = (Integer)array[0];
        List list = (List)array[1];
        byte[] bytes = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            bytes[i] = (Byte)list.get(i);
        }
        this.address = bytes;
        this.prefix = ((UInt32)array[2]).longValue();
    }

    public static List<IpAddressPolicy> list(List<Object[]> arrays) {
        ArrayList<IpAddressPolicy> policies = new ArrayList<IpAddressPolicy>(arrays.size());
        for (Object[] array : arrays) {
            IpAddressPolicy policy = new IpAddressPolicy(array);
            policies.add(policy);
        }
        return policies;
    }

    public int getFamily() {
        return this.family;
    }

    public byte[] getAddress() {
        return Arrays.copyOf(this.address, this.address.length);
    }

    public long getPrefix() {
        return this.prefix;
    }

    public String toConfigString() throws UnknownHostException {
        return String.format("%s/%d", InetAddress.getByAddress(this.address).getHostAddress(), this.prefix);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("IpAddressPolicy [family=");
        if (this.family == 2) {
            builder.append("IPv4");
        } else if (this.family == 10) {
            builder.append("IPv6");
        } else {
            builder.append("unknown");
        }
        builder.append('(').append(this.family).append(')');
        builder.append(", address=");
        try {
            builder.append(InetAddress.getByAddress(this.address).getHostAddress());
        }
        catch (UnknownHostException e) {
            builder.append("unknown");
        }
        builder.append("/").append(this.prefix).append("]");
        return builder.toString();
    }
}

