/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.BusNameInterface;
import java.math.BigInteger;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;

public class BusName
extends Unit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.BusName";
    public static final String UNIT_SUFFIX = ".busname";

    private BusName(Manager manager, BusNameInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static BusName create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        BusNameInterface iface = (BusNameInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, BusNameInterface.class);
        return new BusName(manager, iface, name);
    }

    @Override
    public BusNameInterface getInterface() {
        return (BusNameInterface)super.getInterface();
    }

    public boolean isAcceptFileDescriptors() {
        return this.properties.getBoolean("AcceptFileDescriptors");
    }

    public boolean isActivating() {
        return this.properties.getBoolean("Activating");
    }

    public long getControlPID() {
        return this.properties.getLong("ControlPID");
    }

    public String getName() {
        return this.properties.getString("Name");
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public BigInteger getTimeoutUSec() {
        return this.properties.getBigInteger("TimeoutUSec");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String ACCEPT_FILE_DESCRIPTORS = "AcceptFileDescriptors";
        public static final String ACTIVATING = "Activating";
        public static final String CONTROL_PID = "ControlPID";
        public static final String NAME = "Name";
        public static final String RESULT = "Result";
        public static final String TIMEOUT_USEC = "TimeoutUSec";

        private Property() {
        }

        public static List<String> getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

