/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.DeviceInterface;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;

public class Device
extends Unit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Device";
    public static final String UNIT_SUFFIX = ".device";

    private Device(Manager manager, DeviceInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Device create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        DeviceInterface iface = (DeviceInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, DeviceInterface.class);
        return new Device(manager, iface, name);
    }

    @Override
    public DeviceInterface getInterface() {
        return (DeviceInterface)super.getInterface();
    }

    public String getSysFSPath() {
        return this.properties.getString("SysFSPath");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String SYS_FS_PATH = "SysFSPath";

        private Property() {
        }

        public static List<String> getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

