/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.Automount;
import de.thjom.java.systemd.BusName;
import de.thjom.java.systemd.Device;
import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Mount;
import de.thjom.java.systemd.Path;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Scope;
import de.thjom.java.systemd.Service;
import de.thjom.java.systemd.Slice;
import de.thjom.java.systemd.Socket;
import de.thjom.java.systemd.Swap;
import de.thjom.java.systemd.Target;
import de.thjom.java.systemd.Timer;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.ManagerInterface;
import de.thjom.java.systemd.types.DynamicUser;
import de.thjom.java.systemd.types.UnitFileChange;
import de.thjom.java.systemd.types.UnitFileInstallChange;
import de.thjom.java.systemd.types.UnitFileType;
import de.thjom.java.systemd.types.UnitProcessType;
import de.thjom.java.systemd.types.UnitType;
import java.math.BigInteger;
import java.util.List;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.Introspectable;

public class Manager
extends InterfaceAdapter {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Manager";
    private boolean subscribed;

    private Manager(DBusConnection dbus, ManagerInterface iface) throws DBusException {
        super(dbus, iface);
        this.properties = Properties.create(dbus, "/org/freedesktop/systemd1", SERVICE_NAME);
    }

    static Manager create(DBusConnection dbus) throws DBusException {
        ManagerInterface iface = (ManagerInterface)dbus.getRemoteObject("org.freedesktop.systemd1", "/org/freedesktop/systemd1", ManagerInterface.class);
        return new Manager(dbus, iface);
    }

    @Override
    public ManagerInterface getInterface() {
        return (ManagerInterface)super.getInterface();
    }

    public String introspect() throws DBusException {
        Introspectable intro = (Introspectable)this.dbus.getRemoteObject("org.freedesktop.systemd1", "/org/freedesktop/systemd1", Introspectable.class);
        return intro.Introspect();
    }

    public List<UnitFileChange> addDependencyUnitFiles(List<String> names, String target, String type, boolean runtime, boolean force) {
        return this.getInterface().addDependencyUnitFiles(names, target, type, runtime, force);
    }

    public void cancelJob(long id) {
        this.getInterface().cancelJob(id);
    }

    public void cleanUnit(String name, List<String> mask) {
        this.getInterface().cleanUnit(name, mask);
    }

    public void clearJobs() {
        this.getInterface().clearJobs();
    }

    public List<UnitFileChange> disableUnitFiles(List<String> names, boolean runtime) {
        return this.getInterface().disableUnitFiles(names, runtime);
    }

    public String dump() {
        return this.getInterface().dump();
    }

    public List<UnitFileChange> enableUnitFiles(List<String> names, boolean runtime, boolean force) {
        return this.getInterface().enableUnitFiles(names, runtime, force);
    }

    public void exit() {
        this.getInterface().exit();
    }

    public void freezeUnit(String name) {
        this.getInterface().freezeUnit(name);
    }

    public String getDefaultTarget() {
        return this.getInterface().getDefaultTarget();
    }

    public List<DynamicUser> getDynamicUsers() {
        return this.getInterface().getDynamicUsers();
    }

    public DBusPath getUnitByPID(int pid) {
        return this.getInterface().getUnitByPID(pid);
    }

    public List<String> getUnitFileLinks(String name, boolean runtime) {
        return this.getInterface().getUnitFileLinks(name, runtime);
    }

    public String getUnitFileState(String name) {
        return this.getInterface().getUnitFileState(name);
    }

    public List<UnitProcessType> getUnitProcesses(String name) {
        return this.getInterface().getUnitProcesses(name);
    }

    public void halt() {
        this.getInterface().halt();
    }

    public void kExec() {
        this.getInterface().kExec();
    }

    public void killUnit(String name, Unit.Who who, int signal) {
        this.killUnit(name, who.getValue(), signal);
    }

    public void killUnit(String name, String who, int signal) {
        this.getInterface().killUnit(name, who, signal);
    }

    public List<UnitFileChange> linkUnitFiles(List<String> names, boolean runtime, boolean force) {
        return this.getInterface().linkUnitFiles(names, runtime, force);
    }

    public List<UnitFileType> listUnitFiles() {
        return this.getInterface().listUnitFiles();
    }

    public List<UnitType> listUnits() {
        return this.getInterface().listUnits();
    }

    public DBusPath loadUnit(String name) {
        return this.getInterface().loadUnit(name);
    }

    public long lookupDynamicUserByName(String name) {
        return this.getInterface().lookupDynamicUserByName(name);
    }

    public String lookupDynamicUserByUID(long uid) {
        return this.getInterface().lookupDynamicUserByUID(uid);
    }

    public List<UnitFileChange> maskUnitFiles(List<String> names, boolean runtime, boolean force) {
        return this.getInterface().maskUnitFiles(names, runtime, force);
    }

    public void powerOff() {
        this.getInterface().powerOff();
    }

    public List<UnitFileInstallChange> presetUnitFiles(List<String> names, boolean runtime, boolean force) {
        return this.getInterface().presetUnitFiles(names, runtime, force);
    }

    public List<UnitFileInstallChange> presetUnitFilesWithMode(List<String> names, String mode, boolean runtime, boolean force) {
        return this.getInterface().presetUnitFilesWithMode(names, mode, runtime, force);
    }

    public void reboot() {
        this.getInterface().reboot();
    }

    public List<UnitFileInstallChange> reenableUnitFiles(List<String> names, boolean runtime, boolean force) {
        return this.getInterface().reenableUnitFiles(names, runtime, force);
    }

    public void reexecute() {
        this.getInterface().reexecute();
    }

    public void refUnit(String name) {
        this.getInterface().refUnit(name);
    }

    public void reload() {
        this.getInterface().reload();
    }

    public DBusPath reloadOrRestartUnit(String name, Unit.Mode mode) {
        return this.reloadOrRestartUnit(name, mode.getValue());
    }

    public DBusPath reloadOrRestartUnit(String name, String mode) {
        return this.getInterface().reloadOrRestartUnit(name, mode);
    }

    public DBusPath reloadOrTryRestartUnit(String name, Unit.Mode mode) {
        return this.reloadOrTryRestartUnit(name, mode.getValue());
    }

    public DBusPath reloadOrTryRestartUnit(String name, String mode) {
        return this.getInterface().reloadOrTryRestartUnit(name, mode);
    }

    public DBusPath reloadUnit(String name, Unit.Mode mode) {
        return this.reloadUnit(name, mode.getValue());
    }

    public DBusPath reloadUnit(String name, String mode) {
        return this.getInterface().reloadUnit(name, mode);
    }

    public void resetFailed() {
        this.getInterface().resetFailed();
    }

    public void resetFailedUnit(String name) {
        this.getInterface().resetFailedUnit(name);
    }

    public DBusPath restartUnit(String name, Unit.Mode mode) {
        return this.restartUnit(name, mode.getValue());
    }

    public DBusPath restartUnit(String name, String mode) {
        return this.getInterface().restartUnit(name, mode);
    }

    public List<UnitFileChange> revertUnitFiles(List<String> names) {
        return this.getInterface().revertUnitFiles(names);
    }

    public List<UnitFileChange> setDefaultTarget(String name, boolean force) {
        return this.getInterface().setDefaultTarget(name, force);
    }

    public void setEnvironment(String name) {
        this.getInterface().setEnvironment(name);
    }

    public void setExitCode(byte value) {
        this.getInterface().setExitCode(value);
    }

    public DBusPath startUnit(String name, Unit.Mode mode) {
        return this.startUnit(name, mode.getValue());
    }

    public DBusPath startUnit(String name, String mode) {
        return this.getInterface().startUnit(name, mode);
    }

    public DBusPath stopUnit(String name, Unit.Mode mode) {
        return this.stopUnit(name, mode.getValue());
    }

    public DBusPath stopUnit(String name, String mode) {
        return this.getInterface().stopUnit(name, mode);
    }

    public synchronized void subscribe() {
        if (!this.subscribed) {
            this.getInterface().subscribe();
            this.subscribed = true;
        }
    }

    public void switchRoot(String newRoot, String init) {
        this.getInterface().switchRoot(newRoot, init);
    }

    public void thawUnit(String name) {
        this.getInterface().thawUnit(name);
    }

    public DBusPath tryRestartUnit(String name, Unit.Mode mode) {
        return this.tryRestartUnit(name, mode.getValue());
    }

    public DBusPath tryRestartUnit(String name, String mode) {
        return this.getInterface().tryRestartUnit(name, mode);
    }

    public List<UnitFileChange> unmaskUnitFiles(List<String> names, boolean runtime) {
        return this.getInterface().unmaskUnitFiles(names, runtime);
    }

    public void unrefUnit(String name) {
        this.getInterface().unrefUnit(name);
    }

    public void unsetAndSetEnvironment(List<String> namesToUnset, List<String> namesToSet) {
        this.getInterface().unsetAndSetEnvironment(namesToUnset, namesToSet);
    }

    public void unsetEnvironment(List<String> names) {
        this.getInterface().unsetEnvironment(names);
    }

    public synchronized void unsubscribe() {
        if (this.subscribed) {
            this.getInterface().unsubscribe();
            this.subscribed = false;
        }
    }

    public Automount getAutomount(String name) throws DBusException {
        return Automount.create(this, name);
    }

    public BusName getBusName(String name) throws DBusException {
        return BusName.create(this, name);
    }

    public Device getDevice(String name) throws DBusException {
        return Device.create(this, name);
    }

    public Mount getMount(String name) throws DBusException {
        return Mount.create(this, name);
    }

    public Path getPath(String name) throws DBusException {
        return Path.create(this, name);
    }

    public Scope getScope(String name) throws DBusException {
        return Scope.create(this, name);
    }

    public Service getService(String name) throws DBusException {
        return Service.create(this, name);
    }

    public Slice getSlice(String name) throws DBusException {
        return Slice.create(this, name);
    }

    public Socket getSocket(String name) throws DBusException {
        return Socket.create(this, name);
    }

    public Swap getSwap(String name) throws DBusException {
        return Swap.create(this, name);
    }

    public Target getTarget(String name) throws DBusException {
        return Target.create(this, name);
    }

    public Timer getTimer(String name) throws DBusException {
        return Timer.create(this, name);
    }

    public Unit getUnit(String fullName) throws DBusException {
        Unit unit;
        String suffix;
        switch (suffix = fullName.substring(fullName.lastIndexOf(46))) {
            case ".automount": {
                unit = this.getAutomount(fullName);
                break;
            }
            case ".busname": {
                unit = this.getBusName(fullName);
                break;
            }
            case ".device": {
                unit = this.getDevice(fullName);
                break;
            }
            case ".mount": {
                unit = this.getMount(fullName);
                break;
            }
            case ".path": {
                unit = this.getPath(fullName);
                break;
            }
            case ".scope": {
                unit = this.getScope(fullName);
                break;
            }
            case ".service": {
                unit = this.getService(fullName);
                break;
            }
            case ".slice": {
                unit = this.getSlice(fullName);
                break;
            }
            case ".socket": {
                unit = this.getSocket(fullName);
                break;
            }
            case ".swap": {
                unit = this.getSwap(fullName);
                break;
            }
            case ".target": {
                unit = this.getTarget(fullName);
                break;
            }
            case ".timer": {
                unit = this.getTimer(fullName);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unable to determine unit type by name suffix from '%s'", fullName));
            }
        }
        return unit;
    }

    public String getArchitecture() {
        return this.properties.getString("Architecture");
    }

    public boolean isConfirmSpawn() {
        return this.properties.getBoolean("ConfirmSpawn");
    }

    public String getControlGroup() {
        return this.properties.getString("ControlGroup");
    }

    public boolean isDefaultBlockIOAccounting() {
        return this.properties.getBoolean("DefaultBlockIOAccounting");
    }

    public boolean isDefaultCPUAccounting() {
        return this.properties.getBoolean("DefaultCPUAccounting");
    }

    public BigInteger getDefaultLimitAS() {
        return this.properties.getBigInteger("DefaultLimitAS");
    }

    public BigInteger getDefaultLimitASSoft() {
        return this.properties.getBigInteger("DefaultLimitASSoft");
    }

    public BigInteger getDefaultLimitCORE() {
        return this.properties.getBigInteger("DefaultLimitCORE");
    }

    public BigInteger getDefaultLimitCORESoft() {
        return this.properties.getBigInteger("DefaultLimitCORESoft");
    }

    public BigInteger getDefaultLimitCPU() {
        return this.properties.getBigInteger("DefaultLimitCPU");
    }

    public BigInteger getDefaultLimitCPUSoft() {
        return this.properties.getBigInteger("DefaultLimitCPUSoft");
    }

    public BigInteger getDefaultLimitDATA() {
        return this.properties.getBigInteger("DefaultLimitDATA");
    }

    public BigInteger getDefaultLimitDATASoft() {
        return this.properties.getBigInteger("DefaultLimitDATASoft");
    }

    public BigInteger getDefaultLimitFSIZE() {
        return this.properties.getBigInteger("DefaultLimitFSIZE");
    }

    public BigInteger getDefaultLimitFSIZESoft() {
        return this.properties.getBigInteger("DefaultLimitFSIZESoft");
    }

    public BigInteger getDefaultLimitLOCKS() {
        return this.properties.getBigInteger("DefaultLimitLOCKS");
    }

    public BigInteger getDefaultLimitLOCKSSoft() {
        return this.properties.getBigInteger("DefaultLimitLOCKSSoft");
    }

    public BigInteger getDefaultLimitMEMLOCK() {
        return this.properties.getBigInteger("DefaultLimitMEMLOCK");
    }

    public BigInteger getDefaultLimitMEMLOCKSoft() {
        return this.properties.getBigInteger("DefaultLimitMEMLOCKSoft");
    }

    public BigInteger getDefaultLimitMSGQUEUE() {
        return this.properties.getBigInteger("DefaultLimitMSGQUEUE");
    }

    public BigInteger getDefaultLimitMSGQUEUESoft() {
        return this.properties.getBigInteger("DefaultLimitMSGQUEUESoft");
    }

    public BigInteger getDefaultLimitNICE() {
        return this.properties.getBigInteger("DefaultLimitNICE");
    }

    public BigInteger getDefaultLimitNICESoft() {
        return this.properties.getBigInteger("DefaultLimitNICESoft");
    }

    public BigInteger getDefaultLimitNOFILE() {
        return this.properties.getBigInteger("DefaultLimitNOFILE");
    }

    public BigInteger getDefaultLimitNOFILESoft() {
        return this.properties.getBigInteger("DefaultLimitNOFILESoft");
    }

    public BigInteger getDefaultLimitNPROC() {
        return this.properties.getBigInteger("DefaultLimitNPROC");
    }

    public BigInteger getDefaultLimitNPROCSoft() {
        return this.properties.getBigInteger("DefaultLimitNPROCSoft");
    }

    public BigInteger getDefaultLimitRSS() {
        return this.properties.getBigInteger("DefaultLimitRSS");
    }

    public BigInteger getDefaultLimitRSSSoft() {
        return this.properties.getBigInteger("DefaultLimitRSSSoft");
    }

    public BigInteger getDefaultLimitRTPRIO() {
        return this.properties.getBigInteger("DefaultLimitRTPRIO");
    }

    public BigInteger getDefaultLimitRTPRIOSoft() {
        return this.properties.getBigInteger("DefaultLimitRTPRIOSoft");
    }

    public BigInteger getDefaultLimitRTTIME() {
        return this.properties.getBigInteger("DefaultLimitRTTIME");
    }

    public BigInteger getDefaultLimitRTTIMESoft() {
        return this.properties.getBigInteger("DefaultLimitRTTIMESoft");
    }

    public BigInteger getDefaultLimitSIGPENDING() {
        return this.properties.getBigInteger("DefaultLimitSIGPENDING");
    }

    public BigInteger getDefaultLimitSIGPENDINGSoft() {
        return this.properties.getBigInteger("DefaultLimitSIGPENDINGSoft");
    }

    public BigInteger getDefaultLimitSTACK() {
        return this.properties.getBigInteger("DefaultLimitSTACK");
    }

    public BigInteger getDefaultLimitSTACKSoft() {
        return this.properties.getBigInteger("DefaultLimitSTACKSoft");
    }

    public boolean isDefaultMemoryAccounting() {
        return this.properties.getBoolean("DefaultMemoryAccounting");
    }

    public String getDefaultOOMPolicy() {
        return this.properties.getString("DefaultOOMPolicy");
    }

    public BigInteger getDefaultRestartUSec() {
        return this.properties.getBigInteger("DefaultRestartUSec");
    }

    public String getDefaultStandardError() {
        return this.properties.getString("DefaultStandardError");
    }

    public String getDefaultStandardOutput() {
        return this.properties.getString("DefaultStandardOutput");
    }

    public long getDefaultStartLimitBurst() {
        return this.properties.getLong("DefaultStartLimitBurst");
    }

    public long getDefaultStartLimitIntervalUSec() {
        return this.properties.getLong("DefaultStartLimitIntervalUSec");
    }

    public boolean isDefaultTasksAccounting() {
        return this.properties.getBoolean("DefaultTasksAccounting");
    }

    public BigInteger getDefaultTasksMax() {
        return this.properties.getBigInteger("DefaultTasksMax");
    }

    public BigInteger getDefaultTimeoutAbortUSec() {
        return this.properties.getBigInteger("DefaultTimeoutAbortUSec");
    }

    public BigInteger getDefaultTimeoutStartUSec() {
        return this.properties.getBigInteger("DefaultTimeoutStartUSec");
    }

    public BigInteger getDefaultTimeoutStopUSec() {
        return this.properties.getBigInteger("DefaultTimeoutStopUSec");
    }

    public BigInteger getDefaultTimerAccuracyUSec() {
        return this.properties.getBigInteger("DefaultTimerAccuracyUSec");
    }

    public List<String> getEnvironment() {
        return this.properties.getList("Environment");
    }

    public byte getExitCode() {
        return this.properties.getByte("ExitCode");
    }

    public String getFeatures() {
        return this.properties.getString("Features");
    }

    public long getFinishTimestamp() {
        return this.properties.getLong("FinishTimestamp");
    }

    public long getFinishTimestampMonotonic() {
        return this.properties.getLong("FinishTimestampMonotonic");
    }

    public long getFirmwareTimestamp() {
        return this.properties.getLong("FirmwareTimestamp");
    }

    public long getFirmwareTimestampMonotonic() {
        return this.properties.getLong("FirmwareTimestampMonotonic");
    }

    public long getGeneratorsFinishTimestamp() {
        return this.properties.getLong("GeneratorsFinishTimestamp");
    }

    public long getGeneratorsFinishTimestampMonotonic() {
        return this.properties.getLong("GeneratorsFinishTimestampMonotonic");
    }

    public long getGeneratorsStartTimestamp() {
        return this.properties.getLong("GeneratorsStartTimestamp");
    }

    public long getGeneratorsStartTimestampMonotonic() {
        return this.properties.getLong("GeneratorsStartTimestampMonotonic");
    }

    public long getInitRDGeneratorsFinishTimestamp() {
        return this.properties.getLong("InitRDGeneratorsFinishTimestamp");
    }

    public long getInitRDGeneratorsFinishTimestampMonotonic() {
        return this.properties.getLong("InitRDGeneratorsFinishTimestampMonotonic");
    }

    public long getInitRDGeneratorsStartTimestamp() {
        return this.properties.getLong("InitRDGeneratorsStartTimestamp");
    }

    public long getInitRDGeneratorsStartTimestampMonotonic() {
        return this.properties.getLong("InitRDGeneratorsStartTimestampMonotonic");
    }

    public long getInitRDSecurityFinishTimestamp() {
        return this.properties.getLong("InitRDSecurityFinishTimestamp");
    }

    public long getInitRDSecurityFinishTimestampMonotonic() {
        return this.properties.getLong("InitRDSecurityFinishTimestampMonotonic");
    }

    public long getInitRDSecurityStartTimestamp() {
        return this.properties.getLong("InitRDSecurityStartTimestamp");
    }

    public long getInitRDSecurityStartTimestampMonotonic() {
        return this.properties.getLong("InitRDSecurityStartTimestampMonotonic");
    }

    public long getInitRDTimestamp() {
        return this.properties.getLong("InitRDTimestamp");
    }

    public long getInitRDTimestampMonotonic() {
        return this.properties.getLong("InitRDTimestampMonotonic");
    }

    public long getInitRDUnitsLoadFinishTimestamp() {
        return this.properties.getLong("InitRDUnitsLoadFinishTimestamp");
    }

    public long getInitRDUnitsLoadFinishTimestampMonotonic() {
        return this.properties.getLong("InitRDUnitsLoadFinishTimestampMonotonic");
    }

    public long getInitRDUnitsLoadStartTimestamp() {
        return this.properties.getLong("InitRDUnitsLoadStartTimestamp");
    }

    public long getInitRDUnitsLoadStartTimestampMonotonic() {
        return this.properties.getLong("InitRDUnitsLoadStartTimestampMonotonic");
    }

    public long getKernelTimestamp() {
        return this.properties.getLong("KernelTimestamp");
    }

    public long getKernelTimestampMonotonic() {
        return this.properties.getLong("KernelTimestampMonotonic");
    }

    public BigInteger getKExecWatchdogUSec() {
        return this.properties.getBigInteger("KExecWatchdogUSec");
    }

    public long getLoaderTimestamp() {
        return this.properties.getLong("LoaderTimestamp");
    }

    public long getLoaderTimestampMonotonic() {
        return this.properties.getLong("LoaderTimestampMonotonic");
    }

    public String getLogLevel() {
        return this.properties.getString("LogLevel");
    }

    public String getLogTarget() {
        return this.properties.getString("LogTarget");
    }

    public long getNFailedJobs() {
        return this.properties.getLong("NFailedJobs");
    }

    public long getNFailedUnits() {
        return this.properties.getLong("NFailedUnits");
    }

    public long getNInstalledJobs() {
        return this.properties.getLong("NInstalledJobs");
    }

    public long getNJobs() {
        return this.properties.getLong("NJobs");
    }

    public long getNNames() {
        return this.properties.getLong("NNames");
    }

    public double getProgress() {
        return this.properties.getDouble("Progress");
    }

    public BigInteger getRebootWatchdogUSec() {
        return this.properties.getBigInteger("RebootWatchdogUSec");
    }

    public BigInteger getRuntimeWatchdogUSec() {
        return this.properties.getBigInteger("RuntimeWatchdogUSec");
    }

    public long getSecurityFinishTimestamp() {
        return this.properties.getLong("SecurityFinishTimestamp");
    }

    public long getSecurityFinishTimestampMonotonic() {
        return this.properties.getLong("SecurityFinishTimestampMonotonic");
    }

    public long getSecurityStartTimestamp() {
        return this.properties.getLong("SecurityStartTimestamp");
    }

    public long getSecurityStartTimestampMonotonic() {
        return this.properties.getLong("SecurityStartTimestampMonotonic");
    }

    public boolean isServiceWatchdogs() {
        return this.properties.getBoolean("ServiceWatchdogs");
    }

    public boolean isShowStatus() {
        return this.properties.getBoolean("ShowStatus");
    }

    public String getSystemState() {
        return this.properties.getString("SystemState");
    }

    public String getTainted() {
        return this.properties.getString("Tainted");
    }

    public BigInteger getTimerSlackNSec() {
        return this.properties.getBigInteger("TimerSlackNSec");
    }

    public List<String> getUnitPath() {
        return this.properties.getList("UnitPath");
    }

    public long getUnitsLoadFinishTimestamp() {
        return this.properties.getLong("UnitsLoadFinishTimestamp");
    }

    public long getUnitsLoadFinishTimestampMonotonic() {
        return this.properties.getLong("UnitsLoadFinishTimestampMonotonic");
    }

    public long getUnitsLoadStartTimestamp() {
        return this.properties.getLong("UnitsLoadStartTimestamp");
    }

    public long getUnitsLoadStartTimestampMonotonic() {
        return this.properties.getLong("UnitsLoadStartTimestampMonotonic");
    }

    public long getUserspaceTimestamp() {
        return this.properties.getLong("UserspaceTimestamp");
    }

    public long getUserspaceTimestampMonotonic() {
        return this.properties.getLong("UserspaceTimestampMonotonic");
    }

    public String getVersion() {
        return this.properties.getString("Version");
    }

    public String getVirtualization() {
        return this.properties.getString("Virtualization");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String ARCHITECTURE = "Architecture";
        public static final String CONFIRM_SPAWN = "ConfirmSpawn";
        public static final String CONTROL_GROUP = "ControlGroup";
        public static final String DEFAULT_BLOCK_IO_ACCOUNTING = "DefaultBlockIOAccounting";
        public static final String DEFAULT_CPU_ACCOUNTING = "DefaultCPUAccounting";
        public static final String DEFAULT_LIMIT_AS = "DefaultLimitAS";
        public static final String DEFAULT_LIMIT_AS_SOFT = "DefaultLimitASSoft";
        public static final String DEFAULT_LIMIT_CORE = "DefaultLimitCORE";
        public static final String DEFAULT_LIMIT_CORE_SOFT = "DefaultLimitCORESoft";
        public static final String DEFAULT_LIMIT_CPU = "DefaultLimitCPU";
        public static final String DEFAULT_LIMIT_CPU_SOFT = "DefaultLimitCPUSoft";
        public static final String DEFAULT_LIMIT_DATA = "DefaultLimitDATA";
        public static final String DEFAULT_LIMIT_DATA_SOFT = "DefaultLimitDATASoft";
        public static final String DEFAULT_LIMIT_FSIZE = "DefaultLimitFSIZE";
        public static final String DEFAULT_LIMIT_FSIZE_SOFT = "DefaultLimitFSIZESoft";
        public static final String DEFAULT_LIMIT_LOCKS = "DefaultLimitLOCKS";
        public static final String DEFAULT_LIMIT_LOCKS_SOFT = "DefaultLimitLOCKSSoft";
        public static final String DEFAULT_LIMIT_MEMLOCK = "DefaultLimitMEMLOCK";
        public static final String DEFAULT_LIMIT_MEMLOCK_SOFT = "DefaultLimitMEMLOCKSoft";
        public static final String DEFAULT_LIMIT_MSGQUEUE = "DefaultLimitMSGQUEUE";
        public static final String DEFAULT_LIMIT_MSGQUEUE_SOFT = "DefaultLimitMSGQUEUESoft";
        public static final String DEFAULT_LIMIT_NICE = "DefaultLimitNICE";
        public static final String DEFAULT_LIMIT_NICE_SOFT = "DefaultLimitNICESoft";
        public static final String DEFAULT_LIMIT_NOFILE = "DefaultLimitNOFILE";
        public static final String DEFAULT_LIMIT_NOFILE_SOFT = "DefaultLimitNOFILESoft";
        public static final String DEFAULT_LIMIT_NPROC = "DefaultLimitNPROC";
        public static final String DEFAULT_LIMIT_NPROC_SOFT = "DefaultLimitNPROCSoft";
        public static final String DEFAULT_LIMIT_RSS = "DefaultLimitRSS";
        public static final String DEFAULT_LIMIT_RSS_SOFT = "DefaultLimitRSSSoft";
        public static final String DEFAULT_LIMIT_RTPRIO = "DefaultLimitRTPRIO";
        public static final String DEFAULT_LIMIT_RTPRIO_SOFT = "DefaultLimitRTPRIOSoft";
        public static final String DEFAULT_LIMIT_RTTIME = "DefaultLimitRTTIME";
        public static final String DEFAULT_LIMIT_RTTIME_SOFT = "DefaultLimitRTTIMESoft";
        public static final String DEFAULT_LIMIT_SIGPENDING = "DefaultLimitSIGPENDING";
        public static final String DEFAULT_LIMIT_SIGPENDING_SOFT = "DefaultLimitSIGPENDINGSoft";
        public static final String DEFAULT_LIMIT_STACK = "DefaultLimitSTACK";
        public static final String DEFAULT_LIMIT_STACK_SOFT = "DefaultLimitSTACKSoft";
        public static final String DEFAULT_MEMORY_ACCOUNTING = "DefaultMemoryAccounting";
        public static final String DEFAULT_OOM_POLICY = "DefaultOOMPolicy";
        public static final String DEFAULT_RESTART_USEC = "DefaultRestartUSec";
        public static final String DEFAULT_STANDARD_ERROR = "DefaultStandardError";
        public static final String DEFAULT_STANDARD_OUTPUT = "DefaultStandardOutput";
        public static final String DEFAULT_START_LIMIT_BURST = "DefaultStartLimitBurst";
        public static final String DEFAULT_START_LIMIT_INTERVAL_USEC = "DefaultStartLimitIntervalUSec";
        public static final String DEFAULT_TASKS_ACCOUNTING = "DefaultTasksAccounting";
        public static final String DEFAULT_TASKS_MAX = "DefaultTasksMax";
        public static final String DEFAULT_TIMEOUT_ABORT_USEC = "DefaultTimeoutAbortUSec";
        public static final String DEFAULT_TIMEOUT_START_USEC = "DefaultTimeoutStartUSec";
        public static final String DEFAULT_TIMEOUT_STOP_USEC = "DefaultTimeoutStopUSec";
        public static final String DEFAULT_TIMER_ACCURACY_USEC = "DefaultTimerAccuracyUSec";
        public static final String ENVIRONMENT = "Environment";
        public static final String EXIT_CODE = "ExitCode";
        public static final String FEATURES = "Features";
        public static final String FINISH_TIMESTAMP = "FinishTimestamp";
        public static final String FINISH_TIMESTAMP_MONOTONIC = "FinishTimestampMonotonic";
        public static final String FIRMWARE_TIMESTAMP = "FirmwareTimestamp";
        public static final String FIRMWARE_TIMESTAMP_MONOTONIC = "FirmwareTimestampMonotonic";
        public static final String GENERATORS_FINISH_TIMESTAMP = "GeneratorsFinishTimestamp";
        public static final String GENERATORS_FINISH_TIMESTAMP_MONOTONIC = "GeneratorsFinishTimestampMonotonic";
        public static final String GENERATORS_START_TIMESTAMP = "GeneratorsStartTimestamp";
        public static final String GENERATORS_START_TIMESTAMP_MONOTONIC = "GeneratorsStartTimestampMonotonic";
        public static final String INIT_RD_GENERATORS_FINISH_TIMESTAMP = "InitRDGeneratorsFinishTimestamp";
        public static final String INIT_RD_GENERATORS_FINISH_TIMESTAMP_MONOTONIC = "InitRDGeneratorsFinishTimestampMonotonic";
        public static final String INIT_RD_GENERATORS_START_TIMESTAMP = "InitRDGeneratorsStartTimestamp";
        public static final String INIT_RD_GENERATORS_START_TIMESTAMP_MONOTONIC = "InitRDGeneratorsStartTimestampMonotonic";
        public static final String INIT_RD_SECURITY_FINISH_TIMESTAMP = "InitRDSecurityFinishTimestamp";
        public static final String INIT_RD_SECURITY_FINISH_TIMESTAMP_MONOTONIC = "InitRDSecurityFinishTimestampMonotonic";
        public static final String INIT_RD_SECURITY_START_TIMESTAMP = "InitRDSecurityStartTimestamp";
        public static final String INIT_RD_SECURITY_START_TIMESTAMP_MONOTONIC = "InitRDSecurityStartTimestampMonotonic";
        public static final String INIT_RD_TIMESTAMP = "InitRDTimestamp";
        public static final String INIT_RD_TIMESTAMP_MONOTONIC = "InitRDTimestampMonotonic";
        public static final String INIT_RD_UNITS_LOAD_FINISH_TIMESTAMP = "InitRDUnitsLoadFinishTimestamp";
        public static final String INIT_RD_UNITS_LOAD_FINISH_TIMESTAMP_MONOTONIC = "InitRDUnitsLoadFinishTimestampMonotonic";
        public static final String INIT_RD_UNITS_LOAD_START_TIMESTAMP = "InitRDUnitsLoadStartTimestamp";
        public static final String INIT_RD_UNITS_LOAD_START_TIMESTAMP_MONOTONIC = "InitRDUnitsLoadStartTimestampMonotonic";
        public static final String KERNEL_TIMESTAMP = "KernelTimestamp";
        public static final String KERNEL_TIMESTAMP_MONOTONIC = "KernelTimestampMonotonic";
        public static final String KEXEC_WATCHDOG_USEC = "KExecWatchdogUSec";
        public static final String LOADER_TIMESTAMP = "LoaderTimestamp";
        public static final String LOADER_TIMESTAMP_MONOTONIC = "LoaderTimestampMonotonic";
        public static final String LOG_LEVEL = "LogLevel";
        public static final String LOG_TARGET = "LogTarget";
        public static final String NFAILED_JOBS = "NFailedJobs";
        public static final String NFAILED_UNITS = "NFailedUnits";
        public static final String NINSTALLED_JOBS = "NInstalledJobs";
        public static final String NJOBS = "NJobs";
        public static final String NNAMES = "NNames";
        public static final String PROGRESS = "Progress";
        public static final String REBOOT_WATCHDOG_USEC = "RebootWatchdogUSec";
        public static final String RUNTIME_WATCHDOG_USEC = "RuntimeWatchdogUSec";
        public static final String SECURITY_FINISH_TIMESTAMP = "SecurityFinishTimestamp";
        public static final String SECURITY_FINISH_TIMESTAMP_MONOTONIC = "SecurityFinishTimestampMonotonic";
        public static final String SECURITY_START_TIMESTAMP = "SecurityStartTimestamp";
        public static final String SECURITY_START_TIMESTAMP_MONOTONIC = "SecurityStartTimestampMonotonic";
        public static final String SERVICE_WATCHDOGS = "ServiceWatchdogs";
        public static final String SHOW_STATUS = "ShowStatus";
        public static final String SYSTEM_STATE = "SystemState";
        public static final String TAINTED = "Tainted";
        public static final String TIMER_SLACK_NSEC = "TimerSlackNSec";
        public static final String UNIT_PATH = "UnitPath";
        public static final String UNITS_LOAD_FINISH_TIMESTAMP = "UnitsLoadFinishTimestamp";
        public static final String UNITS_LOAD_FINISH_TIMESTAMP_MONOTONIC = "UnitsLoadFinishTimestampMonotonic";
        public static final String UNITS_LOAD_START_TIMESTAMP = "UnitsLoadStartTimestamp";
        public static final String UNITS_LOAD_START_TIMESTAMP_MONOTONIC = "UnitsLoadStartTimestampMonotonic";
        public static final String USERSPACE_TIMESTAMP = "UserspaceTimestamp";
        public static final String USERSPACE_TIMESTAMP_MONOTONIC = "UserspaceTimestampMonotonic";
        public static final String VERSION = "Version";
        public static final String VIRTUALIZATION = "Virtualization";

        private Property() {
        }

        public static List<String> getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

