/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.features.CpuAccounting;
import de.thjom.java.systemd.features.IoAccounting;
import de.thjom.java.systemd.features.IpAccounting;
import de.thjom.java.systemd.features.MemoryAccounting;
import de.thjom.java.systemd.features.ResourceControl;
import de.thjom.java.systemd.features.TasksAccounting;
import de.thjom.java.systemd.interfaces.ScopeInterface;
import de.thjom.java.systemd.types.DeviceAllowControl;
import de.thjom.java.systemd.types.UnitProcessType;
import java.math.BigInteger;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;

public class Scope
extends Unit
implements CpuAccounting,
IoAccounting,
IpAccounting,
MemoryAccounting,
ResourceControl,
TasksAccounting {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Scope";
    public static final String UNIT_SUFFIX = ".scope";

    private Scope(Manager manager, ScopeInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Scope create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        ScopeInterface iface = (ScopeInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, ScopeInterface.class);
        return new Scope(manager, iface, name);
    }

    @Override
    public ScopeInterface getInterface() {
        return (ScopeInterface)super.getInterface();
    }

    public void abandon() {
        this.getInterface().abandon();
    }

    public void attachProcesses(String cgroupPath, long[] pids) {
        this.getInterface().attachProcesses(cgroupPath, pids);
    }

    public List<UnitProcessType> getProcesses() {
        return this.getInterface().getProcesses();
    }

    public String getControlGroup() {
        return this.properties.getString("ControlGroup");
    }

    public String getController() {
        return this.properties.getString("Controller");
    }

    public List<DeviceAllowControl> getDeviceAllow() {
        return DeviceAllowControl.list(this.properties.getList("DeviceAllow"));
    }

    public String getDevicePolicy() {
        return this.properties.getString("DevicePolicy");
    }

    public int getFinalKillSignal() {
        return this.properties.getInteger("FinalKillSignal");
    }

    public String getKillMode() {
        return this.properties.getString("KillMode");
    }

    public int getKillSignal() {
        return this.properties.getInteger("KillSignal");
    }

    public int getRestartKillSignal() {
        return this.properties.getInteger("RestartKillSignal");
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public BigInteger getRuntimeMaxUSec() {
        return this.properties.getBigInteger("RuntimeMaxUSec");
    }

    public boolean isSendSIGHUP() {
        return this.properties.getBoolean("SendSIGHUP");
    }

    public boolean isSendSIGKILL() {
        return this.properties.getBoolean("SendSIGKILL");
    }

    public String getSlice() {
        return this.properties.getString("Slice");
    }

    public BigInteger getTimeoutStopUSec() {
        return this.properties.getBigInteger("TimeoutStopUSec");
    }

    public int getWatchdogSignal() {
        return this.properties.getInteger("WatchdogSignal");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String CONTROL_GROUP = "ControlGroup";
        public static final String CONTROLLER = "Controller";
        public static final String DEVICE_ALLOW = "DeviceAllow";
        public static final String DEVICE_POLICY = "DevicePolicy";
        public static final String FINAL_KILL_SIGNAL = "FinalKillSignal";
        public static final String KILL_MODE = "KillMode";
        public static final String KILL_SIGNAL = "KillSignal";
        public static final String RESTART_KILL_SIGNAL = "RestartKillSignal";
        public static final String RESULT = "Result";
        public static final String RUNTIME_MAX_USEC = "RuntimeMaxUSec";
        public static final String SEND_SIGHUP = "SendSIGHUP";
        public static final String SEND_SIGKILL = "SendSIGKILL";
        public static final String SLICE = "Slice";
        public static final String TIMEOUT_STOP_USEC = "TimeoutStopUSec";
        public static final String WATCHDOG_SIGNAL = "WatchdogSignal";

        private Property() {
        }

        public static List<String> getAllNames() {
            return Property.getAllNames(Property.class, CpuAccounting.Property.class, IoAccounting.Property.class, IpAccounting.Property.class, MemoryAccounting.Property.class, ResourceControl.Property.class, TasksAccounting.Property.class);
        }
    }
}

