/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.features.DynamicUserAccounting;
import de.thjom.java.systemd.features.ExtendedCpuAccounting;
import de.thjom.java.systemd.features.ExtendedMemoryAccounting;
import de.thjom.java.systemd.features.IoAccounting;
import de.thjom.java.systemd.features.IpAccounting;
import de.thjom.java.systemd.features.ResourceControl;
import de.thjom.java.systemd.features.TasksAccounting;
import de.thjom.java.systemd.features.Ulimit;
import de.thjom.java.systemd.interfaces.ServiceInterface;
import de.thjom.java.systemd.types.DeviceAllowControl;
import de.thjom.java.systemd.types.EnvironmentFile;
import de.thjom.java.systemd.types.ExecutionInfo;
import de.thjom.java.systemd.types.ExitStatusType;
import de.thjom.java.systemd.types.ExtendedExecutionInfo;
import de.thjom.java.systemd.types.SystemCallFilter;
import de.thjom.java.systemd.types.UnitProcessType;
import java.math.BigInteger;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;

public class Service
extends Unit
implements ExtendedCpuAccounting,
DynamicUserAccounting,
IoAccounting,
IpAccounting,
ExtendedMemoryAccounting,
ResourceControl,
TasksAccounting,
Ulimit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Service";
    public static final String UNIT_SUFFIX = ".service";

    private Service(Manager manager, ServiceInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Service create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        ServiceInterface iface = (ServiceInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, ServiceInterface.class);
        return new Service(manager, iface, name);
    }

    @Override
    public ServiceInterface getInterface() {
        return (ServiceInterface)super.getInterface();
    }

    public void attachProcesses(String cgroupPath, long[] pids) {
        this.getInterface().attachProcesses(cgroupPath, pids);
    }

    public List<UnitProcessType> getProcesses() {
        return this.getInterface().getProcesses();
    }

    public String getBusName() {
        return this.properties.getString("BusName");
    }

    public BigInteger getCapabilityBoundingSet() {
        return this.properties.getBigInteger("CapabilityBoundingSet");
    }

    public String getCleanResult() {
        return this.properties.getString("CleanResult");
    }

    public long getControlPID() {
        return this.properties.getLong("ControlPID");
    }

    public List<DeviceAllowControl> getDeviceAllow() {
        return DeviceAllowControl.list(this.properties.getList("DeviceAllow"));
    }

    public String getDevicePolicy() {
        return this.properties.getString("DevicePolicy");
    }

    public List<String> getEnvironment() {
        return this.properties.getList("Environment");
    }

    public List<EnvironmentFile> getEnvironmentFiles() {
        return EnvironmentFile.list(this.properties.getList("EnvironmentFiles"));
    }

    public List<ExecutionInfo> getExecCondition() {
        return ExecutionInfo.list(this.properties.getList("ExecCondition"));
    }

    public List<ExtendedExecutionInfo> getExecConditionEx() {
        return ExtendedExecutionInfo.list(this.properties.getList("ExecConditionEx"));
    }

    public int getExecMainCode() {
        return this.properties.getInteger("ExecMainCode");
    }

    public long getExecMainExitTimestamp() {
        return this.properties.getLong("ExecMainExitTimestamp");
    }

    public long getExecMainExitTimestampMonotonic() {
        return this.properties.getLong("ExecMainExitTimestampMonotonic");
    }

    public long getExecMainPID() {
        return this.properties.getLong("ExecMainPID");
    }

    public long getExecMainStartTimestamp() {
        return this.properties.getLong("ExecMainStartTimestamp");
    }

    public long getExecMainStartTimestampMonotonic() {
        return this.properties.getLong("ExecMainStartTimestampMonotonic");
    }

    public int getExecMainStatus() {
        return this.properties.getInteger("ExecMainStatus");
    }

    public List<ExecutionInfo> getExecReload() {
        return ExecutionInfo.list(this.properties.getList("ExecReload"));
    }

    public List<ExtendedExecutionInfo> getExecReloadEx() {
        return ExtendedExecutionInfo.list(this.properties.getList("ExecReloadEx"));
    }

    public List<ExecutionInfo> getExecStart() {
        return ExecutionInfo.list(this.properties.getList("ExecStart"));
    }

    public List<ExtendedExecutionInfo> getExecStartEx() {
        return ExtendedExecutionInfo.list(this.properties.getList("ExecStartEx"));
    }

    public List<ExecutionInfo> getExecStartPost() {
        return ExecutionInfo.list(this.properties.getList("ExecStartPost"));
    }

    public List<ExtendedExecutionInfo> getExecStartPostEx() {
        return ExtendedExecutionInfo.list(this.properties.getList("ExecStartPostEx"));
    }

    public List<ExecutionInfo> getExecStartPre() {
        return ExecutionInfo.list(this.properties.getList("ExecStartPre"));
    }

    public List<ExtendedExecutionInfo> getExecStartPreEx() {
        return ExtendedExecutionInfo.list(this.properties.getList("ExecStartPreEx"));
    }

    public List<ExecutionInfo> getExecStop() {
        return ExecutionInfo.list(this.properties.getList("ExecStop"));
    }

    public List<ExtendedExecutionInfo> getExecStopEx() {
        return ExtendedExecutionInfo.list(this.properties.getList("ExecStopEx"));
    }

    public List<ExecutionInfo> getExecStopPost() {
        return ExecutionInfo.list(this.properties.getList("ExecStopPost"));
    }

    public List<ExtendedExecutionInfo> getExecStopPostEx() {
        return ExtendedExecutionInfo.list(this.properties.getList("ExecStopPostEx"));
    }

    public long getFileDescriptorStoreMax() {
        return this.properties.getLong("FileDescriptorStoreMax");
    }

    public int getFinalKillSignal() {
        return this.properties.getInteger("FinalKillSignal");
    }

    public boolean isGuessMainPID() {
        return this.properties.getBoolean("GuessMainPID");
    }

    public int getIOSchedulingClass() {
        return this.properties.getInteger("IOSchedulingClass");
    }

    public int getIOSchedulingPriority() {
        return this.properties.getInteger("IOSchedulingPriority");
    }

    public boolean isIgnoreSIGPIPE() {
        return this.properties.getBoolean("IgnoreSIGPIPE");
    }

    public List<String> getInaccessiblePaths() {
        return this.properties.getList("InaccessiblePaths");
    }

    public String getKillMode() {
        return this.properties.getString("KillMode");
    }

    public int getKillSignal() {
        return this.properties.getInteger("KillSignal");
    }

    public int getMainPID() {
        return this.properties.getInteger("MainPID");
    }

    public BigInteger getMountFlags() {
        return this.properties.getBigInteger("MountFlags");
    }

    public long getNFileDescriptorStore() {
        return this.properties.getLong("NFileDescriptorStore");
    }

    public int getNice() {
        return this.properties.getInteger("Nice");
    }

    public boolean isNoNewPrivileges() {
        return this.properties.getBoolean("NoNewPrivileges");
    }

    public boolean isNonBlocking() {
        return this.properties.getBoolean("NonBlocking");
    }

    public String getNotifyAccess() {
        return this.properties.getString("NotifyAccess");
    }

    public long getNRestarts() {
        return this.properties.getLong("NRestarts");
    }

    public String getOOMPolicy() {
        return this.properties.getString("OOMPolicy");
    }

    public int getOOMScoreAdjust() {
        return this.properties.getInteger("OOMScoreAdjust");
    }

    public String getPAMName() {
        return this.properties.getString("PAMName");
    }

    public String getPIDFile() {
        return this.properties.getString("PIDFile");
    }

    public List<String> getReadOnlyPaths() {
        return this.properties.getList("ReadOnlyPaths");
    }

    public List<String> getReadWritePaths() {
        return this.properties.getList("ReadWritePaths");
    }

    public String getReloadResult() {
        return this.properties.getString("ReloadResult");
    }

    public boolean isRemainAfterExit() {
        return this.properties.getBoolean("RemainAfterExit");
    }

    public String getRestart() {
        return this.properties.getString("Restart");
    }

    public ExitStatusType getRestartForceExitStatus() {
        return ExitStatusType.of((Object[])this.properties.getVariant("RestartForceExitStatus").getValue());
    }

    public int getRestartKillSignal() {
        return this.properties.getInteger("RestartKillSignal");
    }

    public ExitStatusType getRestartPreventExitStatus() {
        return ExitStatusType.of((Object[])this.properties.getVariant("RestartPreventExitStatus").getValue());
    }

    public BigInteger getRestartUSec() {
        return this.properties.getBigInteger("RestartUSec");
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public String getRootDirectory() {
        return this.properties.getString("RootDirectory");
    }

    public boolean isRootDirectoryStartOnly() {
        return this.properties.getBoolean("RootDirectoryStartOnly");
    }

    public BigInteger getRuntimeMaxUSec() {
        return this.properties.getBigInteger("RuntimeMaxUSec");
    }

    public boolean isSameProcessGroup() {
        return this.properties.getBoolean("SameProcessGroup");
    }

    public int getSecureBits() {
        return this.properties.getInteger("SecureBits");
    }

    public boolean isSendSIGHUP() {
        return this.properties.getBoolean("SendSIGHUP");
    }

    public boolean isSendSIGKILL() {
        return this.properties.getBoolean("SendSIGKILL");
    }

    public String getSlice() {
        return this.properties.getString("Slice");
    }

    public int getStatusErrno() {
        return this.properties.getInteger("StatusErrno");
    }

    public String getStatusText() {
        return this.properties.getString("StatusText");
    }

    public ExitStatusType getSuccessExitStatus() {
        return ExitStatusType.of((Object[])this.properties.getVariant("SuccessExitStatus").getValue());
    }

    public List<String> getSupplementaryGroups() {
        return this.properties.getList("SupplementaryGroups");
    }

    public String getSyslogIdentifier() {
        return this.properties.getString("SyslogIdentifier");
    }

    public boolean isSyslogLevelPrefix() {
        return this.properties.getBoolean("SyslogLevelPrefix");
    }

    public int getSyslogPriority() {
        return this.properties.getInteger("SyslogPriority");
    }

    public SystemCallFilter getSystemCallFilter() {
        Object[] array = (Object[])this.properties.getVariant("SystemCallFilter").getValue();
        return new SystemCallFilter(array);
    }

    public String getTTYPath() {
        return this.properties.getString("TTYPath");
    }

    public boolean isTTYReset() {
        return this.properties.getBoolean("TTYReset");
    }

    public boolean isTTYVHangup() {
        return this.properties.getBoolean("TTYVHangup");
    }

    public boolean isTTYVTDisallocate() {
        return this.properties.getBoolean("TTYVTDisallocate");
    }

    public BigInteger getTimeoutAbortUSec() {
        return this.properties.getBigInteger("TimeoutAbortUSec");
    }

    public String getTimeoutStartFailureMode() {
        return this.properties.getString("TimeoutStartFailureMode");
    }

    public BigInteger getTimeoutStartUSec() {
        return this.properties.getBigInteger("TimeoutStartUSec");
    }

    public String getTimeoutStopFailureMode() {
        return this.properties.getString("TimeoutStopFailureMode");
    }

    public BigInteger getTimeoutStopUSec() {
        return this.properties.getBigInteger("TimeoutStopUSec");
    }

    public BigInteger getTimerSlackNSec() {
        return this.properties.getBigInteger("TimerSlackNSec");
    }

    public String getType() {
        return this.properties.getString("Type");
    }

    public long getUMask() {
        return this.properties.getLong("UMask");
    }

    public String getUSBFunctionDescriptors() {
        return this.properties.getString("USBFunctionDescriptors");
    }

    public String getUSBFunctionStrings() {
        return this.properties.getString("USBFunctionStrings");
    }

    public int getWatchdogSignal() {
        return this.properties.getInteger("WatchdogSignal");
    }

    public long getWatchdogTimestamp() {
        return this.properties.getLong("WatchdogTimestamp");
    }

    public long getWatchdogTimestampMonotonic() {
        return this.properties.getLong("WatchdogTimestampMonotonic");
    }

    public BigInteger getWatchdogUSec() {
        return this.properties.getBigInteger("WatchdogUSec");
    }

    public String getWorkingDirectory() {
        return this.properties.getString("WorkingDirectory");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String BUS_NAME = "BusName";
        public static final String CAPABILITY_BOUNDING_SET = "CapabilityBoundingSet";
        public static final String CLEAN_RESULT = "CleanResult";
        public static final String CONTROL_PID = "ControlPID";
        public static final String DEVICE_ALLOW = "DeviceAllow";
        public static final String DEVICE_POLICY = "DevicePolicy";
        public static final String ENVIRONMENT = "Environment";
        public static final String ENVIRONMENT_FILES = "EnvironmentFiles";
        public static final String EXEC_CONDITION = "ExecCondition";
        public static final String EXEC_CONDITION_EX = "ExecConditionEx";
        public static final String EXEC_MAIN_CODE = "ExecMainCode";
        public static final String EXEC_MAIN_EXIT_TIMESTAMP = "ExecMainExitTimestamp";
        public static final String EXEC_MAIN_EXIT_TIMESTAMP_MONOTONIC = "ExecMainExitTimestampMonotonic";
        public static final String EXEC_MAIN_PID = "ExecMainPID";
        public static final String EXEC_MAIN_START_TIMESTAMP = "ExecMainStartTimestamp";
        public static final String EXEC_MAIN_START_TIMESTAMP_MONOTONIC = "ExecMainStartTimestampMonotonic";
        public static final String EXEC_MAIN_STATUS = "ExecMainStatus";
        public static final String EXEC_RELOAD = "ExecReload";
        public static final String EXEC_RELOAD_EX = "ExecReloadEx";
        public static final String EXEC_START = "ExecStart";
        public static final String EXEC_START_EX = "ExecStartEx";
        public static final String EXEC_START_POST = "ExecStartPost";
        public static final String EXEC_START_POST_EX = "ExecStartPostEx";
        public static final String EXEC_START_PRE = "ExecStartPre";
        public static final String EXEC_START_PRE_EX = "ExecStartPreEx";
        public static final String EXEC_STOP = "ExecStop";
        public static final String EXEC_STOP_EX = "ExecStopEx";
        public static final String EXEC_STOP_POST = "ExecStopPost";
        public static final String EXEC_STOP_POST_EX = "ExecStopPostEx";
        public static final String FILE_DESCRIPTOR_STORE_MAX = "FileDescriptorStoreMax";
        public static final String FINAL_KILL_SIGNAL = "FinalKillSignal";
        public static final String GUESS_MAIN_PID = "GuessMainPID";
        public static final String IO_SCHEDULING_CLASS = "IOSchedulingClass";
        public static final String IO_SCHEDULING_PRIORITY = "IOSchedulingPriority";
        public static final String IGNORE_SIGPIPE = "IgnoreSIGPIPE";
        public static final String INACCESSIBLE_PATHS = "InaccessiblePaths";
        public static final String KILL_MODE = "KillMode";
        public static final String KILL_SIGNAL = "KillSignal";
        public static final String MAIN_PID = "MainPID";
        public static final String MOUNT_FLAGS = "MountFlags";
        public static final String NFILE_DESCRIPTOR_STORE = "NFileDescriptorStore";
        public static final String NICE = "Nice";
        public static final String NO_NEW_PRIVILEGES = "NoNewPrivileges";
        public static final String NON_BLOCKING = "NonBlocking";
        public static final String NOTIFY_ACCESS = "NotifyAccess";
        public static final String N_RESTARTS = "NRestarts";
        public static final String OOM_POLICY = "OOMPolicy";
        public static final String OOM_SCORE_ADJUST = "OOMScoreAdjust";
        public static final String PAM_NAME = "PAMName";
        public static final String PID_FILE = "PIDFile";
        public static final String READ_ONLY_PATHS = "ReadOnlyPaths";
        public static final String READ_WRITE_PATHS = "ReadWritePaths";
        public static final String RELOAD_RESULT = "ReloadResult";
        public static final String REMAIN_AFTER_EXIT = "RemainAfterExit";
        public static final String RESTART = "Restart";
        public static final String RESTART_FORCE_EXIT_STATUS = "RestartForceExitStatus";
        public static final String RESTART_KILL_SIGNAL = "RestartKillSignal";
        public static final String RESTART_PREVENT_EXIT_STATUS = "RestartPreventExitStatus";
        public static final String RESTART_USEC = "RestartUSec";
        public static final String RESULT = "Result";
        public static final String ROOT_DIRECTORY = "RootDirectory";
        public static final String ROOT_DIRECTORY_START_ONLY = "RootDirectoryStartOnly";
        public static final String RUNTIME_MAX_USEC = "RuntimeMaxUSec";
        public static final String SAME_PROCESS_GROUP = "SameProcessGroup";
        public static final String SECURE_BITS = "SecureBits";
        public static final String SEND_SIGHUP = "SendSIGHUP";
        public static final String SEND_SIGKILL = "SendSIGKILL";
        public static final String SLICE = "Slice";
        public static final String STATUS_ERRNO = "StatusErrno";
        public static final String STATUS_TEXT = "StatusText";
        public static final String SUCCESS_EXIT_STATUS = "SuccessExitStatus";
        public static final String SUPPLEMENTARY_GROUPS = "SupplementaryGroups";
        public static final String SYSLOG_IDENTIFIER = "SyslogIdentifier";
        public static final String SYSLOG_LEVEL_PREFIX = "SyslogLevelPrefix";
        public static final String SYSLOG_PRIORITY = "SyslogPriority";
        public static final String SYSTEM_CALL_FILTER = "SystemCallFilter";
        public static final String TTY_PATH = "TTYPath";
        public static final String TTY_RESET = "TTYReset";
        public static final String TTY_V_HANGUP = "TTYVHangup";
        public static final String TTY_VT_DISALLOCATE = "TTYVTDisallocate";
        public static final String TIMEOUT_ABORT_USEC = "TimeoutAbortUSec";
        public static final String TIMEOUT_START_FAILURE_MODE = "TimeoutStartFailureMode";
        public static final String TIMEOUT_START_USEC = "TimeoutStartUSec";
        public static final String TIMEOUT_STOP_FAILURE_MODE = "TimeoutStopFailureMode";
        public static final String TIMEOUT_STOP_USEC = "TimeoutStopUSec";
        public static final String TIMER_SLACK_NSEC = "TimerSlackNSec";
        public static final String TYPE = "Type";
        public static final String UMASK = "UMask";
        public static final String USB_FUNCTION_DESCRIPTORS = "USBFunctionDescriptors";
        public static final String USB_FUNCTION_STRINGS = "USBFunctionStrings";
        public static final String WATCHDOG_SIGNAL = "WatchdogSignal";
        public static final String WATCHDOG_TIMESTAMP = "WatchdogTimestamp";
        public static final String WATCHDOG_TIMESTAMP_MONOTONIC = "WatchdogTimestampMonotonic";
        public static final String WATCHDOG_USEC = "WatchdogUSec";
        public static final String WORKING_DIRECTORY = "WorkingDirectory";

        private Property() {
        }

        public static List<String> getAllNames() {
            return Property.getAllNames(Property.class, ExtendedCpuAccounting.Property.class, DynamicUserAccounting.Property.class, IoAccounting.Property.class, IpAccounting.Property.class, ExtendedMemoryAccounting.Property.class, ResourceControl.Property.class, TasksAccounting.Property.class, Ulimit.Property.class);
        }
    }
}

