/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.TimerInterface;
import de.thjom.java.systemd.types.TimersCalendar;
import de.thjom.java.systemd.types.TimersMonotonic;
import java.math.BigInteger;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;

public class Timer
extends Unit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Timer";
    public static final String UNIT_SUFFIX = ".timer";

    private Timer(Manager manager, TimerInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Timer create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        TimerInterface iface = (TimerInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, TimerInterface.class);
        return new Timer(manager, iface, name);
    }

    @Override
    public TimerInterface getInterface() {
        return (TimerInterface)super.getInterface();
    }

    public BigInteger getAccuracyUSec() {
        return this.properties.getBigInteger("AccuracyUSec");
    }

    public boolean isFixedRandomDelay() {
        return this.properties.getBoolean("FixedRandomDelay");
    }

    public BigInteger getLastTriggerUSec() {
        return this.properties.getBigInteger("LastTriggerUSec");
    }

    public BigInteger getLastTriggerUSecMonotonic() {
        return this.properties.getBigInteger("LastTriggerUSecMonotonic");
    }

    public BigInteger getNextElapseUSecMonotonic() {
        return this.properties.getBigInteger("NextElapseUSecMonotonic");
    }

    public BigInteger getNextElapseUSecRealtime() {
        return this.properties.getBigInteger("NextElapseUSecRealtime");
    }

    public boolean isOnClockChange() {
        return this.properties.getBoolean("OnClockChange");
    }

    public boolean isOnTimezoneChange() {
        return this.properties.getBoolean("OnTimezoneChange");
    }

    public boolean isPersistent() {
        return this.properties.getBoolean("Persistent");
    }

    public BigInteger getRandomizedDelayUSec() {
        return this.properties.getBigInteger("RandomizedDelayUSec");
    }

    public boolean isRemainAfterElapse() {
        return this.properties.getBoolean("RemainAfterElapse");
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public String getUnit() {
        return this.properties.getString("Unit");
    }

    public List<TimersCalendar> getTimersCalendar() {
        return TimersCalendar.list(this.properties.getList("TimersCalendar"));
    }

    public List<TimersMonotonic> getTimersMonotonic() {
        return TimersMonotonic.list(this.properties.getList("TimersMonotonic"));
    }

    public boolean isWakeSystem() {
        return this.properties.getBoolean("WakeSystem");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String ACCURACY_USEC = "AccuracyUSec";
        public static final String FIXED_RANDOM_DELAY = "FixedRandomDelay";
        public static final String LAST_TRIGGER_USEC = "LastTriggerUSec";
        public static final String LAST_TRIGGER_USEC_MONOTONIC = "LastTriggerUSecMonotonic";
        public static final String NEXT_ELAPSE_USEC_MONOTONIC = "NextElapseUSecMonotonic";
        public static final String NEXT_ELAPSE_USEC_REALTIME = "NextElapseUSecRealtime";
        public static final String ON_CLOCK_CHANGE = "OnClockChange";
        public static final String ON_TIMEZONE_CHANGE = "OnTimezoneChange";
        public static final String PERSISTENT = "Persistent";
        public static final String RANDOMIZED_DELAY_USEC = "RandomizedDelayUSec";
        public static final String REMAIN_AFTER_ELAPSE = "RemainAfterElapse";
        public static final String RESULT = "Result";
        public static final String UNIT = "Unit";
        public static final String TIMERS_CALENDAR = "TimersCalendar";
        public static final String TIMERS_MONOTONIC = "TimersMonotonic";
        public static final String WAKE_SYSTEM = "WakeSystem";

        private Property() {
        }

        public static List<String> getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

