/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd.features;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.features.Feature;
import de.thjom.java.systemd.types.IpAddressPolicy;
import java.math.BigInteger;
import java.util.List;

public interface IpAccounting
extends Feature {
    default public boolean isIPAccounting() {
        return this.getProperties().getBoolean("IPAccounting");
    }

    default public List<IpAddressPolicy> getIPAddressAllow() {
        return IpAddressPolicy.list(this.getProperties().getList("IPAddressAllow"));
    }

    default public List<IpAddressPolicy> getIPAddressDeny() {
        return IpAddressPolicy.list(this.getProperties().getList("IPAddressDeny"));
    }

    default public BigInteger getIPEgressBytes() {
        return this.getProperties().getBigInteger("IPEgressBytes");
    }

    default public BigInteger getIPEgressPackets() {
        return this.getProperties().getBigInteger("IPEgressPackets");
    }

    default public BigInteger getIPIngressBytes() {
        return this.getProperties().getBigInteger("IPIngressBytes");
    }

    default public BigInteger getIPIngressPackets() {
        return this.getProperties().getBigInteger("IPIngressPackets");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String IP_ACCOUNTING = "IPAccounting";
        public static final String IP_ADDRESS_ALLOW = "IPAddressAllow";
        public static final String IP_ADDRESS_DENY = "IPAddressDeny";
        public static final String IP_EGRESS_BYTES = "IPEgressBytes";
        public static final String IP_EGRESS_PACKETS = "IPEgressPackets";
        public static final String IP_INGRESS_BYTES = "IPIngressBytes";
        public static final String IP_INGRESS_PACKETS = "IPIngressPackets";

        private Property() {
        }

        public static final List<String> getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

