/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnvironmentFile {
    private final String filePath;
    private final boolean prefixed;

    public EnvironmentFile(Object[] array) {
        this.filePath = String.valueOf(array[0]);
        this.prefixed = (Boolean)array[1];
    }

    public static List<EnvironmentFile> list(Collection<Object[]> arrays) {
        ArrayList<EnvironmentFile> envFiles = new ArrayList<EnvironmentFile>(arrays.size());
        for (Object[] array : arrays) {
            EnvironmentFile envFile = new EnvironmentFile(array);
            envFiles.add(envFile);
        }
        return envFiles;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean isPrefixed() {
        return this.prefixed;
    }

    public String toConfigString() {
        return String.format("%s%s", this.prefixed ? "-" : "", this.filePath);
    }

    public String toString() {
        return String.format("EnvironmentFile [filePath=%s, prefixed=%s]", this.filePath, this.prefixed);
    }
}

