/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.UInt64;

public class ExecutionInfo {
    private final String binaryPath;
    private final List<String> arguments;
    private final boolean failOnUncleanExit;
    private final long lastStartTimestamp;
    private final long lastStartTimestampMonotonic;
    private final long lastFinishTimestamp;
    private final long lastFinishTimestampMonotonic;
    private final int processId;
    private final int lastExitCode;
    private final int lastExitStatus;

    public ExecutionInfo(Object[] array) {
        this.binaryPath = String.valueOf(array[0]);
        this.arguments = (List)array[1];
        this.failOnUncleanExit = (Boolean)array[2];
        this.lastStartTimestamp = ((UInt64)array[3]).longValue();
        this.lastStartTimestampMonotonic = ((UInt64)array[4]).longValue();
        this.lastFinishTimestamp = ((UInt64)array[5]).longValue();
        this.lastFinishTimestampMonotonic = ((UInt64)array[6]).longValue();
        this.processId = ((UInt32)array[7]).intValue();
        this.lastExitCode = (Integer)array[8];
        this.lastExitStatus = (Integer)array[9];
    }

    public static List<ExecutionInfo> list(Collection<Object[]> arrays) {
        ArrayList<ExecutionInfo> execs = new ArrayList<ExecutionInfo>(arrays.size());
        for (Object[] array : arrays) {
            ExecutionInfo exec = new ExecutionInfo(array);
            execs.add(exec);
        }
        return execs;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public boolean isFailOnUncleanExit() {
        return this.failOnUncleanExit;
    }

    public long getLastStartTimestamp() {
        return this.lastStartTimestamp;
    }

    public long getLastStartTimestampMonotonic() {
        return this.lastStartTimestampMonotonic;
    }

    public long getLastFinishTimestamp() {
        return this.lastFinishTimestamp;
    }

    public long getLastFinishTimestampMonotonic() {
        return this.lastFinishTimestampMonotonic;
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getLastExitCode() {
        return this.lastExitCode;
    }

    public int getLastExitStatus() {
        return this.lastExitStatus;
    }

    public String toString() {
        return "ExecutionInfo [binaryPath=" + this.binaryPath + ", arguments=" + this.arguments + ", failOnUncleanExit=" + this.failOnUncleanExit + ", lastStartTimestamp=" + this.lastStartTimestamp + ", lastStartTimestampMonotonic=" + this.lastStartTimestampMonotonic + ", lastFinishTimestamp=" + this.lastFinishTimestamp + ", lastFinishTimestampMonotonic=" + this.lastFinishTimestampMonotonic + ", processId=" + this.processId + ", lastExitCode=" + this.lastExitCode + ", lastExitStatus=" + this.lastExitStatus + "]";
    }
}

