/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd.types;

import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.types.UInt32;

public class UnitProcessType
extends Struct
implements Comparable<UnitProcessType> {
    @Position(value=0)
    private final String cgroupPath;
    @Position(value=1)
    private final int pid;
    @Position(value=2)
    private final String commandLine;

    public UnitProcessType(String cgroupPath, UInt32 pid, String commandLine) {
        this.cgroupPath = cgroupPath;
        this.pid = pid.intValue();
        this.commandLine = commandLine;
    }

    public String getCgroupPath() {
        return this.cgroupPath;
    }

    public int getPid() {
        return this.pid;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public String toFormattedString() {
        return String.format("%s %d %s", this.cgroupPath, this.pid, this.commandLine);
    }

    @Override
    public int compareTo(UnitProcessType other) {
        if (other == null) {
            return Integer.MAX_VALUE;
        }
        return Integer.compare(this.pid, other.pid);
    }
}

