/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd.types;

import de.thjom.java.systemd.types.UnitBase;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.types.UInt32;

public class UnitType
extends UnitBase
implements Comparable<UnitType> {
    @Position(value=0)
    private final String unitName;
    @Position(value=1)
    private final String unitDescription;
    @Position(value=2)
    private final String loadState;
    @Position(value=3)
    private final String activeState;
    @Position(value=4)
    private final String subState;
    @Position(value=5)
    private final String followingUnit;
    @Position(value=6)
    private final DBusPath unitObjectPath;
    @Position(value=7)
    private final int jobId;
    @Position(value=8)
    private final String jobType;
    @Position(value=9)
    private final DBusPath jobObjectPath;

    public UnitType(String unitName, String unitDescription, String loadState, String activeState, String subState, String followingUnit, DBusPath unitObjectPath, UInt32 jobId, String jobType, DBusPath jobObjectPath) {
        super(unitName);
        this.unitName = unitName;
        this.unitDescription = unitDescription;
        this.loadState = loadState;
        this.activeState = activeState;
        this.subState = subState;
        this.followingUnit = followingUnit;
        this.unitObjectPath = unitObjectPath;
        this.jobId = jobId.intValue();
        this.jobType = jobType;
        this.jobObjectPath = jobObjectPath;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getUnitDescription() {
        return this.unitDescription;
    }

    public String getLoadState() {
        return this.loadState;
    }

    public String getActiveState() {
        return this.activeState;
    }

    public String getSubState() {
        return this.subState;
    }

    public String getFollowingUnit() {
        return this.followingUnit;
    }

    public DBusPath getUnitObjectPath() {
        return this.unitObjectPath;
    }

    public int getJobId() {
        return this.jobId;
    }

    public String getJobType() {
        return this.jobType;
    }

    public DBusPath getJobObjectPath() {
        return this.jobObjectPath;
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder(500).append(this.unitName).append(System.lineSeparator()).append(" Description: ").append(this.unitDescription).append(System.lineSeparator()).append(" LoadState: ").append(this.loadState).append(System.lineSeparator()).append(" ActiveState: ").append(this.activeState).append(System.lineSeparator()).append(" SubState: ").append(this.subState).append(System.lineSeparator()).append(" FollowingUnit: ").append(this.followingUnit).append(System.lineSeparator()).append(" ObjectPath: ").append(this.unitObjectPath).append(System.lineSeparator()).append(" JobID: ").append(this.jobId).append(System.lineSeparator()).append(" JobType: ").append(this.jobType).append(System.lineSeparator()).append(" JobObjectPath: ").append(this.jobObjectPath).append(System.lineSeparator());
        builder.trimToSize();
        return builder.toString();
    }

    @Override
    public int compareTo(UnitType other) {
        if (other == null) {
            return Integer.MAX_VALUE;
        }
        return this.unitName.compareTo(other.unitName);
    }
}

