/*
 * Decompiled with CFR 0.152.
 */
package com.github.vr_f.sqlparser;

import com.github.vr_f.sqlparser.InnerParser;
import com.github.vr_f.sqlparser.Lexer;
import com.github.vr_f.sqlparser.core.Exception;
import com.github.vr_f.sqlparser.core.MySqlVersion;
import com.github.vr_f.sqlparser.core.exception.ReThrown;
import com.github.vr_f.sqlparser.core.keywords.KeywordsLibrary;
import com.github.vr_f.sqlparser.expression.Select;
import java.io.Reader;
import java_cup.runtime.Scanner;

public class Parser {
    private boolean debug = false;
    private MySqlVersion version = MySqlVersion.v8_0;

    public boolean isDebug() {
        return this.debug;
    }

    public Parser setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public MySqlVersion getVersion() {
        return this.version;
    }

    public Parser setVersion(MySqlVersion version) {
        this.version = version;
        return this;
    }

    public Select parse(Reader reader) throws Exception {
        Lexer lexer = new Lexer(reader);
        KeywordsLibrary keywords = new KeywordsLibrary(this.getVersion());
        InnerParser parser = new InnerParser((Scanner)lexer, keywords);
        try {
            if (this.isDebug()) {
                return (Select)parser.debug_parse().value;
            }
            return (Select)parser.parse().value;
        }
        catch (Exception e) {
            throw e;
        }
        catch (java.lang.Exception e) {
            throw new ReThrown(e);
        }
    }
}

