// Copyright 2021 Tencent Inc. All rights reserved.
//
// 爱心餐对外API
//
// 微信支付爱心餐公益计划旨在面向深圳市的市政一线环卫工人提供每周一餐的1分钱用餐公益服务。在受助端，微信支付联动上千家餐饮门店关爱特殊人群，通过微信支付数字化能力将人群身份认证与公益福利领用全流程线上化，实现公益福利精准到人。在捐赠端，微信支付发挥连接优势与平台能力，结合用户就餐场景通过爱心餐一块捐插件让用户可在点餐时顺手捐1元，带动更多社会力量致谢城市美容师。
//
// API version: 0.0.4

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.lovefeast;

import static com.wechat.pay.java.core.http.UrlEncoder.urlEncode;
import static com.wechat.pay.java.core.util.GsonUtil.toJson;
import static java.util.Objects.requireNonNull;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.exception.HttpException;
import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.exception.ServiceException;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.core.http.Constant;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.service.lovefeast.model.BrandEntity;
import com.wechat.pay.java.service.lovefeast.model.GetBrandRequest;
import com.wechat.pay.java.service.lovefeast.model.GetByUserRequest;
import com.wechat.pay.java.service.lovefeast.model.ListByUserRequest;
import com.wechat.pay.java.service.lovefeast.model.OrdersEntity;
import com.wechat.pay.java.service.lovefeast.model.OrdersListByUserResponse;

/** LovefeastService服务 */
public class LovefeastService {

  private final HttpClient httpClient;
  private final HostName hostName;

  private LovefeastService(HttpClient httpClient, HostName hostName) {
    this.httpClient = requireNonNull(httpClient);
    this.hostName = hostName;
  }
  /** LovefeastService构造器 */
  public static class Builder {

    private HttpClient httpClient;
    private HostName hostName;

    public Builder config(Config config) {
      this.httpClient =
          new DefaultHttpClientBuilder()
              .credential(requireNonNull(config.createCredential()))
              .validator(requireNonNull(config.createValidator()))
              .build();

      return this;
    }

    public Builder hostName(HostName hostName) {
      this.hostName = hostName;
      return this;
    }

    public Builder httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      return this;
    }

    public LovefeastService build() {
      return new LovefeastService(httpClient, hostName);
    }
  }

  /**
   * 查询爱心餐品牌信息
   *
   * @param request 请求参数
   * @return BrandEntity
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public BrandEntity getBrand(GetBrandRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/lovefeast/brands/{brand_id}";

    GetBrandRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "brand_id" + "}", urlEncode(realRequest.getBrandId().toString()));
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<BrandEntity> httpResponse = httpClient.execute(httpRequest, BrandEntity.class);
    return httpResponse.getServiceResponse();
  }
  /**
   * 查询用户捐赠单详情
   *
   * @param request 请求参数
   * @return OrdersEntity
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public OrdersEntity getByUser(GetByUserRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/lovefeast/users/{openid}/orders/out-trade-no/{out_trade_no}";

    GetByUserRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "openid" + "}", urlEncode(realRequest.getOpenid()));

    requestPath =
        requestPath.replace("{" + "out_trade_no" + "}", urlEncode(realRequest.getOutTradeNo()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<OrdersEntity> httpResponse = httpClient.execute(httpRequest, OrdersEntity.class);
    return httpResponse.getServiceResponse();
  }
  /**
   * 查询用户捐赠单列表
   *
   * @param request 请求参数
   * @return OrdersListByUserResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public OrdersListByUserResponse listByUser(ListByUserRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/lovefeast/users/{openid}/orders/brand-id/{brand_id}";

    ListByUserRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "openid" + "}", urlEncode(realRequest.getOpenid()));

    requestPath =
        requestPath.replace("{" + "brand_id" + "}", urlEncode(realRequest.getBrandId().toString()));
    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<OrdersListByUserResponse> httpResponse =
        httpClient.execute(httpRequest, OrdersListByUserResponse.class);
    return httpResponse.getServiceResponse();
  }

  private RequestBody createRequestBody(Object request) {
    return new JsonRequestBody.Builder().body(toJson(request)).build();
  }
}
