// Copyright 2021 Tencent Inc. All rights reserved.
//
// 商家转账对外API
//
// * 场景及业务流程：     商户可通过该产品实现同时向多个用户微信零钱进行转账的操作，可用于发放奖金补贴、佣金货款结算、员工报销等场景。
// [https://pay.weixin.qq.com/index.php/public/product/detail?pid=108&productType=0](https://pay.weixin.qq.com/index.php/public/product/detail?pid=108&productType=0) * 接入步骤：     * 商户在微信支付商户平台开通“批量转账到零钱”产品权限，并勾选“使用API方式发起转账”。     * 调用批量转账接口，对多个用户微信零钱发起转账。     * 调用查询批次接口，可获取到转账批次详情及当前状态。     * 调用查询明细接口，可获取到单条转账明细详情及当前状态。
//
// API version: 1.0.3

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.transferbatch.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/** GetTransferBatchByNoRequest */
public class GetTransferBatchByNoRequest {
  /** 微信批次单号 说明：微信批次单号，微信商家转账系统返回的唯一标识 */
  @SerializedName("batch_id")
  @Expose(serialize = false)
  private String batchId;
  /**
   * 是否查询转账明细单 说明：true-是；false-否，默认否。商户可选择是否查询指定状态的转账明细单，当转账批次单状态为“FINISHED”（已完成）时，才会返回满足条件的转账明细单
   */
  @SerializedName("need_query_detail")
  @Expose(serialize = false)
  private Boolean needQueryDetail;
  /** 请求资源起始位置 说明：该次请求资源的起始位置。返回的明细是按照设置的明细条数进行分页展示的，一次查询可能无法返回所有明细，我们使用该参数标识查询开始位置，默认值为0 */
  @SerializedName("offset")
  @Expose(serialize = false)
  private Integer offset;
  /** 最大资源条数 说明：该次请求可返回的最大明细条数，最小20条，最大100条，不传则默认20条。不足20条按实际条数返回 */
  @SerializedName("limit")
  @Expose(serialize = false)
  private Integer limit;
  /**
   * 明细状态 说明：查询指定状态的转账明细单 ALL:全部。需要同时查询转账成功和转账失败的明细单 SUCCESS:转账成功。只查询转账成功的明细单 FAIL:转账失败。只查询转账失败的明细单
   */
  @SerializedName("detail_status")
  @Expose(serialize = false)
  private String detailStatus;

  public String getBatchId() {
    return batchId;
  }

  public void setBatchId(String batchId) {
    this.batchId = batchId;
  }

  public Boolean getNeedQueryDetail() {
    return needQueryDetail;
  }

  public void setNeedQueryDetail(Boolean needQueryDetail) {
    this.needQueryDetail = needQueryDetail;
  }

  public Integer getOffset() {
    return offset;
  }

  public void setOffset(Integer offset) {
    this.offset = offset;
  }

  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public String getDetailStatus() {
    return detailStatus;
  }

  public void setDetailStatus(String detailStatus) {
    this.detailStatus = detailStatus;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetTransferBatchByNoRequest {\n");
    sb.append("    batchId: ").append(toIndentedString(batchId)).append("\n");
    sb.append("    needQueryDetail: ").append(toIndentedString(needQueryDetail)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    detailStatus: ").append(toIndentedString(detailStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
