/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.lambda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.lambda.SeqImpl;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;

public interface Seq<T>
extends Stream<T>,
Iterable<T> {
    public Stream<T> stream();

    default public Seq<T> concat(Stream<T> other) {
        return Seq.concat(new Stream[]{this, other});
    }

    default public Seq<T> concat(T other) {
        return this.concat((T)Seq.of(other));
    }

    default public Seq<T> concat(T ... other) {
        return this.concat((T)Seq.of(other));
    }

    default public Seq<T> cycle() {
        return Seq.cycle(this);
    }

    default public <U> Seq<Tuple2<T, U>> zip(Seq<U> other) {
        return Seq.zip(this, other);
    }

    default public <U, R> Seq<R> zip(Seq<U> other, BiFunction<T, U, R> zipper) {
        return Seq.zip(this, other, zipper);
    }

    default public Seq<Tuple2<T, Long>> zipWithIndex() {
        return Seq.zipWithIndex(this);
    }

    default public <U> U foldLeft(U seed, BiFunction<U, ? super T, U> function) {
        return Seq.foldLeft(this, seed, function);
    }

    default public <U> U foldRight(U seed, BiFunction<? super T, U, U> function) {
        return Seq.foldRight(this, seed, function);
    }

    default public <U> Seq<U> scanLeft(U seed, BiFunction<U, ? super T, U> function) {
        return Seq.scanLeft(this, seed, function);
    }

    default public <U> Seq<U> scanRight(U seed, BiFunction<? super T, U, U> function) {
        return Seq.scanRight(this, seed, function);
    }

    default public Seq<T> reverse() {
        return Seq.reverse(this);
    }

    default public Seq<T> shuffle() {
        return Seq.shuffle(this);
    }

    default public Seq<T> shuffle(Random random) {
        return Seq.shuffle(this, random);
    }

    default public Seq<T> skipWhile(Predicate<? super T> predicate) {
        return Seq.skipWhile(this, predicate);
    }

    default public Seq<T> skipUntil(Predicate<? super T> predicate) {
        return Seq.skipUntil(this, predicate);
    }

    default public Seq<T> limitWhile(Predicate<? super T> predicate) {
        return Seq.limitWhile(this, predicate);
    }

    default public Seq<T> limitUntil(Predicate<? super T> predicate) {
        return Seq.limitUntil(this, predicate);
    }

    default public Seq<T> intersperse(T value) {
        return Seq.intersperse(this, value);
    }

    default public Tuple2<Seq<T>, Seq<T>> duplicate() {
        return Seq.duplicate(this);
    }

    default public Tuple2<Seq<T>, Seq<T>> partition(Predicate<? super T> predicate) {
        return Seq.partition(this, predicate);
    }

    default public Tuple2<Seq<T>, Seq<T>> splitAt(long position) {
        return Seq.splitAt(this, position);
    }

    default public Tuple2<Optional<T>, Seq<T>> splitAtHead() {
        return Seq.splitAtHead(this);
    }

    default public Seq<T> slice(long from, long to) {
        return Seq.slice(this, from, to);
    }

    default public <C extends Collection<T>> C toCollection(Supplier<C> collectionFactory) {
        return Seq.toCollection(this, collectionFactory);
    }

    @Override
    default public List<T> toList() {
        return Seq.toList(this);
    }

    default public Set<T> toSet() {
        return Seq.toSet(this);
    }

    default public <K, V> Map<K, V> toMap(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return Seq.toMap(this, keyMapper, valueMapper);
    }

    default public String toString(String separator) {
        return Seq.toString(this, separator);
    }

    default public <U extends Comparable<U>> Optional<T> minBy(Function<T, U> function) {
        return this.minBy(function, Comparator.naturalOrder());
    }

    default public <U> Optional<T> minBy(Function<T, U> function, Comparator<? super U> comparator) {
        return this.map((T t) -> Tuple.tuple(t, function.apply(t))).min(Comparator.comparing(Tuple2::v2, comparator)).map((? super T t) -> t.v1);
    }

    default public <U extends Comparable<U>> Optional<T> maxBy(Function<T, U> function) {
        return this.maxBy(function, Comparator.naturalOrder());
    }

    default public <U> Optional<T> maxBy(Function<T, U> function, Comparator<? super U> comparator) {
        return this.map((T t) -> Tuple.tuple(t, function.apply(t))).max(Comparator.comparing(Tuple2::v2, comparator)).map((? super T t) -> t.v1);
    }

    default public <U> Seq<U> ofType(Class<U> type) {
        return Seq.ofType(this, type);
    }

    default public <U> Seq<U> cast(Class<U> type) {
        return Seq.cast(this, type);
    }

    default public <K> Map<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        return this.collect(Collectors.groupingBy(classifier));
    }

    default public <K, A, D> Map<K, D> groupBy(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return this.collect(Collectors.groupingBy(classifier, downstream));
    }

    default public <K, D, A, M extends Map<K, D>> M groupBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        return (M)((Map)this.collect(Collectors.groupingBy(classifier, mapFactory, downstream)));
    }

    default public String join() {
        return this.map(Objects::toString).collect(Collectors.joining());
    }

    default public String join(CharSequence delimiter) {
        return this.map(Objects::toString).collect(Collectors.joining(delimiter));
    }

    default public String join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.map(Objects::toString).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    public static <T> Seq<T> of(T value) {
        return Seq.seq(Stream.of(value));
    }

    @SafeVarargs
    public static <T> Seq<T> of(T ... values) {
        return Seq.seq(Stream.of(values));
    }

    public static <T> Seq<T> empty() {
        return Seq.seq(Stream.empty());
    }

    public static <T> Seq<T> iterate(T seed, UnaryOperator<T> f) {
        return Seq.seq(Stream.iterate(seed, f));
    }

    public static Seq<Void> generate() {
        return Seq.generate(() -> null);
    }

    public static <T> Seq<T> generate(T value) {
        return Seq.generate(() -> value);
    }

    public static <T> Seq<T> generate(Supplier<T> s) {
        return Seq.seq(Stream.generate(s));
    }

    public static <T> Seq<T> seq(Stream<T> stream) {
        if (stream instanceof Seq) {
            return (Seq)stream;
        }
        return new SeqImpl<T>(stream);
    }

    public static <T> Seq<T> seq(Iterable<T> iterable) {
        return Seq.seq(iterable.iterator());
    }

    public static <T> Seq<T> seq(Iterator<T> iterator) {
        return Seq.seq(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false));
    }

    public static <K, V> Seq<Tuple2<K, V>> seq(Map<K, V> map) {
        return Seq.seq(map.entrySet()).map((T e) -> Tuple.tuple(e.getKey(), e.getValue()));
    }

    public static <T> Seq<T> seq(Optional<T> optional) {
        return optional.map(Seq::of).orElseGet(Seq::empty);
    }

    public static <T> Seq<T> cycle(Stream<T> stream) {
        ArrayList list = new ArrayList();
        class Cycle
        implements Iterator<T> {
            boolean cycled;
            Iterator<T> it;
            final /* synthetic */ List val$list;

            Cycle(Iterator<T> iterator) {
                this.val$list = iterator;
                this.it = it;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                if (!this.it.hasNext()) {
                    this.cycled = true;
                    this.it = this.val$list.iterator();
                }
                Object next = this.it.next();
                if (!this.cycled) {
                    this.val$list.add(next);
                }
                return next;
            }
        }
        return Seq.seq(new Cycle(stream.iterator(), list));
    }

    public static <T1, T2> Tuple2<Seq<T1>, Seq<T2>> unzip(Stream<Tuple2<T1, T2>> stream) {
        return Seq.unzip(stream, (Tuple2<T1, T2> t) -> t);
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Stream<Tuple2<T1, T2>> stream, Function<T1, U1> leftUnzipper, Function<T2, U2> rightUnzipper) {
        return Seq.unzip(stream, (Tuple2<T1, T2> t) -> Tuple.tuple(leftUnzipper.apply(t.v1), rightUnzipper.apply(t.v2)));
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Stream<Tuple2<T1, T2>> stream, Function<Tuple2<T1, T2>, Tuple2<U1, U2>> unzipper) {
        return Seq.unzip(stream, (T1 t1, T2 t2) -> (Tuple2)unzipper.apply(Tuple.tuple(t1, t2)));
    }

    public static <T1, T2, U1, U2> Tuple2<Seq<U1>, Seq<U2>> unzip(Stream<Tuple2<T1, T2>> stream, BiFunction<T1, T2, Tuple2<U1, U2>> unzipper) {
        return Seq.seq(stream).map((T t) -> (Tuple2)unzipper.apply(t.v1, t.v2)).duplicate().map1(s -> s.map((T u) -> u.v1)).map2(s -> s.map((T u) -> u.v2));
    }

    public static <T1, T2> Seq<Tuple2<T1, T2>> zip(Stream<T1> left, Stream<T2> right) {
        return Seq.zip(left, right, Tuple::tuple);
    }

    public static <T1, T2, R> Seq<R> zip(Stream<T1> left, Stream<T2> right, final BiFunction<T1, T2, R> zipper) {
        final Iterator it1 = left.iterator();
        final Iterator it2 = right.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next());
            }
        }
        return Seq.seq(new Zip());
    }

    public static <T> Seq<Tuple2<T, Long>> zipWithIndex(Stream<T> stream) {
        Iterator it = stream.iterator();
        class ZipWithIndex
        implements Iterator<Tuple2<T, Long>> {
            long index;
            final /* synthetic */ Iterator val$it;

            ZipWithIndex(Iterator iterator) {
                this.val$it = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$it.hasNext();
            }

            @Override
            public Tuple2<T, Long> next() {
                return Tuple.tuple(this.val$it.next(), this.index++);
            }
        }
        return Seq.seq(new ZipWithIndex(it));
    }

    public static <T, U> U foldLeft(Stream<T> stream, U seed, BiFunction<U, ? super T, U> function) {
        Iterator it = stream.iterator();
        U result = seed;
        while (it.hasNext()) {
            result = function.apply(result, it.next());
        }
        return result;
    }

    public static <T, U> U foldRight(Stream<T> stream, U seed, BiFunction<? super T, U, U> function) {
        return (U)Seq.seq(stream).reverse().foldLeft(seed, (u, t) -> function.apply(t, u));
    }

    public static <T, U> Seq<U> scanLeft(Stream<T> stream, final U seed, final BiFunction<U, ? super T, U> function) {
        final Iterator it = stream.iterator();
        class ScanLeft
        implements Iterator<U> {
            boolean first = true;
            U value = seed;

            ScanLeft() {
            }

            @Override
            public boolean hasNext() {
                return this.first || it.hasNext();
            }

            @Override
            public U next() {
                if (this.first) {
                    this.first = false;
                } else {
                    this.value = function.apply(this.value, it.next());
                }
                return this.value;
            }
        }
        return Seq.seq(new ScanLeft());
    }

    public static <T, U> Seq<U> scanRight(Stream<T> stream, U seed, BiFunction<? super T, U, U> function) {
        return Seq.seq(stream).reverse().scanLeft(seed, (u, t) -> function.apply(t, u));
    }

    public static <T, U> Seq<T> unfold(U seed, Function<U, Optional<Tuple2<T, U>>> unfolder) {
        class Unfold
        implements Iterator<T> {
            U u;
            Optional<Tuple2<T, U>> unfolded;
            final /* synthetic */ Function val$unfolder;

            public Unfold(U u2) {
                this.val$unfolder = u2;
                this.u = u;
            }

            void unfold() {
                if (this.unfolded == null) {
                    this.unfolded = (Optional)this.val$unfolder.apply(this.u);
                }
            }

            @Override
            public boolean hasNext() {
                this.unfold();
                return this.unfolded.isPresent();
            }

            @Override
            public T next() {
                this.unfold();
                try {
                    Object T1 = this.unfolded.get().v1;
                    return T1;
                }
                finally {
                    this.u = this.unfolded.get().v2;
                    this.unfolded = null;
                }
            }
        }
        return Seq.seq(new Unfold(seed, unfolder));
    }

    public static <T> Seq<T> reverse(Stream<T> stream) {
        List<T> list = Seq.toList(stream);
        Collections.reverse(list);
        return Seq.seq(list);
    }

    public static <T> Seq<T> shuffle(Stream<T> stream) {
        List<T> list = Seq.toList(stream);
        Collections.shuffle(list);
        return Seq.seq(list);
    }

    public static <T> Seq<T> shuffle(Stream<T> stream, Random random) {
        List<T> list = Seq.toList(stream);
        Collections.shuffle(list, random);
        return Seq.seq(list);
    }

    @SafeVarargs
    public static <T> Seq<T> concat(Stream<T> ... streams) {
        if (streams == null || streams.length == 0) {
            return Seq.empty();
        }
        if (streams.length == 1) {
            return Seq.seq(streams[0]);
        }
        Stream<T> result = streams[0];
        for (int i = 1; i < streams.length; ++i) {
            result = Stream.concat(result, streams[i]);
        }
        return Seq.seq(result);
    }

    public static <T> Tuple2<Seq<T>, Seq<T>> duplicate(Stream<T> stream) {
        final LinkedList gap = new LinkedList();
        final Iterator it = stream.iterator();
        final Iterator[] ahead = new Iterator[]{null};
        class Duplicate
        implements Iterator<T> {
            Duplicate() {
            }

            @Override
            public boolean hasNext() {
                if (ahead[0] == null || ahead[0] == this) {
                    return it.hasNext();
                }
                return !gap.isEmpty();
            }

            @Override
            public T next() {
                if (ahead[0] == null) {
                    ahead[0] = this;
                }
                if (ahead[0] == this) {
                    Object value = it.next();
                    gap.offer(value);
                    return value;
                }
                return gap.poll();
            }
        }
        return Tuple.tuple(Seq.seq(new Duplicate()), Seq.seq(new Duplicate()));
    }

    public static String toString(Stream<?> stream) {
        return Seq.toString(stream, "");
    }

    public static String toString(Stream<?> stream, String separator) {
        return stream.map(Objects::toString).collect(Collectors.joining(separator));
    }

    public static <T, C extends Collection<T>> C toCollection(Stream<T> stream, Supplier<C> collectionFactory) {
        return (C)((Collection)stream.collect(Collectors.toCollection(collectionFactory)));
    }

    public static <T> List<T> toList(Stream<T> stream) {
        return stream.collect(Collectors.toList());
    }

    public static <T> Set<T> toSet(Stream<T> stream) {
        return stream.collect(Collectors.toSet());
    }

    public static <T, K, V> Map<K, V> toMap(Stream<Tuple2<K, V>> stream) {
        return stream.collect(Collectors.toMap(Tuple2::v1, Tuple2::v2));
    }

    public static <T, K, V> Map<K, V> toMap(Stream<T> stream, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return stream.collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public static <T> Seq<T> slice(Stream<T> stream, long from, long to) {
        long f = Math.max(from, 0L);
        long t = Math.max(to - f, 0L);
        return Seq.seq(stream.skip(f).limit(t));
    }

    public static <T> Seq<T> skip(Stream<T> stream, long elements) {
        return Seq.seq(stream.skip(elements));
    }

    public static <T> Seq<T> skipWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return Seq.skipUntil(stream, predicate.negate());
    }

    public static <T> Seq<T> skipUntil(Stream<T> stream, final Predicate<? super T> predicate) {
        final Iterator it = stream.iterator();
        class SkipUntil
        implements Iterator<T> {
            T next = SeqImpl.NULL;
            boolean test = false;

            SkipUntil() {
            }

            void skip() {
                while (this.next == SeqImpl.NULL && it.hasNext()) {
                    this.next = it.next();
                    if (this.test || (this.test = predicate.test(this.next))) break;
                    this.next = SeqImpl.NULL;
                }
            }

            @Override
            public boolean hasNext() {
                this.skip();
                return this.next != SeqImpl.NULL;
            }

            @Override
            public T next() {
                if (this.next == SeqImpl.NULL) {
                    throw new NoSuchElementException();
                }
                try {
                    Object t = this.next;
                    return t;
                }
                finally {
                    this.next = SeqImpl.NULL;
                }
            }
        }
        return Seq.seq(new SkipUntil());
    }

    public static <T> Seq<T> limit(Stream<T> stream, long elements) {
        return Seq.seq(stream.limit(elements));
    }

    public static <T> Seq<T> limitWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return Seq.limitUntil(stream, predicate.negate());
    }

    public static <T> Seq<T> limitUntil(Stream<T> stream, final Predicate<? super T> predicate) {
        final Iterator it = stream.iterator();
        class LimitUntil
        implements Iterator<T> {
            T next = SeqImpl.NULL;
            boolean test = false;

            LimitUntil() {
            }

            void test() {
                if (!this.test && this.next == SeqImpl.NULL && it.hasNext()) {
                    this.next = it.next();
                    this.test = predicate.test(this.next);
                    if (this.test) {
                        this.next = SeqImpl.NULL;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                this.test();
                return this.next != SeqImpl.NULL;
            }

            @Override
            public T next() {
                if (this.next == SeqImpl.NULL) {
                    throw new NoSuchElementException();
                }
                try {
                    Object t = this.next;
                    return t;
                }
                finally {
                    this.next = SeqImpl.NULL;
                }
            }
        }
        return Seq.seq(new LimitUntil());
    }

    public static <T> Seq<T> intersperse(Stream<T> stream, T value) {
        return Seq.seq(stream.flatMap((? super T t) -> Stream.of(value, t)).skip(1L));
    }

    public static <T> Tuple2<Seq<T>, Seq<T>> partition(Stream<T> stream, final Predicate<? super T> predicate) {
        final Iterator it = stream.iterator();
        final LinkedList buffer1 = new LinkedList();
        final LinkedList buffer2 = new LinkedList();
        class Partition
        implements Iterator<T> {
            final boolean b;

            Partition(boolean b) {
                this.b = b;
            }

            void fetch() {
                while (this.buffer(this.b).isEmpty() && it.hasNext()) {
                    Object next = it.next();
                    this.buffer(predicate.test(next)).offer(next);
                }
            }

            LinkedList<T> buffer(boolean test) {
                return test ? buffer1 : buffer2;
            }

            @Override
            public boolean hasNext() {
                this.fetch();
                return !this.buffer(this.b).isEmpty();
            }

            @Override
            public T next() {
                return this.buffer(this.b).poll();
            }
        }
        return Tuple.tuple(Seq.seq(new Partition(true)), Seq.seq(new Partition(false)));
    }

    public static <T> Tuple2<Seq<T>, Seq<T>> splitAt(Stream<T> stream, long position) {
        return Seq.seq(stream).zipWithIndex().partition(t -> (Long)t.v2 < position).map((T1 v1, T2 v2) -> Tuple.tuple(v1.map((T t) -> t.v1), v2.map((T t) -> t.v1)));
    }

    public static <T> Tuple2<Optional<T>, Seq<T>> splitAtHead(Stream<T> stream) {
        Iterator it = stream.iterator();
        return Tuple.tuple(it.hasNext() ? Optional.of(it.next()) : Optional.empty(), Seq.seq(it));
    }

    public static <T, U> Seq<U> ofType(Stream<T> stream, Class<U> type) {
        return Seq.seq(stream).filter(type::isInstance).map((T t) -> t);
    }

    public static <T, U> Seq<U> cast(Stream<T> stream, Class<U> type) {
        return Seq.seq(stream).map(type::cast);
    }

    public static <T, K> Map<K, List<T>> groupBy(Stream<T> stream, Function<? super T, ? extends K> classifier) {
        return Seq.seq(stream).groupBy(classifier);
    }

    public static <T, K, A, D> Map<K, D> groupBy(Stream<T> stream, Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Seq.seq(stream).groupBy(classifier, downstream);
    }

    public static <T, K, D, A, M extends Map<K, D>> M groupBy(Stream<T> stream, Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        return Seq.seq(stream).groupBy(classifier, mapFactory, downstream);
    }

    public static String join(Stream<?> stream) {
        return Seq.seq(stream).join();
    }

    public static String join(Stream<?> stream, CharSequence delimiter) {
        return Seq.seq(stream).join(delimiter);
    }

    public static String join(Stream<?> stream, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return Seq.seq(stream).join(delimiter, prefix, suffix);
    }

    @Override
    public Seq<T> filter(Predicate<? super T> var1);

    @Override
    public <R> Seq<R> map(Function<? super T, ? extends R> var1);

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> var1);

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> var1);

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    @Override
    public <R> Seq<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    @Override
    public Seq<T> distinct();

    @Override
    public Seq<T> sorted();

    @Override
    public Seq<T> sorted(Comparator<? super T> var1);

    @Override
    public Seq<T> peek(Consumer<? super T> var1);

    @Override
    public Seq<T> limit(long var1);

    @Override
    public Seq<T> skip(long var1);

    @Override
    public Seq<T> onClose(Runnable var1);

    @Override
    public void close();

    @Override
    default public Seq<T> sequential() {
        return this;
    }

    @Override
    default public Seq<T> parallel() {
        return this;
    }

    @Override
    default public Seq<T> unordered() {
        return this;
    }

    @Override
    default public Spliterator<T> spliterator() {
        return Iterable.super.spliterator();
    }

    @Override
    default public void forEach(Consumer<? super T> action) {
        Iterable.super.forEach(action);
    }
}

