/*
 * Decompiled with CFR 0.152.
 */
package org.math.array;

import org.math.array.DoubleArray;
import org.math.array.util.Function;
import org.math.array.util.Random;

public class StatisticSample
extends DoubleArray {
    protected static int[][] randomInt(int m, int n, int i0, int i1) {
        int[][] A = new int[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.randInt(i0, i1);
            }
        }
        return A;
    }

    protected static int[] randomInt(int m, int i0, int i1) {
        int[] A = new int[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.randInt(i0, i1);
        }
        return A;
    }

    public static double[][] randomUniform(int m, int n, double min, double max) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.uniform(min, max);
            }
        }
        return A;
    }

    public static double[] randomUniform(int m, double min, double max) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.uniform(min, max);
        }
        return A;
    }

    public static double[][] randomDirac(int m, int n, double[] values, double[] prob) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.dirac(values, prob);
            }
        }
        return A;
    }

    public static double[] randomDirac(int m, double[] values, double[] prob) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.dirac(values, prob);
        }
        return A;
    }

    public static double[][] randomNormal(int m, int n, double mu, double sigma) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.normal(mu, sigma);
            }
        }
        return A;
    }

    public static double[] randomNormal(int m, double mu, double sigma) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.normal(mu, sigma);
        }
        return A;
    }

    public static double[][] randomChi2(int m, int n, int d) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.chi2(d);
            }
        }
        return A;
    }

    public static double[] randomChi2(int m, int d) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.chi2(d);
        }
        return A;
    }

    public static double[][] randomLogNormal(int m, int n, double mu, double sigma) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.logNormal(mu, sigma);
            }
        }
        return A;
    }

    public static double[] randomLogNormal(int m, double mu, double sigma) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.logNormal(mu, sigma);
        }
        return A;
    }

    public static double[][] randomExponential(int m, int n, double lambda) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.exponential(lambda);
            }
        }
        return A;
    }

    public static double[] randomExponential(int m, double lambda) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.exponential(lambda);
        }
        return A;
    }

    public static double[][] randomTriangular(int m, int n, double min, double max) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.triangular(min, max);
            }
        }
        return A;
    }

    public static double[] randomTriangular(int m, double min, double max) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.triangular(min, max);
        }
        return A;
    }

    public static double[][] randomTriangular(int m, int n, double min, double med, double max) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.triangular(min, med, max);
            }
        }
        return A;
    }

    public static double[] randomTriangular(int m, double min, double med, double max) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.triangular(min, med, max);
        }
        return A;
    }

    public static double[][] randomBeta(int m, int n, double a, double b) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.beta(a, b);
            }
        }
        return A;
    }

    public static double[] randomBeta(int m, double a, double b) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.beta(a, b);
        }
        return A;
    }

    public static double[][] randomCauchy(int m, int n, double mu, double sigma) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.cauchy(mu, sigma);
            }
        }
        return A;
    }

    public static double[] randomCauchy(int m, double mu, double sigma) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.cauchy(mu, sigma);
        }
        return A;
    }

    public static double[][] randomWeibull(int m, int n, double lambda, double c) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.weibull(lambda, c);
            }
        }
        return A;
    }

    public static double[] randomWeibull(int m, double lambda, double c) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.weibull(lambda, c);
        }
        return A;
    }

    public static double[][] randomRejection(int m, int n, Function fun, double maxFun, double min, double max) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.rejection(fun, maxFun, min, max);
            }
        }
        return A;
    }

    public static double[] randomRejection(int m, Function fun, double maxFun, double min, double max) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.rejection(fun, maxFun, min, max);
        }
        return A;
    }

    public static double mean(double[] v) {
        double mean = 0.0;
        int m = v.length;
        for (int i = 0; i < m; ++i) {
            mean += v[i];
        }
        return mean /= (double)m;
    }

    public static double[] mean(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[] mean = new double[n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                mean[n2] = mean[n2] + v[i][j];
            }
        }
        int j = 0;
        while (j < n) {
            int n3 = j++;
            mean[n3] = mean[n3] / (double)m;
        }
        return mean;
    }

    public static double stddeviation(double[] v) {
        return Math.sqrt(StatisticSample.variance(v));
    }

    public static double variance(double[] v) {
        int k;
        int degrees = v.length - 1;
        int m = v.length;
        double c = 0.0;
        double s = 0.0;
        for (k = 0; k < m; ++k) {
            s += v[k];
        }
        s /= (double)m;
        for (k = 0; k < m; ++k) {
            c += (v[k] - s) * (v[k] - s);
        }
        double var = c / (double)degrees;
        return var;
    }

    public static double[] stddeviation(double[][] v) {
        double[] var = StatisticSample.variance(v);
        for (int i = 0; i < var.length; ++i) {
            var[i] = Math.sqrt(var[i]);
        }
        return var;
    }

    public static double[] variance(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[] var = new double[n];
        int degrees = m - 1;
        for (int j = 0; j < n; ++j) {
            int k;
            double c = 0.0;
            double s = 0.0;
            for (k = 0; k < m; ++k) {
                s += v[k][j];
            }
            s /= (double)m;
            for (k = 0; k < m; ++k) {
                c += (v[k][j] - s) * (v[k][j] - s);
            }
            var[j] = c / (double)degrees;
        }
        return var;
    }

    public static double covariance(double[] v1, double[] v2) {
        int k;
        int m = v1.length;
        int degrees = m - 1;
        double c = 0.0;
        double s1 = 0.0;
        double s2 = 0.0;
        for (k = 0; k < m; ++k) {
            s1 += v1[k];
            s2 += v2[k];
        }
        s1 /= (double)m;
        s2 /= (double)m;
        for (k = 0; k < m; ++k) {
            c += (v1[k] - s1) * (v2[k] - s2);
        }
        double X = c / (double)degrees;
        return X;
    }

    public static double[][] covariance(double[][] v1, double[][] v2) {
        int m = v1.length;
        int n1 = v1[0].length;
        int n2 = v2[0].length;
        double[][] X = new double[n1][n2];
        int degrees = m - 1;
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < m; ++k) {
                    s1 += v1[k][i];
                    s2 += v2[k][j];
                }
                s1 /= (double)m;
                s2 /= (double)m;
                for (k = 0; k < m; ++k) {
                    c += (v1[k][i] - s1) * (v2[k][j] - s2);
                }
                X[i][j] = c / (double)degrees;
            }
        }
        return X;
    }

    public static double[][] covariance(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[][] X = new double[n][n];
        int degrees = m - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < m; ++k) {
                    s1 += v[k][i];
                    s2 += v[k][j];
                }
                s1 /= (double)m;
                s2 /= (double)m;
                for (k = 0; k < m; ++k) {
                    c += (v[k][i] - s1) * (v[k][j] - s2);
                }
                X[i][j] = c / (double)degrees;
            }
        }
        return X;
    }

    public static double correlation(double[] v1, double[] v2) {
        return StatisticSample.covariance(v1, v2) / Math.sqrt(StatisticSample.variance(v1) * StatisticSample.variance(v2));
    }

    public static double[][] correlation(double[][] v1, double[][] v2) {
        double[] Varv1 = StatisticSample.variance(v1);
        double[] Varv2 = StatisticSample.variance(v2);
        double[][] cov = StatisticSample.covariance(v1, v2);
        for (int i = 0; i < cov.length; ++i) {
            for (int j = 0; j < cov[i].length; ++j) {
                cov[i][j] = cov[i][j] / Math.sqrt(Varv1[i] * Varv2[j]);
            }
        }
        return cov;
    }

    public static double[][] correlation(double[][] v) {
        int j;
        int i;
        int m = v.length;
        int n = v[0].length;
        double[][] X = new double[n][n];
        double[][] V = new double[n][n];
        int degrees = m - 1;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < m; ++k) {
                    s1 += v[k][i];
                    s2 += v[k][j];
                }
                s1 /= (double)m;
                s2 /= (double)m;
                for (k = 0; k < m; ++k) {
                    c += (v[k][i] - s1) * (v[k][j] - s2);
                }
                V[i][j] = c / (double)degrees;
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                X[i][j] = V[i][j] / Math.sqrt(V[i][i] * V[j][j]);
            }
        }
        return X;
    }

    public static double[][] histogram_classes(double[] values, double[] bounds) {
        return StatisticSample.mergeColumns(StatisticSample.centers(bounds), StatisticSample.histogram(values, bounds));
    }

    public static double[][] histogram_classes(double[] values, double min, double max, int n) {
        double[] bounds = StatisticSample.bounds(values, min, max, n);
        return StatisticSample.mergeColumns(StatisticSample.centers(bounds), StatisticSample.histogram(values, bounds));
    }

    public static double[][] histogram_classes(double[] values, int n) {
        double[] bounds = StatisticSample.bounds(values, n);
        return StatisticSample.mergeColumns(StatisticSample.centers(bounds), StatisticSample.histogram(values, bounds));
    }

    public static double[] histogram(double[] values, double[] bounds) {
        double[] h = new double[bounds.length - 1];
        block0: for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < h.length; ++j) {
                if (!((bounds[j + 1] - values[i]) * (bounds[j] - values[i]) < 0.0) && bounds[j] != values[i]) continue;
                int n = j;
                h[n] = h[n] + 1.0;
                continue block0;
            }
        }
        return h;
    }

    public static double[] histogram(double[] values, double min, double max, int n) {
        double[] bounds = StatisticSample.bounds(values, min, max, n);
        return StatisticSample.histogram(values, bounds);
    }

    public static double[] histogram(double[] values, int n) {
        return StatisticSample.histogram(values, n);
    }

    private static double[] bounds(double[] values, int n) {
        double min = StatisticSample.min(values);
        double max = StatisticSample.max(values);
        return StatisticSample.bounds(values, min, max, n);
    }

    private static double[] bounds(double[] values, double min, double max, int n) {
        double[] bounds = new double[n + 1];
        for (int i = 0; i < bounds.length; ++i) {
            bounds[i] = min + (max - min) * (double)i / (double)n;
        }
        return bounds;
    }

    private static double[] centers(double[] bounds) {
        double[] center = new double[bounds.length - 1];
        for (int i = 0; i < center.length; ++i) {
            center[i] = (bounds[i] + bounds[i + 1]) / 2.0;
        }
        return center;
    }
}

