/*
 * Decompiled with CFR 0.152.
 */
package org.math.array.util;

public class Sorting {
    private double[] A;
    private int[] order;

    public Sorting(double[] array, boolean copyArray) {
        if (copyArray) {
            this.A = new double[array.length];
            System.arraycopy(array, 0, this.A, 0, array.length);
        } else {
            this.A = array;
        }
        this.order = new int[this.A.length];
        for (int i = 0; i < this.A.length; ++i) {
            this.order[i] = i;
        }
        this.sort(this.A);
    }

    public static int[] invertIndex(int[] ind) {
        int[] invind = new int[ind.length];
        for (int i = 0; i < ind.length; ++i) {
            invind[ind[i]] = i;
        }
        return invind;
    }

    public int getIndex(int i) {
        return this.order[i];
    }

    public int[] getIndex() {
        return this.order;
    }

    private void QuickSort(double[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            double mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.QuickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.QuickSort(a, lo, hi0);
            }
        }
    }

    private void swap(double[] a, int i, int j) {
        double T = a[i];
        a[i] = a[j];
        a[j] = T;
        int t = this.order[i];
        this.order[i] = this.order[j];
        this.order[j] = t;
    }

    private void sort(double[] a) {
        this.QuickSort(a, 0, a.length - 1);
    }

    public static void main(String[] args) {
        int i;
        double[] a = new double[]{0.1, 0.2, 0.3, 0.5, 0.4, 0.2, 0.05, 0.0};
        Sorting s = new Sorting(a, true);
        System.out.println("Initial array : ");
        for (i = 0; i < a.length; ++i) {
            System.out.println("a(" + i + ") = " + a[i]);
        }
        System.out.println("Sorted array : ");
        for (i = 0; i < a.length; ++i) {
            System.out.println("a(" + s.getIndex(i) + ") = " + a[s.getIndex(i)]);
        }
    }
}

