/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.java2objc.examples.main;

import com.google.code.java2objc.examples.main.PatternBasedFilenameFilter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.googlecode.java2objc.main.Config;
import com.googlecode.java2objc.main.Main;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class ObjcCodeGeneratorMain {
    public static void main(String[] args) throws Exception {
        Config config = new Config();
        config.update("--outputdir=target/generated");
        String path = "src/main/java/com/google/code/java2objc/examples/";
        ArrayList javaFiles = Lists.newArrayList();
        FilenameFilter filterForJavaFiles = PatternBasedFilenameFilter.getFilterForJavaFiles();
        ObjcCodeGeneratorMain.addFilesInDirectory(javaFiles, path + "lang/", filterForJavaFiles);
        ObjcCodeGeneratorMain.addFilesInDirectory(javaFiles, path + "inheritance/", filterForJavaFiles);
        Main main = new Main(config, (Collection)javaFiles);
        main.execute();
    }

    public static void addFilesInDirectory(Collection<String> files, String pathToDir, FilenameFilter filter) throws IOException {
        File dir = new File(pathToDir);
        Preconditions.checkArgument((boolean)dir.isDirectory());
        for (String file : dir.list(filter)) {
            files.add(pathToDir + file);
        }
    }
}

