/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.Serializable;
import org.ejml.data.Matrix64F;
import org.ejml.data.ReshapeMatrix64F;

public class DenseD2Matrix64F
extends ReshapeMatrix64F
implements Serializable {
    public double[][] data;

    public DenseD2Matrix64F(int numRows, int numCols) {
        this.data = new double[numRows][numCols];
        this.numRows = numRows;
        this.numCols = numCols;
    }

    public void reshape(int numRows, int numCols, boolean saveValues) {
        if (numRows > this.data.length) {
            throw new IllegalArgumentException("Requested number of rows is too great.");
        }
        this.numRows = numRows;
        if (numCols > this.data[0].length) {
            throw new IllegalArgumentException("Requested number of columns is too great.");
        }
        this.numCols = numCols;
    }

    public double get(int row, int col) {
        return this.data[row][col];
    }

    public void set(int row, int col, double val) {
        this.data[row][col] = val;
    }

    public double unsafe_get(int row, int col) {
        return this.get(row, col);
    }

    public void unsafe_set(int row, int col, double val) {
        this.set(row, col, val);
    }

    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    public void print() {
    }

    public <T extends Matrix64F> T copy() {
        return null;
    }
}

