/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.googleplus;

import com.googlecode.googleplus.GooglePlusConfiguration;
import com.googlecode.googleplus.GooglePlusFactory;
import com.googlecode.googleplus.Plus;
import com.googlecode.googleplus.impl.PlusImpl;
import com.googlecode.googleplus.model.person.PeopleCollection;
import java.net.UnknownHostException;
import org.apache.http.conn.ConnectTimeoutException;
import org.junit.After;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ConfigurationTest {
    @Test
    public void configurationTimeoutTest() throws Exception {
        block2: {
            GooglePlusConfiguration config = new GooglePlusConfiguration();
            config.setConnectTimeout(10);
            config.setReadTimeout(10);
            PlusImpl plus = new PlusImpl("", config, null);
            plus.init();
            try {
                plus.getPeopleOperations().list("me", PeopleCollection.VISIBLE);
            }
            catch (Exception ex) {
                if (ex.getCause().getClass() == ConnectTimeoutException.class) break block2;
                throw ex;
            }
        }
    }

    @Test
    public void proxyTest() throws Exception {
        block2: {
            GooglePlusConfiguration config = new GooglePlusConfiguration();
            config.setProxyHost("foo");
            config.setProxyPort(80);
            GooglePlusFactory factory = new GooglePlusFactory("", "", config);
            Plus plus = factory.getApi("", "", null);
            try {
                plus.getPeopleOperations().list("me", PeopleCollection.VISIBLE);
            }
            catch (Exception ex) {
                if (ex.getCause().getClass() == UnknownHostException.class) break block2;
                throw ex;
            }
        }
    }

    @After
    public void cleanup() {
        System.getProperties().remove("http.proxyHost");
        System.getProperties().remove("http.proxyPort");
    }
}

