/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.googleplus.impl;

import com.googlecode.googleplus.ActivityOperations;
import com.googlecode.googleplus.Paging;
import com.googlecode.googleplus.PlusUtils;
import com.googlecode.googleplus.model.OrderBy;
import com.googlecode.googleplus.model.activity.Activity;
import com.googlecode.googleplus.model.activity.ActivityCollection;
import com.googlecode.googleplus.model.activity.ActivityFeed;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class ActivityOperationsImpl
implements ActivityOperations {
    private static final String LIST_URL = "https://www.googleapis.com/plus/v1/people/{userId}/activities/{collection}";
    private static final String GET_URL = "https://www.googleapis.com/plus/v1/activities/{activityId}";
    private static final String SEARCH_URL = "https://www.googleapis.com/plus/v1/activities";
    private RestTemplate restTemplate;

    public ActivityOperationsImpl(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public ActivityFeed list(String userId, ActivityCollection collection, Paging paging) {
        Assert.notNull((Object)userId);
        Assert.notNull((Object)((Object)collection));
        Map<String, String> params = PlusUtils.createParamMap(paging);
        return (ActivityFeed)this.restTemplate.getForObject(PlusUtils.addParameters(LIST_URL, params), ActivityFeed.class, new Object[]{userId, collection.getCollectionName()});
    }

    public ActivityFeed list(String userId, ActivityCollection collection) {
        return this.list(userId, collection, null);
    }

    public Activity get(String activityId) {
        return (Activity)this.restTemplate.getForObject(GET_URL, Activity.class, new Object[]{activityId});
    }

    public ActivityFeed search(String query, OrderBy orderBy) {
        return this.search(query, orderBy, null);
    }

    public ActivityFeed search(String query, OrderBy orderBy, Paging paging) {
        Map<String, String> params = PlusUtils.createParamMap(paging);
        if (orderBy != null) {
            params.put("orderBy", orderBy.getOrderBy());
        }
        if (query != null) {
            params.put("query", query);
        }
        return (ActivityFeed)this.restTemplate.getForObject(PlusUtils.addParameters(SEARCH_URL, params), ActivityFeed.class, new Object[0]);
    }
}

