/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.util.GraphqlUtils;
import java.io.IOException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class GraphQLReactiveWebSocketHandler<R, T>
implements WebSocketHandler,
CoreSubscriber<WebSocketMessage> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    GraphqlUtils graphqlUtils = GraphqlUtils.graphqlUtils;
    final String request;
    final String subscriptionName;
    final SubscriptionCallback<T> subscriptionCallback;
    Sinks.One<Void> subscriptionMono = Sinks.one();
    ObjectMapper objectMapper = new ObjectMapper();
    final Class<R> subscriptionType;
    final Class<T> messageType;
    WebSocketSession session = null;

    public GraphQLReactiveWebSocketHandler(String request, String subscriptionName, SubscriptionCallback<T> subscriptionCallback, Class<R> subscriptionType, Class<T> messsageType) {
        this.request = request;
        this.subscriptionName = subscriptionName;
        this.subscriptionCallback = subscriptionCallback;
        this.subscriptionType = subscriptionType;
        this.messageType = messsageType;
    }

    public Mono<Void> handle(WebSocketSession session) {
        this.session = session;
        Mono input = session.receive().doOnNext(message -> this.onNext((WebSocketMessage)message)).doOnError(t -> this.onError((Throwable)t)).doOnComplete(() -> this.onComplete()).doOnSubscribe(s -> this.onSubscribe((Subscription)s)).then();
        this.logger.trace("Before sending the subscription request into the web socket");
        session.send((Publisher)Flux.just((Object)this.request).map(arg_0 -> ((WebSocketSession)session).textMessage(arg_0))).subscribeOn(Schedulers.single()).subscribe();
        this.logger.trace("After sending the subscription request into the web socket");
        this.logger.trace("End of handle(session) method execution");
        return input;
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    public void onNext(WebSocketMessage message) {
        this.logger.trace("Message received from the Web Socket: {} (on session {})", (Object)message, (Object)this.session);
        String msg = message.getPayloadAsText();
        try {
            Object r = this.objectMapper.readValue(msg, this.subscriptionType);
            Object t = this.graphqlUtils.invokeGetter(r, this.subscriptionName);
            this.subscriptionCallback.onMessage(t);
        }
        catch (IOException e) {
            String errorMsg = "An error (" + e.getMessage() + ") occured while parsing a server message for subscription '" + this.subscriptionName + "'";
            if (this.logger.isTraceEnabled()) {
                errorMsg = errorMsg + ". The received message is <" + msg + ">";
            }
            this.logger.error(errorMsg);
            this.subscriptionCallback.onError(new GraphQLRequestExecutionException(errorMsg, e));
        }
    }

    public void onError(Throwable t) {
        this.logger.trace("Error received for WebSocketSession {}: {}", (Object)this.session, (Object)t.getMessage());
        this.subscriptionCallback.onError(t);
        this.subscriptionMono.tryEmitError(t);
    }

    public void onComplete() {
        this.logger.trace("onComplete received for WebSocketSession {}: {}", (Object)this.session);
        this.subscriptionCallback.onClose(0, "onComplete");
        Sinks.EmitResult result = this.subscriptionMono.tryEmitEmpty();
        try {
            result.orThrow();
        }
        catch (Exception e) {
            RuntimeException e2 = new RuntimeException("Error while emitting to the subscription Mono", e);
            this.subscriptionCallback.onError(e2);
        }
    }

    public void onSubscribe(Subscription s) {
        this.subscriptionCallback.onConnect();
    }
}

