/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.customscalars;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GraphQLScalarTypeDate {
    public static GraphQLScalarType Date = GraphQLScalarType.newScalar().name("Date").description("Custom Scalar for Date management. It serializes dates in String, formatted as: YYYY-MM-DD.").coercing((Coercing)new Coercing<Date, String>(){
        static final String DATE_PATTERN = "yyyy-MM-dd";
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");

        public String serialize(Object input) throws CoercingSerializeException {
            if (!(input instanceof Date)) {
                throw new CoercingSerializeException("Can't parse the '" + input.toString() + "' Date to a String (it should be a Date but is a " + input.getClass().getName() + ")");
            }
            return this.formater.format((Date)input);
        }

        public Date parseValue(Object o) throws CoercingParseValueException {
            if (!(o instanceof String)) {
                throw new CoercingParseValueException("Can't parse the '" + o.toString() + "' string to a Date (it should be a String but is a " + o.getClass().getName() + ")");
            }
            try {
                return this.formater.parse((String)o);
            }
            catch (ParseException e) {
                throw new CoercingParseValueException(e.getMessage(), (Throwable)e);
            }
        }

        public Date parseLiteral(Object o) throws CoercingParseLiteralException {
            if (!(o instanceof StringValue)) {
                throw new CoercingParseValueException("Can't parse the '" + o.toString() + "' string value to a Date (it should be a StringValue but is a " + o.getClass().getName() + ")");
            }
            try {
                return this.formater.parse(((StringValue)o).getValue());
            }
            catch (ParseException e) {
                throw new CoercingParseValueException(e.getMessage(), (Throwable)e);
            }
        }
    }).build();
}

